/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.utils.IoUtils;

interface CliCache {
    public static final Path DEFAULT_TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    public static final Path ROOT_CACHE_DIR = DEFAULT_TEMP_DIR.resolve("smithy-cache");

    public static CliCache getTemplateCache() {
        return () -> ROOT_CACHE_DIR.resolve("templates");
    }

    public Path getPath();

    default public boolean clear() {
        return IoUtils.rmdir((Path)this.getPath());
    }

    default public Path get() {
        Path cachePath = this.getPath();
        if (Files.exists(cachePath, new LinkOption[0])) {
            return cachePath;
        }
        try {
            return Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CliError("Could not create cache at path: " + cachePath);
        }
    }

    public static boolean clearAll() {
        return IoUtils.rmdir((Path)ROOT_CACHE_DIR);
    }
}

