/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.StandardOptions;

final class LoggingArgumentsHandler
implements Arguments {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private final Arguments delegate;
    private boolean configuredLogging;
    private final List<Runnable> restoreFunctions = new ArrayList<Runnable>();
    private final Logger rootLogger = Logger.getLogger("");
    private final Handler smithyHandler;

    LoggingArgumentsHandler(ColorFormatter colors, CliPrinter stderr, Arguments delegate) {
        this.delegate = delegate;
        this.smithyHandler = new CliLogHandler(new BasicFormatter(), colors, stderr);
        this.rootLogger.addHandler(this.smithyHandler);
        this.restoreFunctions.add(() -> this.rootLogger.removeHandler(this.smithyHandler));
        for (Handler h : this.rootLogger.getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            this.rootLogger.removeHandler(h);
            this.restoreFunctions.add(() -> this.rootLogger.addHandler(h));
        }
    }

    @Override
    public void addReceiver(ArgumentReceiver receiver) {
        this.delegate.addReceiver(receiver);
    }

    @Override
    public boolean hasReceiver(Class<? extends ArgumentReceiver> receiverClass) {
        return this.delegate.hasReceiver(receiverClass);
    }

    @Override
    public <T extends ArgumentReceiver> T getReceiver(Class<T> type) {
        return this.delegate.getReceiver(type);
    }

    @Override
    public Iterable<ArgumentReceiver> getReceivers() {
        return this.delegate.getReceivers();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public String peek() {
        return this.delegate.peek();
    }

    @Override
    public String shift() {
        return this.delegate.shift();
    }

    @Override
    public String shiftFor(String parameter) {
        return this.delegate.shiftFor(parameter);
    }

    @Override
    public List<String> getPositional() {
        List<String> result = this.delegate.getPositional();
        if (!this.configuredLogging) {
            this.configuredLogging = true;
            this.configureLogging(this.delegate.getReceiver(StandardOptions.class));
        }
        return result;
    }

    void restoreLogging() {
        for (Runnable runnable : this.restoreFunctions) {
            runnable.run();
        }
        this.restoreFunctions.clear();
    }

    private void configureLogging(StandardOptions options) {
        Level level = options.logging();
        Level previousRootLevel = this.rootLogger.getLevel();
        this.restoreFunctions.add(() -> this.rootLogger.setLevel(previousRootLevel));
        this.rootLogger.setLevel(level);
        for (Handler h : this.rootLogger.getHandlers()) {
            if (h.getLevel() == level) continue;
            Level currentLevel = h.getLevel();
            this.restoreFunctions.add(() -> h.setLevel(currentLevel));
            h.setLevel(level);
        }
        if (level == Level.OFF) {
            this.rootLogger.removeHandler(this.smithyHandler);
        } else if (options.debug()) {
            this.smithyHandler.setFormatter(new DebugFormatter());
        }
    }

    private static final class CliLogHandler
    extends Handler {
        private final ColorFormatter colors;
        private final CliPrinter printer;

        CliLogHandler(Formatter formatter, ColorFormatter colors, CliPrinter printer) {
            this.colors = colors;
            this.printer = printer;
            this.setFormatter(formatter);
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                String formatted = this.getFormatter().format(record);
                if (record.getLevel().equals(Level.SEVERE)) {
                    this.colors.println(this.printer, formatted, ColorTheme.ERROR);
                } else if (record.getLevel().equals(Level.WARNING)) {
                    this.colors.println(this.printer, formatted, ColorTheme.WARNING);
                } else {
                    this.printer.println(formatted);
                }
                this.printer.flush();
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static final class DebugFormatter
    extends SimpleFormatter {
        private DebugFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            StringBuilder result = new StringBuilder();
            result.append(FORMAT.format(new Date(r.getMillis())));
            result.append(' ');
            result.append('[');
            result.append(Thread.currentThread().getName());
            result.append(']');
            result.append(' ');
            result.append(r.getLevel().getLocalizedName());
            result.append(' ');
            result.append(r.getLoggerName());
            result.append(' ');
            result.append('-');
            result.append(' ');
            result.append(r.getMessage());
            return result.toString();
        }
    }

    private static final class BasicFormatter
    extends SimpleFormatter {
        private BasicFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return '[' + r.getLevel().getLocalizedName() + "] " + r.getMessage();
        }
    }
}

