/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.smithy.cli.shaded.eclipse.aether.MultiRuntimeException;
import software.amazon.smithy.cli.shaded.eclipse.aether.impl.RepositorySystemLifecycle;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named
public class DefaultRepositorySystemLifecycle
implements RepositorySystemLifecycle {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<Runnable> onSystemEndedHandlers = new CopyOnWriteArrayList();

    @Inject
    public DefaultRepositorySystemLifecycle() {
    }

    @Override
    public void systemEnded() {
        if (this.shutdown.compareAndSet(false, true)) {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (Runnable onCloseHandler : this.onSystemEndedHandlers) {
                try {
                    onCloseHandler.run();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            MultiRuntimeException.mayThrow("system on-close handler failures", exceptions);
        }
    }

    @Override
    public void addOnSystemEndedHandler(Runnable handler) {
        Objects.requireNonNull(handler, "handler cannot be null");
        this.requireNotShutdown();
        this.onSystemEndedHandlers.add(0, handler);
    }

    private void requireNotShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("repository system is already shut down");
        }
    }
}

