/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.build.ProjectionResult;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.ConfigOptions;
import software.amazon.smithy.cli.commands.HelpActionWrapper;
import software.amazon.smithy.cli.commands.ModelBuilder;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.SmithyIdlModelSerializer;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResultException;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SimpleParser;
import software.amazon.smithy.utils.StringUtils;

final class MigrateCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(MigrateCommand.class.getName());
    private static final Pattern VERSION_1 = Pattern.compile("(?m)^\\s*\\$\\s*version:\\s*\"1(\\.0)?\"\\s*$");
    private static final Pattern VERSION_2 = Pattern.compile("(?m)^\\s*\\$\\s*version:\\s*\"2(\\.0)?\"\\s*$");
    private final String parentCommandName;

    MigrateCommand(String parentCommandName) {
        this.parentCommandName = parentCommandName;
    }

    static Command createDeprecatedAlias(final Command command) {
        return new Command(){

            @Override
            public String getName() {
                return "upgrade-1-to-2";
            }

            @Override
            public String getSummary() {
                return command.getSummary();
            }

            @Override
            public int execute(Arguments arguments, Command.Env env) {
                if (!arguments.getReceiver(StandardOptions.class).quiet()) {
                    env.colors().style(env.stderr(), "upgrade-1-to-2 is deprecated. Use the migrate command instead." + System.lineSeparator(), ColorTheme.DEPRECATED);
                    env.stderr().flush();
                }
                return command.execute(arguments, env);
            }

            @Override
            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public String getName() {
        return "migrate";
    }

    @Override
    public String getSummary() {
        return "Migrate Smithy IDL models from 1.0 to 2.0 in place.";
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        arguments.addReceiver(new ConfigOptions());
        arguments.addReceiver(new BuildOptions());
        HelpActionWrapper action = HelpActionWrapper.fromCommand(this, this.parentCommandName, this::run);
        return action.apply(arguments, env);
    }

    private int run(Arguments arguments, Command.Env env) {
        Path tempDir;
        List<String> models = arguments.getPositional();
        ClassLoader classLoader = env.classLoader();
        ConfigOptions configOptions = arguments.getReceiver(ConfigOptions.class);
        SmithyBuildConfig smithyBuildConfig = configOptions.createSmithyBuildConfig();
        SmithyBuildConfig.Builder configBuilder = smithyBuildConfig.toBuilder();
        try {
            tempDir = Files.createTempDirectory("smithyMigrate", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CliError("Unable to create temporary working directory: " + e);
        }
        configBuilder.outputDirectory(tempDir.toString());
        SmithyBuildConfig temporaryConfig = configBuilder.build();
        Model initialModel = new ModelBuilder().config(smithyBuildConfig).arguments(arguments).env(env).models(models).validationPrinter(env.stderr()).severity(Severity.DANGER).build();
        SmithyBuild smithyBuild = SmithyBuild.create((ClassLoader)classLoader).config(temporaryConfig).projectionFilter(name -> name.equals("source")).modelAssemblerSupplier(() -> {
            ModelAssembler assembler = Model.assembler();
            assembler.putProperty("assembler.allowUnknownTraits", (Object)true);
            return assembler;
        }).model(initialModel);
        ResultConsumer resultConsumer = new ResultConsumer();
        smithyBuild.build((Consumer)resultConsumer, (BiConsumer)resultConsumer);
        Model finalizedModel = resultConsumer.getResult().getModel();
        List<Path> resolvedModelFiles = this.resolveModelFiles(finalizedModel, models);
        ModelAssembler assembler = ModelBuilder.createModelAssembler(classLoader);
        smithyBuildConfig.getImports().forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ArrayList<Pair> upgradedModels = new ArrayList<Pair>();
        for (Path modelFilePath : resolvedModelFiles) {
            String upgradedModelString = this.upgradeFile(finalizedModel, modelFilePath);
            upgradedModels.add(Pair.of((Object)modelFilePath, (Object)upgradedModelString));
            assembler.addUnparsedModel(modelFilePath.toAbsolutePath().toString(), upgradedModelString);
        }
        try {
            assembler.assemble().validate();
        }
        catch (ValidatedResultException e) {
            throw new RuntimeException("Upgraded Smithy models are invalid. Please report the following errors to Smithy team.\n" + e.getMessage());
        }
        for (Pair upgradedModel : upgradedModels) {
            this.writeMigratedFile((String)upgradedModel.right, (Path)upgradedModel.left);
        }
        return 0;
    }

    private List<Path> resolveModelFiles(Model model, List<String> modelFilesOrDirectories) {
        Set absoluteModelFilesOrDirectories = modelFilesOrDirectories.stream().map(path -> Paths.get(path, new String[0]).toAbsolutePath()).collect(Collectors.toSet());
        return model.shapes().filter(shape -> !Prelude.isPreludeShape((ToShapeId)shape)).filter(shape -> !shape.getSourceLocation().getFilename().startsWith("jar:")).map(shape -> Paths.get(shape.getSourceLocation().getFilename(), new String[0]).toAbsolutePath()).distinct().filter(locationPath -> {
            for (Path inputPath : absoluteModelFilesOrDirectories) {
                if (locationPath.startsWith(inputPath)) continue;
                LOGGER.finest("Skipping non-target model file: " + locationPath);
                return false;
            }
            if (!locationPath.toString().endsWith(".smithy")) {
                LOGGER.info("Skipping non-IDL model file: " + locationPath);
                return false;
            }
            return true;
        }).sorted().collect(Collectors.toList());
    }

    private void writeMigratedFile(String upgradeFileString, Path filePath) {
        try {
            Files.write(filePath, upgradeFileString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CliError(String.format("Unable to write migrated model file to %s: %s", filePath, e));
        }
    }

    String upgradeFile(Model completeModel, Path filePath) {
        String contents = IoUtils.readUtf8File((Path)filePath);
        if (VERSION_2.matcher(contents).find()) {
            return contents;
        }
        ShapeMigrateVisitor visitor = new ShapeMigrateVisitor(completeModel, contents);
        completeModel.shapes().filter(shape -> shape.getSourceLocation().getFilename().equals(filePath.toString())).sorted(Comparator.comparing(Shape::getSourceLocation).reversed()).forEach(shape -> shape.accept((ShapeVisitor)visitor));
        return this.updateVersion(visitor.getModelString());
    }

    private String updateVersion(String modelString) {
        Matcher matcher = VERSION_1.matcher(modelString);
        if (matcher.find()) {
            return matcher.replaceFirst(String.format("\\$version: \"2.0\"%n", new Object[0]));
        }
        return String.format("$version: \"2.0\"%n%n", new Object[0]) + modelString;
    }

    private static final class ResultConsumer
    implements Consumer<ProjectionResult>,
    BiConsumer<String, Throwable> {
        private Throwable error;
        private ProjectionResult result;

        private ResultConsumer() {
        }

        @Override
        public void accept(String name, Throwable throwable) {
            this.error = throwable;
        }

        @Override
        public void accept(ProjectionResult projectionResult) {
            this.result = projectionResult;
        }

        ProjectionResult getResult() {
            if (this.error != null) {
                throw new RuntimeException(this.error);
            }
            return this.result;
        }
    }

    private static class ShapeMigrateVisitor
    extends ShapeVisitor.Default<Void> {
        private final Model completeModel;
        private final ModelWriter writer;

        ShapeMigrateVisitor(Model completeModel, String modelString) {
            this.completeModel = completeModel;
            this.writer = new ModelWriter(modelString);
        }

        String getModelString() {
            return this.writer.flush();
        }

        protected Void getDefault(Shape shape) {
            if (shape.hasTrait(BoxTrait.class)) {
                this.writer.eraseTrait(shape, shape.expectTrait(BoxTrait.class));
            } else if (this.hasSyntheticDefault(shape)) {
                this.addDefault(shape, shape.getType());
            }
            shape.members().stream().sorted(Comparator.comparing(Shape::getSourceLocation).reversed()).forEach(this::handleMemberShape);
            return null;
        }

        private void handleMemberShape(MemberShape shape) {
            if (this.hasSyntheticDefault((Shape)shape)) {
                this.addDefault((Shape)shape, this.completeModel.expectShape(shape.getTarget()).getType());
            }
            if (shape.hasTrait(BoxTrait.class)) {
                this.writer.eraseTrait((Shape)shape, shape.expectTrait(BoxTrait.class));
            }
        }

        private boolean hasSyntheticDefault(Shape shape) {
            Optional<SourceLocation> defaultLocation = shape.getTrait(DefaultTrait.class).map(FromSourceLocation::getSourceLocation);
            return defaultLocation.filter(location -> shape.getSourceLocation().equals(location)).isPresent();
        }

        private void addDefault(Shape shape, ShapeType targetType) {
            SourceLocation memberLocation = shape.getSourceLocation();
            String padding = "";
            if (memberLocation.getColumn() > 1) {
                padding = StringUtils.repeat((char)' ', (int)(memberLocation.getColumn() - 1));
            }
            String defaultValue = "";
            if (shape.hasTrait(BoxTrait.class)) {
                defaultValue = "null";
            } else {
                switch (targetType) {
                    case BOOLEAN: {
                        defaultValue = "false";
                        break;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        defaultValue = "0";
                        break;
                    }
                    case BLOB: 
                    case STRING: {
                        defaultValue = "\"\"";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected default: " + targetType);
                    }
                }
            }
            this.writer.insertLine(shape.getSourceLocation().getLine(), padding + "@default(" + defaultValue + ")");
        }

        public Void memberShape(MemberShape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (!shape.hasTrait(EnumTrait.class)) {
                return null;
            }
            EnumTrait enumTrait = (EnumTrait)shape.expectTrait(EnumTrait.class);
            if (!((EnumDefinition)enumTrait.getValues().iterator().next()).getName().isPresent()) {
                return null;
            }
            this.writer.insertLine(shape.getSourceLocation().getLine() + 1, this.serializeEnum(shape));
            this.writer.eraseLine(shape.getSourceLocation().getLine());
            this.writer.eraseTrait((Shape)shape, (Trait)enumTrait);
            return null;
        }

        public Void setShape(SetShape shape) {
            this.getDefault((Shape)shape);
            this.writer.erase(shape.getSourceLocation(), 3);
            this.writer.insert(shape.getSourceLocation(), "@uniqueItems" + System.lineSeparator() + "list");
            return null;
        }

        private String serializeEnum(StringShape shape) {
            StringShape stripped = ((StringShape.Builder)((StringShape.Builder)shape.toBuilder().clearTraits()).addTrait(shape.expectTrait(EnumTrait.class))).build();
            Model model = (Model)Model.assembler().addShapes(new Shape[]{stripped}).assemble().unwrap();
            model = ModelTransformer.create().changeStringEnumsToEnumShapes(model);
            Map files = SmithyIdlModelSerializer.builder().build().serialize(model);
            String serialized = (String)files.values().iterator().next();
            ArrayList<String> lines = new ArrayList<String>();
            boolean foundEnum = false;
            for (String line : serialized.split("\\r?\\n")) {
                if (foundEnum) {
                    lines.add(line);
                    continue;
                }
                if (!line.startsWith("enum")) continue;
                lines.add(line);
                foundEnum = true;
            }
            return String.join((CharSequence)System.lineSeparator(), lines);
        }
    }

    private static class ModelWriter {
        private String contents;

        ModelWriter(String contents) {
            this.contents = contents;
        }

        public String flush() {
            if (!this.contents.endsWith(System.lineSeparator())) {
                this.contents = this.contents + System.lineSeparator();
            }
            return this.contents;
        }

        private void insertLine(int lineNumber, String line) {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(this.contents.split("\\r?\\n")));
            lines.add(lineNumber - 1, line);
            this.contents = String.join((CharSequence)System.lineSeparator(), lines);
        }

        private void insert(SourceLocation from, String value) {
            IdlAwareSimpleParser parser = new IdlAwareSimpleParser(this.contents);
            parser.rewind(from);
            int fromPosition = parser.position();
            this.contents = this.contents.substring(0, fromPosition) + value + this.contents.substring(fromPosition);
        }

        private void eraseLine(int lineNumber) {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(this.contents.split("\\r?\\n")));
            lines.remove(lineNumber - 1);
            this.contents = String.join((CharSequence)System.lineSeparator(), lines);
        }

        private void eraseTrait(Shape shape, Trait trait) {
            if (trait.getSourceLocation() != SourceLocation.NONE) {
                SourceLocation to = this.findLocationAfterTrait(shape, trait.getClass());
                this.erase(trait.getSourceLocation(), to);
            }
        }

        private SourceLocation findLocationAfterTrait(Shape shape, Class<? extends Trait> target) {
            boolean haveSeenTarget = false;
            ArrayList traits = new ArrayList(shape.getIntroducedTraits().values());
            traits.sort(Comparator.comparing(FromSourceLocation::getSourceLocation));
            for (Trait trait : traits) {
                if (target.isInstance(trait)) {
                    haveSeenTarget = true;
                    continue;
                }
                if (!haveSeenTarget || trait.getSourceLocation().equals((Object)SourceLocation.NONE)) continue;
                return trait.getSourceLocation();
            }
            return shape.getSourceLocation();
        }

        private void erase(SourceLocation from, SourceLocation to) {
            IdlAwareSimpleParser parser = new IdlAwareSimpleParser(this.contents);
            parser.rewind(from);
            int fromPosition = parser.position();
            parser.rewind(to);
            int toPosition = parser.position();
            this.contents = this.contents.substring(0, fromPosition) + this.contents.substring(toPosition);
        }

        private void erase(SourceLocation from, int size) {
            IdlAwareSimpleParser parser = new IdlAwareSimpleParser(this.contents);
            parser.rewind(from);
            int fromPosition = parser.position();
            SourceLocation to = new SourceLocation(from.getFilename(), from.getLine(), from.getColumn() + size);
            parser.rewind(to);
            int toPosition = parser.position();
            this.contents = this.contents.substring(0, fromPosition) + this.contents.substring(toPosition);
        }

        private void replace(int from, int to, String with) {
            this.contents = this.contents.substring(0, from) + with + this.contents.substring(to);
        }
    }

    private static class IdlAwareSimpleParser
    extends SimpleParser {
        IdlAwareSimpleParser(String expression) {
            super((CharSequence)expression);
        }

        public void rewind(SourceLocation location) {
            this.rewind(0, 1, 1);
            while (!(this.eof() || this.line() == location.getLine() && this.column() == location.getColumn())) {
                this.skip();
            }
            if (this.eof()) {
                throw this.syntax("Expected a source location, but was EOF");
            }
        }

        public void ws() {
            block4: while (!this.eof()) {
                switch (this.peek()) {
                    case '/': {
                        if (this.peek(1) == '/') {
                            this.consumeRemainingCharactersOnLine();
                            continue block4;
                        }
                        return;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ',': {
                        this.skip();
                        continue block4;
                    }
                }
                return;
            }
        }
    }
}

