/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.StringJoiner;

public interface Style {
    public static final Style BOLD = new Constant("1");
    public static final Style FAINT = new Constant("2");
    public static final Style ITALIC = new Constant("3");
    public static final Style UNDERLINE = new Constant("4");
    public static final Style BLACK = new Constant("30");
    public static final Style RED = new Constant("31");
    public static final Style GREEN = new Constant("32");
    public static final Style YELLOW = new Constant("33");
    public static final Style BLUE = new Constant("34");
    public static final Style MAGENTA = new Constant("35");
    public static final Style CYAN = new Constant("36");
    public static final Style WHITE = new Constant("37");
    public static final Style BRIGHT_BLACK = new Constant("90");
    public static final Style BRIGHT_RED = new Constant("91");
    public static final Style BRIGHT_GREEN = new Constant("92");
    public static final Style BRIGHT_YELLOW = new Constant("93");
    public static final Style BRIGHT_BLUE = new Constant("94");
    public static final Style BRIGHT_MAGENTA = new Constant("95");
    public static final Style BRIGHT_CYAN = new Constant("96");
    public static final Style BRIGHT_WHITE = new Constant("97");
    public static final Style BG_BLACK = new Constant("40");
    public static final Style BG_RED = new Constant("41");
    public static final Style BG_GREEN = new Constant("42");
    public static final Style BG_YELLOW = new Constant("43");
    public static final Style BG_BLUE = new Constant("44");
    public static final Style BG_MAGENTA = new Constant("45");
    public static final Style BG_CYAN = new Constant("46");
    public static final Style BG_WHITE = new Constant("47");
    public static final Style BG_BRIGHT_BLACK = new Constant("100");
    public static final Style BG_BRIGHT_RED = new Constant("101");
    public static final Style BG_BRIGHT_GREEN = new Constant("102");
    public static final Style BG_BRIGHT_YELLOW = new Constant("103");
    public static final Style BG_BRIGHT_BLUE = new Constant("104");
    public static final Style BG_BRIGHT_MAGENTA = new Constant("105");
    public static final Style BG_BRIGHT_CYAN = new Constant("106");
    public static final Style BG_BRIGHT_WHITE = new Constant("107");

    public String getAnsiColorCode();

    public static Style of(Style ... styles) {
        if (styles.length == 1) {
            return styles[0];
        }
        return new Multi(styles);
    }

    public static final class Multi
    implements Style {
        private final String ansiStyle;

        public Multi(Style ... styles) {
            if (styles.length == 1) {
                this.ansiStyle = styles[0].getAnsiColorCode();
            } else {
                StringJoiner joiner = new StringJoiner(";");
                for (Style style : styles) {
                    joiner.add(style.getAnsiColorCode());
                }
                this.ansiStyle = joiner.toString();
            }
        }

        @Override
        public String getAnsiColorCode() {
            return this.ansiStyle;
        }
    }

    public static final class Constant
    implements Style {
        private final String ansiColorCode;

        public Constant(String ansiColorCode) {
            this.ansiColorCode = ansiColorCode;
        }

        @Override
        public String getAnsiColorCode() {
            return this.ansiColorCode;
        }
    }
}

