/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.slf4j;

import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.log.Logger;
import software.amazon.smithy.cli.shaded.eclipse.sisu.Nullable;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;
import software.amazon.smithy.cli.shaded.slf4j.ILoggerFactory;
import software.amazon.smithy.cli.shaded.slf4j.LoggerFactory;
import software.amazon.smithy.cli.shaded.slf4j.spi.LocationAwareLogger;

@Singleton
@Named(value="slf4j")
@Deprecated
public class Slf4jLoggerFactory
implements software.amazon.smithy.cli.shaded.eclipse.aether.spi.log.LoggerFactory,
Service {
    private static final boolean AVAILABLE;
    private ILoggerFactory factory;

    public static boolean isSlf4jAvailable() {
        return AVAILABLE;
    }

    public Slf4jLoggerFactory() {
    }

    @Inject
    Slf4jLoggerFactory(@Nullable ILoggerFactory factory) {
        this.setLoggerFactory(factory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(ILoggerFactory.class));
    }

    public Slf4jLoggerFactory setLoggerFactory(ILoggerFactory factory) {
        this.factory = factory;
        return this;
    }

    @Override
    public Logger getLogger(String name) {
        software.amazon.smithy.cli.shaded.slf4j.Logger logger = this.getFactory().getLogger(name);
        if (logger instanceof LocationAwareLogger) {
            return new Slf4jLoggerEx((LocationAwareLogger)logger);
        }
        return new Slf4jLogger(logger);
    }

    private ILoggerFactory getFactory() {
        if (this.factory == null) {
            this.factory = LoggerFactory.getILoggerFactory();
        }
        return this.factory;
    }

    static {
        boolean available;
        try {
            Slf4jLoggerFactory.class.getClassLoader().loadClass("software.amazon.smithy.cli.shaded.slf4j.ILoggerFactory");
            available = true;
        }
        catch (Exception | LinkageError e) {
            available = false;
        }
        AVAILABLE = available;
    }

    private static final class Slf4jLoggerEx
    implements Logger {
        private static final String FQCN = Slf4jLoggerEx.class.getName();
        private final LocationAwareLogger logger;

        Slf4jLoggerEx(LocationAwareLogger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.logger.log(null, FQCN, 10, msg, null, null);
        }

        @Override
        public void debug(String msg, Throwable error) {
            this.logger.log(null, FQCN, 10, msg, null, error);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.logger.log(null, FQCN, 30, msg, null, null);
        }

        @Override
        public void warn(String msg, Throwable error) {
            this.logger.log(null, FQCN, 30, msg, null, error);
        }
    }

    private static final class Slf4jLogger
    implements Logger {
        private final software.amazon.smithy.cli.shaded.slf4j.Logger logger;

        Slf4jLogger(software.amazon.smithy.cli.shaded.slf4j.Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.logger.debug(msg);
        }

        @Override
        public void debug(String msg, Throwable error) {
            this.logger.debug(msg, error);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(String msg, Throwable error) {
            this.logger.warn(msg, error);
        }
    }
}

