/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.resolution;

import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.metadata.Metadata;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.MetadataRequest;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.MetadataNotFoundException;

public final class MetadataResult {
    private final MetadataRequest request;
    private Exception exception;
    private boolean updated;
    private Metadata metadata;

    public MetadataResult(MetadataRequest request) {
        this.request = Objects.requireNonNull(request, "metadata request cannot be null");
    }

    public MetadataRequest getRequest() {
        return this.request;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public MetadataResult setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public MetadataResult setException(Exception exception) {
        this.exception = exception;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public MetadataResult setUpdated(boolean updated) {
        this.updated = updated;
        return this;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isResolved() {
        return this.getMetadata() != null && this.getMetadata().getFile() != null;
    }

    public boolean isMissing() {
        return this.getException() instanceof MetadataNotFoundException;
    }

    public String toString() {
        return this.getMetadata() + (this.isUpdated() ? " (updated)" : " (cached)");
    }
}

