/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.osgi;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.BindingPublisher;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.BindingSubscriber;
import software.amazon.smithy.cli.shaded.eclipse.sisu.inject.Logs;
import software.amazon.smithy.cli.shaded.eclipse.sisu.osgi.BindingTracker;

public final class ServiceBindings
implements BindingPublisher {
    private static final Pattern GLOB_SYNTAX = Pattern.compile("(?:\\w+|\\*)(?:\\.?(?:\\w+|\\*))*");
    private final ConcurrentMap<String, BindingTracker<?>> trackers = new ConcurrentHashMap();
    private final BundleContext context;
    private final Pattern[] allowed;
    private final Pattern[] ignored;
    private final int maxRank;

    public ServiceBindings(BundleContext context, String allow, String ignore, int maxRank) {
        this.context = context;
        this.maxRank = maxRank;
        this.allowed = ServiceBindings.parseGlobs(allow);
        this.ignored = ServiceBindings.parseGlobs(ignore);
    }

    public ServiceBindings(BundleContext context) {
        this(context, ServiceBindings.defaultAllow(), ServiceBindings.defaultIgnore(), Integer.MIN_VALUE);
    }

    public static String defaultAllow() {
        return System.getProperty(String.valueOf(ServiceBindings.class.getName()) + ".allow", "");
    }

    public static String defaultIgnore() {
        return System.getProperty(String.valueOf(ServiceBindings.class.getName()) + ".ignore", "");
    }

    @Override
    public <T> void subscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        if (this.shouldTrack(clazzName)) {
            BindingTracker oldTracker;
            BindingTracker<T> tracker = (BindingTracker<T>)((Object)this.trackers.get(clazzName));
            if (tracker == null && (oldTracker = this.trackers.putIfAbsent(clazzName, tracker = new BindingTracker<T>(this.context, this.maxRank, clazzName))) != null) {
                tracker = oldTracker;
            }
            tracker.subscribe(subscriber);
        }
    }

    @Override
    public <T> void unsubscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        BindingTracker tracker = (BindingTracker)((Object)this.trackers.get(clazzName));
        if (tracker != null) {
            tracker.unsubscribe(subscriber);
        }
    }

    @Override
    public int maxBindingRank() {
        return this.maxRank;
    }

    private boolean shouldTrack(String clazzName) {
        Pattern[] patternArray = this.allowed;
        int n = this.allowed.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern allow = patternArray[n2];
            if (allow.matcher(clazzName).matches()) {
                Pattern[] patternArray2 = this.ignored;
                int n3 = this.ignored.length;
                int n4 = 0;
                while (n4 < n3) {
                    Pattern ignore = patternArray2[n4];
                    if (ignore.matcher(clazzName).matches()) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Pattern[] parseGlobs(String globs) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String[] stringArray = globs.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String glob = stringArray[n2];
            if (GLOB_SYNTAX.matcher(glob).matches()) {
                patterns.add(Pattern.compile(glob.replace(".", "\\.").replace("*", ".*")));
            } else if (glob.length() > 0) {
                Logs.warn("Ignoring malformed glob pattern: {}", glob, null);
            }
            ++n2;
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }
}

