/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.function.Consumer;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Style;

public interface ColorFormatter {
    public String style(String var1, Style ... var2);

    public void style(Appendable var1, String var2, Style ... var3);

    public <T extends Appendable> void style(T var1, Consumer<T> var2, Style ... var3);

    public boolean isColorEnabled();

    default public void println(CliPrinter printer, String text, Style ... styles) {
        printer.println(this.style(text, styles));
    }

    default public PrinterBuffer printerBuffer(CliPrinter printer) {
        return new PrinterBuffer(this, printer);
    }

    public static final class PrinterBuffer
    implements Appendable,
    AutoCloseable {
        private final ColorFormatter colors;
        private final CliPrinter printer;
        private final StringBuilder builder = new StringBuilder();
        private boolean pendingNewline;
        private final String newline = System.lineSeparator();

        private PrinterBuffer(ColorFormatter colors, CliPrinter printer) {
            this.colors = colors;
            this.printer = printer;
        }

        public String toString() {
            String result = this.builder.toString();
            if (this.pendingNewline) {
                result = result + this.newline;
            }
            return result;
        }

        @Override
        public PrinterBuffer append(CharSequence csq) {
            this.handleNewline();
            this.builder.append(csq);
            return this;
        }

        private void handleNewline() {
            if (this.pendingNewline) {
                this.builder.append(this.newline);
                this.pendingNewline = false;
            }
        }

        @Override
        public PrinterBuffer append(CharSequence csq, int start, int end) {
            this.handleNewline();
            this.builder.append(csq, start, end);
            return this;
        }

        @Override
        public PrinterBuffer append(char c) {
            this.handleNewline();
            this.builder.append(c);
            return this;
        }

        public PrinterBuffer print(String text, Style ... styles) {
            this.handleNewline();
            this.colors.style(this, text, styles);
            return this;
        }

        public PrinterBuffer println(String text, Style ... styles) {
            this.print(text, styles);
            return this.println();
        }

        public PrinterBuffer println() {
            this.handleNewline();
            this.pendingNewline = true;
            return this;
        }

        @Override
        public void close() {
            this.printer.println(this.builder.toString());
            this.builder.setLength(0);
            this.pendingNewline = false;
        }
    }
}

