/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.ContextualValidationEventFormatter;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;

final class CommandUtils {
    private static final Logger LOGGER = Logger.getLogger(CommandUtils.class.getName());

    private CommandUtils() {
    }

    static Model buildModel(Arguments arguments, List<String> models, Command.Env env, CliPrinter printer, boolean quietValidation, SmithyBuildConfig config) {
        ClassLoader classLoader = env.classLoader();
        ModelAssembler assembler = CommandUtils.createModelAssembler(classLoader);
        ContextualValidationEventFormatter formatter = new ContextualValidationEventFormatter();
        StandardOptions standardOptions = arguments.getReceiver(StandardOptions.class);
        BuildOptions buildOptions = arguments.getReceiver(BuildOptions.class);
        Severity minSeverity = buildOptions.severity(standardOptions);
        ColorFormatter colors = env.colors();
        assembler.validationEventListener(event -> {
            if (event.getSeverity().ordinal() >= minSeverity.ordinal()) {
                if (event.getSeverity() == Severity.WARNING) {
                    colors.println(printer, formatter.format(event), Style.YELLOW);
                } else if (event.getSeverity() == Severity.DANGER || event.getSeverity() == Severity.ERROR) {
                    colors.println(printer, formatter.format(event), Style.RED);
                } else {
                    printer.println(formatter.format(event));
                }
            }
        });
        CommandUtils.handleModelDiscovery(buildOptions, assembler, classLoader, config);
        CommandUtils.handleUnknownTraitsOption(buildOptions, assembler);
        config.getSources().forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        models.forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        config.getImports().forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ValidatedResult result = assembler.assemble();
        Validator.validate(quietValidation, colors, env.stderr(), (ValidatedResult<Model>)result);
        return (Model)result.getResult().orElseThrow(() -> new RuntimeException("Expected Validator to throw"));
    }

    static ModelAssembler createModelAssembler(ClassLoader classLoader) {
        return Model.assembler((ClassLoader)classLoader).putProperty("assembler.disableJarCache", (Object)true);
    }

    private static void handleUnknownTraitsOption(BuildOptions options, ModelAssembler assembler) {
        if (options.allowUnknownTraits()) {
            LOGGER.fine("Ignoring unknown traits");
            assembler.putProperty("assembler.allowUnknownTraits", (Object)true);
        }
    }

    private static void handleModelDiscovery(BuildOptions options, ModelAssembler assembler, ClassLoader baseLoader, SmithyBuildConfig config) {
        if (options.discoverClasspath() != null) {
            CommandUtils.discoverModelsWithClasspath(options.discoverClasspath(), assembler);
        } else if (CommandUtils.shouldDiscoverDependencies(options, config)) {
            assembler.discoverModels(baseLoader);
        }
    }

    private static boolean shouldDiscoverDependencies(BuildOptions options, SmithyBuildConfig config) {
        if (options.discover()) {
            return true;
        }
        return config.getMaven().isPresent() && EnvironmentVariable.SMITHY_DEPENDENCY_MODE.get().equals("standard");
    }

    private static void discoverModelsWithClasspath(String rawClasspath, ModelAssembler assembler) {
        LOGGER.finer("Discovering models with classpath: " + rawClasspath);
        String[] classpath = rawClasspath.split(System.getProperty("path.separator"));
        URL[] urls = new URL[classpath.length];
        for (int i = 0; i < classpath.length; ++i) {
            try {
                urls[i] = Paths.get(classpath[i], new String[0]).toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new CliError("Error parsing model discovery URL: " + classpath[i]);
            }
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urls);
        assembler.discoverModels((ClassLoader)urlClassLoader);
    }
}

