/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.function.Consumer;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public interface CliPrinter {
    public void println(String var1);

    default public String style(String text, Style ... styles) {
        return Style.format(text, styles);
    }

    public static final class ConsumerPrinter
    implements CliPrinter {
        private final Consumer<CharSequence> consumer;

        public ConsumerPrinter(Consumer<CharSequence> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void println(String text) {
            this.consumer.accept(text + System.lineSeparator());
        }
    }
}

