/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.StringJoiner;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;

final class Validator {
    private Validator() {
    }

    static void validate(boolean quiet, CliPrinter printer, ValidatedResult<Model> result) {
        int notes = result.getValidationEvents(Severity.NOTE).size();
        int warnings = result.getValidationEvents(Severity.WARNING).size();
        int errors = result.getValidationEvents(Severity.ERROR).size();
        int dangers = result.getValidationEvents(Severity.DANGER).size();
        int shapeCount = result.getResult().isPresent() ? ((Model)result.getResult().get()).toSet().size() : 0;
        boolean isFailed = errors > 0 || dangers > 0;
        boolean hasEvents = warnings > 0 || notes > 0 || isFailed;
        StringBuilder output = new StringBuilder();
        if (isFailed) {
            output.append(printer.style("FAILURE: ", Style.RED, Style.BOLD));
        } else {
            output.append(printer.style("SUCCESS: ", Style.GREEN, Style.BOLD));
        }
        output.append("Validated ").append(shapeCount).append(" shapes");
        if (hasEvents) {
            output.append(' ').append('(');
            StringJoiner joiner = new StringJoiner(", ");
            if (errors > 0) {
                Validator.appendSummaryCount(joiner, printer, "ERROR", errors, Style.BRIGHT_RED);
            }
            if (dangers > 0) {
                Validator.appendSummaryCount(joiner, printer, "DANGER", dangers, Style.RED);
            }
            if (warnings > 0) {
                Validator.appendSummaryCount(joiner, printer, "WARNING", warnings, Style.YELLOW);
            }
            if (notes > 0) {
                Validator.appendSummaryCount(joiner, printer, "NOTE", notes, Style.WHITE);
            }
            output.append(joiner.toString());
            output.append(')');
        }
        if (!result.getResult().isPresent() || errors + dangers > 0) {
            throw new CliError(output.toString());
        }
        if (!quiet) {
            printer.println(output.toString());
        }
    }

    private static void appendSummaryCount(StringJoiner joiner, CliPrinter printer, String label, int count, Style color) {
        joiner.add(printer.style(label, color) + ": " + count);
    }
}

