/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.ProjectionResult;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class BuildCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(BuildCommand.class.getName());

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public String getSummary() {
        return "Builds Smithy models and creates plugin artifacts for each projection";
    }

    @Override
    public Parser getParser() {
        return Parser.builder().repeatedParameter("--config", "-c", "Path to smithy-build.json configuration. Defaults to 'smithy-build.json'.").parameter("--output", "-o", "Where to write artifacts. Defaults to 'build/smithy'.").parameter("--projection", "Smithy will only generate artifacts for the given projection name.").parameter("--plugin", "Smithy will only generate artifacts for the given plugin name.").option("--discover", "-d", "Enables model discovery, merging in models found inside of jars").parameter("--discover-classpath", "Enables model discovery using a custom classpath for models").option("--allow-unknown-traits", "Ignores unknown traits when building models").parameter("--severity", "Sets a minimum validation event severity to display. Defaults to NOTE. Can be set to SUPPRESSED, NOTE, WARNING, DANGER, ERROR.").positional("<MODELS>", "Path to Smithy models or directories").build();
    }

    @Override
    public void execute(Arguments arguments, ClassLoader classLoader) {
        List<String> config = arguments.repeatedParameter("--config", null);
        String output = arguments.parameter("--output", null);
        List<String> models = arguments.positionalArguments();
        Cli.stdout(String.format("Building Smithy model sources: %s", models));
        SmithyBuildConfig.Builder configBuilder = SmithyBuildConfig.builder();
        if (config == null && Files.exists(Paths.get("smithy-build.json", new String[0]), new LinkOption[0])) {
            config = Collections.singletonList("smithy-build.json");
        }
        if (config != null) {
            Cli.stdout(String.format("Loading Smithy configs: [%s]", String.join((CharSequence)" ", config)));
            config.forEach(file -> configBuilder.load(Paths.get(file, new String[0])));
        } else {
            configBuilder.version("1.0");
        }
        if (output != null) {
            configBuilder.outputDirectory(output);
            try {
                Files.createDirectories(Paths.get(output, new String[0]), new FileAttribute[0]);
                LOGGER.info(String.format("Output directory set to: %s", output));
            }
            catch (IOException e) {
                throw new CliError("Unable to create Smithy output directory: " + e.getMessage());
            }
        }
        SmithyBuildConfig smithyBuildConfig = configBuilder.build();
        Model model = CommandUtils.buildModel(arguments, classLoader, SetUtils.of((Object)((Object)Validator.Feature.STDOUT)));
        SmithyBuild smithyBuild = SmithyBuild.create((ClassLoader)classLoader).config(smithyBuildConfig).model(model);
        if (arguments.has("--plugin")) {
            smithyBuild.pluginFilter(name -> name.equals(arguments.parameter("--plugin")));
        }
        if (arguments.has("--projection")) {
            smithyBuild.projectionFilter(name -> name.equals(arguments.parameter("--projection")));
        }
        models.forEach(path -> smithyBuild.registerSources(new Path[]{Paths.get(path, new String[0])}));
        ResultConsumer resultConsumer = new ResultConsumer();
        smithyBuild.build((Consumer)resultConsumer, (BiConsumer)resultConsumer);
        Colors color = resultConsumer.failedProjections.isEmpty() ? Colors.BRIGHT_BOLD_GREEN : Colors.BRIGHT_BOLD_YELLOW;
        color.out(String.format("Smithy built %s projection(s), %s plugin(s), and %s artifacts", resultConsumer.projectionCount, resultConsumer.pluginCount, resultConsumer.artifactCount));
        if (!resultConsumer.failedProjections.isEmpty()) {
            resultConsumer.failedProjections.sort(String::compareTo);
            throw new CliError(String.format("The following %d Smithy build projection(s) failed: %s", resultConsumer.failedProjections.size(), resultConsumer.failedProjections));
        }
    }

    private static final class ResultConsumer
    implements Consumer<ProjectionResult>,
    BiConsumer<String, Throwable> {
        List<String> failedProjections = Collections.synchronizedList(new ArrayList());
        AtomicInteger artifactCount = new AtomicInteger();
        AtomicInteger pluginCount = new AtomicInteger();
        AtomicInteger projectionCount = new AtomicInteger();

        private ResultConsumer() {
        }

        @Override
        public void accept(String name, Throwable exception) {
            this.failedProjections.add(name);
            StringBuilder message = new StringBuilder(String.format("%nProjection %s failed: %s%n", name, exception.toString()));
            for (StackTraceElement element : exception.getStackTrace()) {
                message.append(element).append(System.lineSeparator());
            }
            Cli.stdout(message);
        }

        @Override
        public void accept(ProjectionResult result) {
            if (result.isBroken()) {
                this.failedProjections.add(result.getProjectionName());
                StringBuilder message = new StringBuilder(System.lineSeparator());
                message.append(result.getProjectionName()).append(" has a model that failed validation").append(System.lineSeparator());
                result.getEvents().forEach(event -> {
                    if (event.getSeverity() == Severity.DANGER || event.getSeverity() == Severity.ERROR) {
                        message.append(event).append(System.lineSeparator());
                    }
                });
                Colors.RED.out(message.toString());
            } else {
                this.projectionCount.incrementAndGet();
            }
            this.pluginCount.addAndGet(result.getPluginManifests().size());
            Iterator manifestIterator = result.getPluginManifests().values().iterator();
            Path root = manifestIterator.hasNext() ? ((FileManifest)manifestIterator.next()).getBaseDir().getParent() : null;
            Colors.GREEN.out(String.format("Completed projection %s (%d shapes): %s", result.getProjectionName(), result.getModel().toSet().size(), root));
            for (FileManifest manifest : result.getPluginManifests().values()) {
                this.artifactCount.addAndGet(manifest.getFiles().size());
            }
        }
    }
}

