/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyUnstableApi
public final class Cli {
    public static final String HELP = "--help";
    public static final String NO_COLOR = "--no-color";
    public static final String FORCE_COLOR = "--force-color";
    public static final String DEBUG = "--debug";
    public static final String STACKTRACE = "--stacktrace";
    public static final String LOGGING = "--logging";
    static boolean useAnsiColors = Cli.isAnsiColorSupported();
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static Consumer<String> stdout = s -> System.out.println((String)s);
    private static Consumer<String> stderr = s -> System.err.println((String)s);
    private final String applicationName;
    private final ClassLoader classLoader;
    private Map<String, Command> commands = new TreeMap<String, Command>();

    public Cli(String applicationName) {
        this(applicationName, Cli.class.getClassLoader());
    }

    public Cli(String applicationName, ClassLoader classLoader) {
        this.applicationName = applicationName;
        this.classLoader = classLoader;
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName(), command);
    }

    public void run(String[] args) {
        block10: {
            try {
                if (args.length == 0) {
                    this.printMainHelp();
                    return;
                }
                String argument = args[0];
                if (argument.equals("-h") || argument.equals(HELP)) {
                    this.printMainHelp();
                    break block10;
                }
                if (this.commands.containsKey(argument)) {
                    Command command = this.commands.get(argument);
                    Parser parser = command.getParser();
                    Arguments parsedArguments = parser.parse(args, 1);
                    if (parsedArguments.has(NO_COLOR)) {
                        Cli.setUseAnsiColors(false);
                    } else if (parsedArguments.has(FORCE_COLOR)) {
                        Cli.setUseAnsiColors(true);
                    }
                    if (parsedArguments.has(HELP)) {
                        this.printHelp(command, parser);
                    } else {
                        this.configureLogging(parsedArguments);
                        command.execute(parsedArguments, this.classLoader);
                    }
                    break block10;
                }
                throw new CliError("Unknown command or argument: '" + argument + "'", 1);
            }
            catch (Exception e) {
                this.printException(args, e);
                throw e;
            }
        }
    }

    public static void setStdout(Consumer<String> printer) {
        stdout = printer;
    }

    public static void setStderr(Consumer<String> printer) {
        stderr = printer;
    }

    public static Consumer<String> getStdout() {
        return stdout;
    }

    public static Consumer<String> getStderr() {
        return stderr;
    }

    public static void stdout(Object message) {
        stdout.accept(String.valueOf(message));
    }

    public static void stderr(Object message) {
        stderr.accept(String.valueOf(message));
    }

    public static void setUseAnsiColors(boolean useAnsiColors) {
        Cli.useAnsiColors = useAnsiColors;
    }

    private static boolean isAnsiColorSupported() {
        return System.console() != null && System.getenv().get("TERM") != null;
    }

    private void configureLogging(Arguments parsedArgs) {
        boolean configureLogging;
        boolean bl = configureLogging = parsedArgs.has(DEBUG) || parsedArgs.has(LOGGING);
        if (!configureLogging) {
            return;
        }
        Level level = Level.parse(parsedArgs.parameter(LOGGING, Level.ALL.getName()));
        Logger rootLogger = Logger.getLogger("");
        Cli.removeConsoleHandler(rootLogger);
        if (parsedArgs.has(DEBUG)) {
            CliLogHandler handler = new CliLogHandler(new DebugFormatter());
            handler.setLevel(Level.ALL);
            rootLogger.addHandler(handler);
            rootLogger.setLevel(Level.ALL);
            for (Handler h : rootLogger.getHandlers()) {
                h.setLevel(Level.ALL);
            }
        } else if (level != Level.OFF) {
            CliLogHandler handler = new CliLogHandler(new BasicFormatter());
            handler.setLevel(level);
            rootLogger.addHandler(handler);
        }
    }

    private static void removeConsoleHandler(Logger rootLogger) {
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            rootLogger.removeHandler(handler);
        }
    }

    private boolean hasArgument(String[] args, String name) {
        for (String arg : args) {
            if (!arg.equals(name)) continue;
            return true;
        }
        return false;
    }

    private void printException(String[] args, Throwable throwable) {
        if (this.hasArgument(args, NO_COLOR)) {
            Cli.setUseAnsiColors(false);
        }
        Colors.BOLD_RED.out(throwable.getMessage());
        if (this.hasArgument(args, STACKTRACE)) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            String trace = sw.toString();
            Colors.RED.out(trace);
        }
    }

    private void printMainHelp() {
        Colors.BRIGHT_WHITE.out(String.format("Usage: %s [-h | --help] <command> [<args>]%n", this.applicationName));
        Cli.stdout("commands:");
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Command> entry : this.commands.entrySet()) {
            table.put("  " + entry.getKey(), entry.getValue().getSummary());
        }
        Cli.stdout(StringUtils.stripEnd((String)this.createTable(table), (String)" \t\r\n"));
    }

    private String createTable(Map<String, String> table) {
        StringBuilder builder = new StringBuilder();
        int longestLen = table.keySet().stream().map(String::length).mapToInt(v -> v).max().orElse(0) + 4;
        table.forEach((k, v) -> {
            int padding = longestLen - k.length();
            builder.append((String)k);
            for (int i = 0; i < padding; ++i) {
                builder.append(" ");
            }
            builder.append((String)v).append("\n");
        });
        return builder.toString();
    }

    private void printHelp(Command command, Parser parser) {
        StringBuilder example = new StringBuilder();
        example.append(this.applicationName).append(" ").append(command.getName());
        parser.getArgs().forEach(arg -> {
            if (!arg.getLongName().filter(name -> name.equals(HELP)).isPresent()) {
                example.append(" [");
                this.writeArgHelp((Parser.Argument)arg, example);
                example.append("]");
            }
        });
        parser.getPositionalName().ifPresent(name -> example.append(" ").append((String)name));
        Colors.BRIGHT_WHITE.out(example.append("\n").toString());
        StringBuilder body = new StringBuilder();
        body.append(command.getSummary()).append("\n\n");
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
        parser.getArgs().forEach(arg -> {
            StringBuilder key = new StringBuilder("  ");
            this.writeArgHelp((Parser.Argument)arg, key);
            table.put(key.toString(), arg.getHelp());
        });
        parser.getPositionalName().ifPresent(name -> table.put("  " + name + "  ", parser.getPositionalHelp().orElse("")));
        body.append("  ").append(this.createTable(table).trim());
        String help = command.getHelp();
        if (!help.isEmpty()) {
            body.append("\n\n").append(command.getHelp().trim());
        }
        Cli.stdout(body.toString());
    }

    private void writeArgHelp(Parser.Argument arg, StringBuilder sink) {
        arg.getShortName().ifPresent(sink::append);
        if (arg.getShortName().isPresent() && arg.getLongName().isPresent()) {
            sink.append(" | ");
        }
        arg.getLongName().ifPresent(sink::append);
        if (arg.getArity() == Parser.Arity.MANY) {
            sink.append(" ...");
        }
    }

    private static final class CliLogHandler
    extends Handler {
        private final Formatter formatter;

        CliLogHandler(Formatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                Cli.stderr(this.formatter.format(record));
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static final class DebugFormatter
    extends SimpleFormatter {
        private DebugFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return FORMAT.format(new Date(r.getMillis())) + " [" + r.getLevel().getLocalizedName() + "] [" + r.getLoggerName() + "] " + r.getMessage() + System.lineSeparator();
        }
    }

    private static final class BasicFormatter
    extends SimpleFormatter {
        private BasicFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return FORMAT.format(new Date(r.getMillis())) + " [" + r.getLevel().getLocalizedName() + "] " + r.getMessage() + System.lineSeparator();
        }
    }
}

