/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class SelectCommand
implements Command {
    @Override
    public String getName() {
        return "select";
    }

    @Override
    public String getSummary() {
        return "Queries a model using a selector";
    }

    @Override
    public String getHelp() {
        return "This command prints the shapes in a model that match a selector. The\nselector can be passed in using --selector or through stdin.\n\nBy default, each matching shape ID is printed to stdout on a new line.\nPass --vars to print out a JSON array that contains a 'shape' and 'vars'\nproperty, where the 'vars' property is a map of each variable that was\ncaptured when the shape was matched.";
    }

    @Override
    public Parser getParser() {
        return Parser.builder().parameter("--selector", "The Smithy selector to execute. Reads from STDIN when not provided.").option("--vars", "Include the variables that were captured when the shape was matched. Uses JSON.").option("--allow-unknown-traits", "Ignores unknown traits when validating models").option("--discover", "-d", "Enables model discovery, merging in models found inside of jars").parameter("--discover-classpath", "Enables model discovery using a custom classpath for models").positional("<MODELS>", "Path to Smithy models or directories").build();
    }

    @Override
    public void execute(Arguments arguments, ClassLoader classLoader) {
        Selector selector = arguments.has("--selector") ? Selector.parse((String)arguments.parameter("--selector")) : Selector.parse((String)IoUtils.toUtf8String((InputStream)System.in));
        Model model = CommandUtils.buildModel(arguments, classLoader, SetUtils.of((Object)((Object)Validator.Feature.QUIET)));
        if (!arguments.has("--vars")) {
            this.sortShapeIds(selector.select(model)).forEach(Cli::stdout);
        } else {
            ArrayList result = new ArrayList();
            selector.runner().model(model).selectMatches((shape, vars) -> result.add(Node.objectNodeBuilder().withMember("shape", (ToNode)Node.from((String)shape.getId().toString())).withMember("vars", (ToNode)this.collectVars((Map<String, Set<Shape>>)vars)).build()));
            Cli.stdout(Node.prettyPrintJson((Node)new ArrayNode(result, SourceLocation.NONE)));
        }
    }

    private Stream<String> sortShapeIds(Collection<Shape> shapes) {
        return shapes.stream().map(Shape::getId).map(ShapeId::toString).sorted();
    }

    private ObjectNode collectVars(Map<String, Set<Shape>> vars) {
        ObjectNode.Builder varBuilder = Node.objectNodeBuilder();
        for (Map.Entry<String, Set<Shape>> varEntry : vars.entrySet()) {
            ArrayNode value = (ArrayNode)this.sortShapeIds((Collection<Shape>)varEntry.getValue()).map(Node::from).collect(ArrayNode.collect());
            varBuilder.withMember(varEntry.getKey(), (ToNode)value);
        }
        return varBuilder.build();
    }
}

