/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.AddApiKeySource;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.traits.AuthorizerDefinition;
import software.amazon.smithy.aws.apigateway.traits.AuthorizerIndex;
import software.amazon.smithy.aws.apigateway.traits.AuthorizersTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.HttpApiKeyAuthTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.ComponentsObject;
import software.amazon.smithy.openapi.model.OpenApi;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;

final class AddAuthorizers
implements ApiGatewayMapper {
    private static final String EXTENSION_NAME = "x-amazon-apigateway-authorizer";
    private static final String CLIENT_EXTENSION_NAME = "x-amazon-apigateway-authtype";
    private static final String DEFAULT_AUTH_TYPE = "custom";
    private static final Logger LOGGER = Logger.getLogger(AddApiKeySource.class.getName());

    AddAuthorizers() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST), (Object)((Object)ApiGatewayConfig.ApiType.HTTP));
    }

    public Map<String, List<String>> updateSecurity(Context<? extends Trait> context, Shape shape, SecuritySchemeConverter<? extends Trait> converter, Map<String, List<String>> requirement) {
        if (requirement.size() != 1 || !requirement.keySet().iterator().next().equals(converter.getOpenApiAuthSchemeName())) {
            return requirement;
        }
        ServiceShape service = context.getService();
        AuthorizerIndex authorizerIndex = AuthorizerIndex.of((Model)context.getModel());
        return authorizerIndex.getAuthorizer((ToShapeId)service, (ToShapeId)shape).map(authorizer -> MapUtils.of((Object)authorizer, (Object)((List)requirement.values().iterator().next()))).orElse(requirement);
    }

    public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operation, String httpMethodName, String path) {
        ServiceShape service = context.getService();
        AuthorizerIndex authorizerIndex = AuthorizerIndex.of((Model)context.getModel());
        String serviceAuth = authorizerIndex.getAuthorizer((ToShapeId)service).orElse(null);
        String operationAuth = authorizerIndex.getAuthorizer((ToShapeId)service, (ToShapeId)shape).orElse(null);
        if (operationAuth == null) {
            return operation;
        }
        if (Objects.equals(operationAuth, serviceAuth) && !this.usesApiGatewayApiKeys(service, operationAuth)) {
            return operation;
        }
        return operation.toBuilder().addSecurity(MapUtils.of((Object)operationAuth, (Object)ListUtils.of())).build();
    }

    private boolean usesApiGatewayApiKeys(ServiceShape service, String operationAuth) {
        Optional definitionOptional = service.getTrait(AuthorizersTrait.class).flatMap(authorizers -> authorizers.getAuthorizer(operationAuth).filter(authorizer -> !authorizer.getType().isPresent() && !authorizer.getCustomAuthType().isPresent()));
        if (!definitionOptional.isPresent()) {
            return false;
        }
        AuthorizerDefinition definition = (AuthorizerDefinition)definitionOptional.get();
        return definition.getScheme().equals((Object)HttpApiKeyAuthTrait.ID);
    }

    public OpenApi after(Context<? extends Trait> context, OpenApi openapi) {
        return context.getService().getTrait(AuthorizersTrait.class).map(authorizers -> this.addComputedAuthorizers(context, openapi, (AuthorizersTrait)authorizers)).orElse(openapi);
    }

    private OpenApi addComputedAuthorizers(Context<? extends Trait> context, OpenApi openApi, AuthorizersTrait trait) {
        OpenApi.Builder builder = openApi.toBuilder();
        ComponentsObject.Builder components = openApi.getComponents().toBuilder();
        block0: for (Map.Entry entry : trait.getAuthorizers().entrySet()) {
            String authorizerName = (String)entry.getKey();
            AuthorizerDefinition authorizer = (AuthorizerDefinition)entry.getValue();
            ShapeId scheme = ((AuthorizerDefinition)entry.getValue()).getScheme();
            for (SecuritySchemeConverter converter : context.getSecuritySchemeConverters()) {
                if (!this.isAuthConverterMatched(context, (SecuritySchemeConverter<? extends Trait>)converter, scheme)) continue;
                SecurityScheme updatedScheme = this.convertAuthScheme(context, converter, authorizer, authorizerName);
                components.putSecurityScheme(authorizerName, updatedScheme);
                continue block0;
            }
        }
        builder.components(components.build());
        return builder.build();
    }

    private boolean isAuthConverterMatched(Context<? extends Trait> context, SecuritySchemeConverter<? extends Trait> converter, ShapeId scheme) {
        return converter.getAuthSchemeId().equals((Object)scheme) && context.getService().hasTrait(converter.getAuthSchemeType());
    }

    private <T extends Trait> SecurityScheme convertAuthScheme(Context<? extends Trait> context, SecuritySchemeConverter<T> converter, AuthorizerDefinition authorizer, String authorizerName) {
        ObjectNode authorizerNode;
        Trait authTrait = context.getService().expectTrait(converter.getAuthSchemeType());
        SecurityScheme createdScheme = converter.createSecurityScheme(context, authTrait);
        SecurityScheme.Builder schemeBuilder = createdScheme.toBuilder();
        Optional authTypeOptional = authorizer.getCustomAuthType();
        if (authorizer.getType().isPresent() || authTypeOptional.isPresent()) {
            String authType = authTypeOptional.orElse(DEFAULT_AUTH_TYPE);
            schemeBuilder.putExtension(CLIENT_EXTENSION_NAME, authType);
        }
        if ((authorizerNode = Node.objectNodeBuilder().withOptionalMember("type", authorizer.getType().map(Node::from)).withOptionalMember("authorizerUri", authorizer.getUri().map(Node::from)).withOptionalMember("authorizerCredentials", authorizer.getCredentials().map(Node::from)).withOptionalMember("identityValidationExpression", authorizer.getIdentityValidationExpression().map(Node::from)).withOptionalMember("identitySource", authorizer.getIdentitySource().map(Node::from)).withOptionalMember("authorizerResultTtlInSeconds", authorizer.getResultTtlInSeconds().map(Node::from)).build()).size() != 0) {
            schemeBuilder.putExtension(EXTENSION_NAME, (Node)authorizerNode);
        }
        LOGGER.fine(() -> String.format("Adding the `%s` OpenAPI security scheme", authorizerName));
        return schemeBuilder.build();
    }
}

