/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.openapi.CorsHeader;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

final class AddCorsToRestIntegrations
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(AddCorsToRestIntegrations.class.getName());
    private static final String RESPONSES_KEY = "responses";
    private static final String HEADER_PREFIX = "method.response.header.";
    private static final String DEFAULT_KEY = "default";
    private static final String STATUS_CODE_KEY = "statusCode";
    private static final String RESPONSE_PARAMETERS_KEY = "responseParameters";

    AddCorsToRestIntegrations() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST));
    }

    public OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operationObject, String httpMethod, String path) {
        CorsTrait cors = context.getService().getTrait(CorsTrait.class).orElse(null);
        if (cors == null) {
            return operationObject;
        }
        return operationObject.getExtension("x-amazon-apigateway-integration").flatMap(Node::asObjectNode).map(integrationObject -> this.updateOperation(context, shape, operationObject, cors, (ObjectNode)integrationObject)).orElse(operationObject);
    }

    private OperationObject updateOperation(Context<? extends Trait> context, OperationShape shape, OperationObject operationObject, CorsTrait cors, ObjectNode integrationObject) {
        ObjectNode updated = this.updateIntegrationWithCors(context, operationObject, shape, integrationObject, cors);
        return ((OperationObject.Builder)operationObject.toBuilder().putExtension("x-amazon-apigateway-integration", (Node)updated)).build();
    }

    private ObjectNode updateIntegrationWithCors(Context<? extends Trait> context, OperationObject operationObject, OperationShape shape, ObjectNode integrationNode, CorsTrait cors) {
        ObjectNode responses = integrationNode.getObjectMember(RESPONSES_KEY).orElse(Node.objectNode());
        if (!responses.getMember(DEFAULT_KEY).isPresent()) {
            responses = responses.withMember(DEFAULT_KEY, (ToNode)Node.objectNode().withMember(STATUS_CODE_KEY, "200"));
        }
        HashMap<CorsHeader, String> corsHeaders = new HashMap<CorsHeader, String>();
        corsHeaders.put(CorsHeader.ALLOW_ORIGIN, cors.getOrigin());
        if (context.usesHttpCredentials()) {
            corsHeaders.put(CorsHeader.ALLOW_CREDENTIALS, "true");
        }
        LOGGER.finer(() -> String.format("Adding the following CORS headers to the API Gateway integration of %s: %s", shape.getId(), corsHeaders));
        Set<String> deducedHeaders = CorsHeader.deduceOperationResponseHeaders(context, operationObject, shape, cors);
        LOGGER.fine(() -> String.format("Detected the following headers for operation %s: %s", shape.getId(), deducedHeaders));
        responses = (ObjectNode)responses.getMembers().entrySet().stream().peek(entry -> LOGGER.fine(() -> String.format("Updating integration response %s for `%s` with CORS", entry.getKey(), shape.getId()))).map(entry -> Pair.of(entry.getKey(), (Object)this.updateIntegrationResponse(shape, corsHeaders, deducedHeaders, ((Node)entry.getValue()).expectObjectNode()))).collect(ObjectNode.collect(Pair::getLeft, Pair::getRight));
        return integrationNode.withMember(RESPONSES_KEY, (ToNode)responses);
    }

    private ObjectNode updateIntegrationResponse(OperationShape shape, Map<CorsHeader, String> corsHeaders, Set<String> deduced, ObjectNode response) {
        HashMap<CorsHeader, String> responseHeaders = new HashMap<CorsHeader, String>(corsHeaders);
        ObjectNode responseParams = response.getObjectMember(RESPONSE_PARAMETERS_KEY).orElseGet(Node::objectNode);
        TreeSet<String> headersToExpose = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        headersToExpose.addAll(deduced);
        responseParams.getStringMap().keySet().stream().filter(parameterName -> parameterName.startsWith(HEADER_PREFIX)).map(parameterName -> parameterName.substring(HEADER_PREFIX.length())).forEach(headersToExpose::add);
        String headersToExposeString = String.join((CharSequence)",", headersToExpose);
        if (!headersToExposeString.isEmpty()) {
            responseHeaders.put(CorsHeader.EXPOSE_HEADERS, headersToExposeString);
            LOGGER.fine(() -> String.format("Adding `%s` header to `%s` with value of `%s`", new Object[]{CorsHeader.EXPOSE_HEADERS, shape.getId(), headersToExposeString}));
        }
        if (responseHeaders.isEmpty()) {
            LOGGER.fine(() -> "No headers are exposed by " + shape.getId());
            return response;
        }
        ObjectNode.Builder builder = responseParams.toBuilder();
        for (Map.Entry entry : responseHeaders.entrySet()) {
            builder.withMember(HEADER_PREFIX + entry.getKey(), "'" + (String)entry.getValue() + "'");
        }
        return response.withMember(RESPONSE_PARAMETERS_KEY, (ToNode)builder.build());
    }
}

