/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayConfig;
import software.amazon.smithy.aws.apigateway.openapi.ApiGatewayMapper;
import software.amazon.smithy.aws.apigateway.openapi.CorsHeader;
import software.amazon.smithy.aws.apigateway.traits.IntegrationResponse;
import software.amazon.smithy.aws.apigateway.traits.MockIntegrationTrait;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.OpenApiException;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.OperationObject;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.openapi.model.PathItem;
import software.amazon.smithy.openapi.model.Ref;
import software.amazon.smithy.openapi.model.ResponseObject;
import software.amazon.smithy.utils.CaseUtils;
import software.amazon.smithy.utils.ListUtils;

final class AddCorsPreflightIntegration
implements ApiGatewayMapper {
    private static final Logger LOGGER = Logger.getLogger(AddCorsPreflightIntegration.class.getName());
    private static final String API_GATEWAY_DEFAULT_ACCEPT_VALUE = "application/json";
    private static final String INTEGRATION_EXTENSION = "x-amazon-apigateway-integration";
    private static final String PREFLIGHT_SUCCESS = "{\"statusCode\":200}";

    AddCorsPreflightIntegration() {
    }

    @Override
    public List<ApiGatewayConfig.ApiType> getApiTypes() {
        return ListUtils.of((Object)((Object)ApiGatewayConfig.ApiType.REST));
    }

    public PathItem updatePathItem(Context<? extends Trait> context, String path, PathItem pathItem) {
        return context.getService().getTrait(CorsTrait.class).map(corsTrait -> AddCorsPreflightIntegration.addPreflightIntegration(context, path, pathItem, corsTrait)).orElse(pathItem);
    }

    private static PathItem addPreflightIntegration(Context<? extends Trait> context, String path, PathItem pathItem, CorsTrait corsTrait) {
        if (pathItem.getOptions().isPresent()) {
            LOGGER.fine(() -> path + " already defines an OPTIONS request, so no need to generate CORS-preflight");
            return pathItem;
        }
        LOGGER.fine(() -> "Adding CORS-preflight OPTIONS request and API Gateway integration for " + path);
        Map<CorsHeader, String> headers = AddCorsPreflightIntegration.deduceCorsHeaders(context, path, pathItem, corsTrait);
        return pathItem.toBuilder().options(AddCorsPreflightIntegration.createPreflightOperation(path, pathItem, headers)).build();
    }

    private static <T extends Trait> Map<CorsHeader, String> deduceCorsHeaders(Context<T> context, String path, PathItem pathItem, CorsTrait corsTrait) {
        HashMap<CorsHeader, String> corsHeaders = new HashMap<CorsHeader, String>();
        corsHeaders.put(CorsHeader.MAX_AGE, String.valueOf(corsTrait.getMaxAge()));
        corsHeaders.put(CorsHeader.ALLOW_ORIGIN, corsTrait.getOrigin());
        corsHeaders.put(CorsHeader.ALLOW_METHODS, AddCorsPreflightIntegration.getAllowMethods(pathItem));
        if (context.usesHttpCredentials()) {
            corsHeaders.put(CorsHeader.ALLOW_CREDENTIALS, "true");
        }
        TreeSet<String> headerNames = new TreeSet<String>(corsTrait.getAdditionalAllowedHeaders());
        List<String> additionalAllowedHeaders = ((ApiGatewayConfig)context.getConfig().getExtensions(ApiGatewayConfig.class)).getAdditionalAllowedCorsHeaders();
        headerNames.addAll(additionalAllowedHeaders);
        headerNames.addAll(AddCorsPreflightIntegration.findAllHeaders(path, pathItem));
        for (SecuritySchemeConverter converter : context.getSecuritySchemeConverters()) {
            headerNames.addAll(AddCorsPreflightIntegration.getSecuritySchemeRequestHeaders(context, converter));
        }
        Model model = context.getModel();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        Map<String, OperationShape> operations = topDownIndex.getContainedOperations((ToShapeId)context.getService()).stream().collect(Collectors.toMap(o -> o.getId().getName(), o -> o));
        for (OperationObject operationObject : pathItem.getOperations().values()) {
            if (!operationObject.getOperationId().isPresent()) continue;
            OperationShape operationShape = operations.get(operationObject.getOperationId().get());
            headerNames.addAll(context.getOpenApiProtocol().getProtocolRequestHeaders(context, operationShape));
        }
        LOGGER.fine(() -> String.format("Adding the following %s headers to `%s`: %s", new Object[]{CorsHeader.ALLOW_HEADERS, path, headerNames}));
        corsHeaders.put(CorsHeader.ALLOW_HEADERS, String.join((CharSequence)",", headerNames));
        return corsHeaders;
    }

    private static <T extends Trait> Set<String> getSecuritySchemeRequestHeaders(Context<? extends Trait> context, SecuritySchemeConverter<T> converter) {
        Trait t = context.getService().expectTrait(converter.getAuthSchemeType());
        return converter.getAuthRequestHeaders(context, t);
    }

    private static Collection<String> findAllHeaders(String path, PathItem pathItem) {
        return pathItem.getOperations().values().stream().flatMap(operationObject -> operationObject.getParameters().stream()).filter(parameter -> parameter.getIn().filter(in -> in.equals("header")).isPresent()).map(parameter -> (String)parameter.getName().orElseThrow(() -> new OpenApiException("OpenAPI header parameter is missing a name in " + path))).collect(Collectors.toList());
    }

    private static String getAllowMethods(PathItem item) {
        return String.join((CharSequence)",", item.getOperations().keySet());
    }

    private static OperationObject createPreflightOperation(String path, PathItem pathItem, Map<CorsHeader, String> headers) {
        return ((OperationObject.Builder)OperationObject.builder().tags((Collection)ListUtils.of((Object)"CORS")).security(Collections.emptyList()).description("Handles CORS-preflight requests").operationId(AddCorsPreflightIntegration.createOperationId(path)).putResponse("200", AddCorsPreflightIntegration.createPreflightResponse(headers)).parameters(AddCorsPreflightIntegration.findPathParameters(pathItem)).putExtension(INTEGRATION_EXTENSION, (Node)AddCorsPreflightIntegration.createPreflightIntegration(headers, pathItem))).build();
    }

    private static List<ParameterObject> findPathParameters(PathItem pathItem) {
        ArrayList<ParameterObject> parameterObjects = new ArrayList<ParameterObject>();
        Iterator iter = pathItem.getOperations().values().iterator();
        if (iter.hasNext()) {
            for (ParameterObject parameter : ((OperationObject)iter.next()).getParameters()) {
                if (!parameter.getIn().filter(in -> in.equals("path")).isPresent()) continue;
                parameterObjects.add(parameter);
            }
        }
        return parameterObjects;
    }

    private static String createOperationId(String path) {
        return CaseUtils.toCamelCase((String)("Cors" + path), (boolean)true, (char[])new char[]{'{', '}', '/', '?', '&', '='}).replaceAll("[^A-Z0-9a-z_]", "_");
    }

    private static ResponseObject createPreflightResponse(Map<CorsHeader, String> headers) {
        ResponseObject.Builder builder = ResponseObject.builder().description("Canned response for CORS-preflight requests");
        ParameterObject headerParameter = ParameterObject.builder().schema(Schema.builder().type("string").build()).build();
        headers.forEach((name, value) -> builder.putHeader(name.toString(), Ref.local((ToNode)headerParameter)));
        return builder.build();
    }

    private static ObjectNode createPreflightIntegration(Map<CorsHeader, String> headers, PathItem pathItem) {
        IntegrationResponse.Builder responseBuilder = IntegrationResponse.builder().statusCode("200");
        for (Map.Entry<CorsHeader, String> e : headers.entrySet()) {
            responseBuilder.putResponseParameter("method.response.header." + (Object)((Object)e.getKey()), "'" + e.getValue() + "'");
        }
        MockIntegrationTrait.Builder integration = MockIntegrationTrait.builder().contentHandling("CONVERT_TO_TEXT").passThroughBehavior("when_no_match").putResponse("default", responseBuilder.build()).putRequestTemplate(API_GATEWAY_DEFAULT_ACCEPT_VALUE, PREFLIGHT_SUCCESS);
        for (OperationObject operation : pathItem.getOperations().values()) {
            for (ResponseObject response : operation.getResponses().values()) {
                for (String mimeType : response.getContent().keySet()) {
                    integration.putRequestTemplate(mimeType, PREFLIGHT_SUCCESS);
                }
            }
        }
        return integration.build().toNode().expectObjectNode().withMember("type", "mock");
    }
}

