/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.apigateway.openapi;

import java.util.Set;
import software.amazon.smithy.aws.traits.auth.CognitoUserPoolsTrait;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.fromsmithy.SecuritySchemeConverter;
import software.amazon.smithy.openapi.model.SecurityScheme;
import software.amazon.smithy.utils.SetUtils;

final class CognitoUserPoolsConverter
implements SecuritySchemeConverter<CognitoUserPoolsTrait> {
    private static final String AUTH_HEADER = "Authorization";
    private static final Set<String> REQUEST_HEADERS = SetUtils.of((Object)"Authorization");
    private static final String AUTH_TYPE = "cognito_user_pools";
    private static final String PROVIDER_ARNS_PROPERTY = "providerARNs";

    CognitoUserPoolsConverter() {
    }

    public Class<CognitoUserPoolsTrait> getAuthSchemeType() {
        return CognitoUserPoolsTrait.class;
    }

    public SecurityScheme createSecurityScheme(Context<? extends Trait> context, CognitoUserPoolsTrait trait) {
        return ((SecurityScheme.Builder)((SecurityScheme.Builder)SecurityScheme.builder().type("apiKey").description("Amazon Cognito User Pools authentication").name(AUTH_HEADER).in("header").putExtension("x-amazon-apigateway-authtype", (Node)Node.from((String)AUTH_TYPE))).putExtension("x-amazon-apigateway-authorizer", (Node)Node.objectNode().withMember("type", (ToNode)Node.from((String)AUTH_TYPE)).withMember(PROVIDER_ARNS_PROPERTY, (ToNode)((ArrayNode)trait.getProviderArns().stream().map(Node::from).collect(ArrayNode.collect()))))).build();
    }

    public Set<String> getAuthRequestHeaders(Context<? extends Trait> context, CognitoUserPoolsTrait trait) {
        return REQUEST_HEADERS;
    }
}

