/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.protocol.railsjson.generators;

import java.util.Optional;
import java.util.stream.Stream;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.JsonNameTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.generators.HttpStubsGeneratorBase;
import software.amazon.smithy.ruby.codegen.trait.NoSerializeTrait;

public class StubsGenerator
extends HttpStubsGeneratorBase {
    public StubsGenerator(GenerationContext context) {
        super(context);
    }

    protected void renderNoPayloadBodyStub(OperationShape operation, Shape outputShape) {
        this.writer.write((Object)"http_resp.headers['Content-Type'] = 'application/json'", new Object[0]).call(() -> this.renderMemberStubbers(outputShape)).write((Object)"http_resp.body = StringIO.new(Seahorse::JSON.dump(data))", new Object[0]);
    }

    protected void renderPayloadBodyStub(OperationShape operation, Shape outputShape, MemberShape payloadMember, Shape target) {
        String symbolName = ":" + this.symbolProvider.toMemberName(payloadMember);
        String inputGetter = "stub[" + symbolName + "]";
        target.accept((ShapeVisitor)new PayloadMemberSerializer(payloadMember, inputGetter));
    }

    protected void renderStructureMemberStubbers(StructureShape shape) {
        this.renderMemberStubbers((Shape)shape);
    }

    protected void renderUnionMemberStubbers(UnionShape shape) {
        shape.members().forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String symbolName = RubyFormatter.asSymbol((String)this.symbolProvider.toMemberName(member));
            String dataName = RubyFormatter.asSymbol((String)member.getMemberName());
            if (member.hasTrait(JsonNameTrait.class)) {
                dataName = "'" + ((JsonNameTrait)member.expectTrait(JsonNameTrait.class)).getValue() + "'";
            }
            String dataSetter = "data[" + dataName + "] = ";
            String inputGetter = "stub[" + symbolName + "]";
            target.accept((ShapeVisitor)new MemberSerializer((MemberShape)member, dataSetter, inputGetter, true));
        });
    }

    protected void renderListMemberStub(ListShape shape) {
        Shape memberTarget = this.model.expectShape(shape.getMember().getTarget());
        memberTarget.accept((ShapeVisitor)new MemberSerializer(shape.getMember(), "data << ", "element", false));
    }

    protected void renderSetMemberStub(SetShape shape) {
        Shape memberTarget = this.model.expectShape(shape.getMember().getTarget());
        memberTarget.accept((ShapeVisitor)new MemberSerializer(shape.getMember(), "data << ", "element", false));
    }

    protected void renderMapMemberStub(MapShape shape) {
        Shape valueTarget = this.model.expectShape(shape.getValue().getTarget());
        valueTarget.accept((ShapeVisitor)new MemberSerializer(shape.getValue(), "data[key] = ", "value", false));
    }

    private void renderMemberStubbers(Shape s) {
        Optional<MemberShape> payload = s.members().stream().filter(m -> m.hasTrait(HttpPayloadTrait.class)).findFirst();
        if (payload.isPresent()) {
            MemberShape member2 = payload.get();
            Shape target = this.model.expectShape(member2.getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(member2);
            String inputGetter = "stub[" + symbolName + "]";
            target.accept((ShapeVisitor)new MemberSerializer(member2, "data = ", inputGetter, true));
            this.writer.write((Object)"data ||= {}", new Object[0]);
        } else {
            Stream<MemberShape> serializeMembers = s.members().stream().filter(m -> !m.hasTrait(HttpLabelTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpHeaderTrait.class));
            serializeMembers = serializeMembers.filter(NoSerializeTrait.excludeNoSerializeMembers());
            serializeMembers.forEach(member -> {
                Shape target = this.model.expectShape(member.getTarget());
                String symbolName = ":" + this.symbolProvider.toMemberName(member);
                String dataName = RubyFormatter.asSymbol((String)member.getMemberName());
                if (member.hasTrait(JsonNameTrait.class)) {
                    dataName = "'" + ((JsonNameTrait)member.expectTrait(JsonNameTrait.class)).getValue() + "'";
                }
                String dataSetter = "data[" + dataName + "] = ";
                String inputGetter = "stub[" + symbolName + "]";
                target.accept((ShapeVisitor)new MemberSerializer((MemberShape)member, dataSetter, inputGetter, true));
            });
        }
    }

    private class PayloadMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;
        private final String inputGetter;

        PayloadMemberSerializer(MemberShape memberShape, String inputGetter) {
            this.memberShape = memberShape;
            this.inputGetter = inputGetter;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            StubsGenerator.this.writer.write((Object)"http_resp.headers['Content-Type'] = 'text/plain'", new Object[0]).write((Object)"http_resp.body = StringIO.new($L || '')", new Object[]{this.inputGetter});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            Optional mediaTypeTrait = shape.getTrait(MediaTypeTrait.class);
            String mediaType = "application/octet-stream";
            if (mediaTypeTrait.isPresent()) {
                mediaType = ((MediaTypeTrait)mediaTypeTrait.get()).getValue();
            }
            StubsGenerator.this.writer.write((Object)"http_resp.headers['Content-Type'] = '$L'", new Object[]{mediaType}).write((Object)"http_resp.body = StringIO.new($L || '')", new Object[]{this.inputGetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        private void defaultComplexSerializer(Shape shape) {
            StubsGenerator.this.writer.write((Object)"http_resp.headers['Content-Type'] = 'application/json'", new Object[0]).write((Object)"data = Stubs::$1L.stub($2L) unless $2L.nil?", new Object[]{StubsGenerator.this.symbolProvider.toSymbol(shape).getName(), this.inputGetter}).write((Object)"http_resp.body = StringIO.new(Seahorse::JSON.dump(data))", new Object[0]);
        }
    }

    private class MemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;
        private final String inputGetter;
        private final String dataSetter;
        private final boolean checkRequired;

        MemberSerializer(MemberShape memberShape, String dataSetter, String inputGetter, boolean checkRequired) {
            this.memberShape = memberShape;
            this.inputGetter = inputGetter;
            this.dataSetter = dataSetter;
            this.checkRequired = checkRequired;
        }

        private String checkRequired() {
            if (this.checkRequired) {
                return " unless " + this.inputGetter + ".nil?";
            }
            return "";
        }

        protected Void getDefault(Shape shape) {
            StubsGenerator.this.writer.write((Object)"$L$L$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired()});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            StubsGenerator.this.writer.write((Object)"$LBase64::encode64($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired()});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        StubsGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_epoch_seconds($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired()});
                        break;
                    }
                    case HTTP_DATE: {
                        StubsGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_http_date($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired()});
                        break;
                    }
                    default: {
                        StubsGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_date_time($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired()});
                        break;
                    }
                }
            } else {
                StubsGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_date_time($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired()});
            }
            return null;
        }

        private void defaultComplexSerializer(Shape shape) {
            StubsGenerator.this.writer.write((Object)"$LStubs::$L.stub($L)$L", new Object[]{this.dataSetter, StubsGenerator.this.symbolProvider.toSymbol(shape).getName(), this.inputGetter, this.checkRequired()});
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void setShape(SetShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }
    }
}

