/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.protocol.railsjson.generators;

import java.util.Optional;
import java.util.stream.Stream;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.JsonNameTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.generators.HttpBuilderGeneratorBase;
import software.amazon.smithy.ruby.codegen.trait.NoSerializeTrait;

public class BuilderGenerator
extends HttpBuilderGeneratorBase {
    public BuilderGenerator(GenerationContext context) {
        super(context);
    }

    private void renderMemberBuilders(Shape s) {
        Stream<MemberShape> serializeMembers = s.members().stream().filter(m -> !m.hasTrait(HttpLabelTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class));
        serializeMembers = serializeMembers.filter(NoSerializeTrait.excludeNoSerializeMembers());
        serializeMembers.forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(member);
            String dataName = RubyFormatter.asSymbol((String)member.getMemberName());
            if (member.hasTrait(JsonNameTrait.class)) {
                dataName = "'" + ((JsonNameTrait)member.expectTrait(JsonNameTrait.class)).getValue() + "'";
            }
            if (member.hasTrait("smithy.ruby.protocols#nestedAttributes")) {
                dataName = dataName + "_attributes";
            }
            String dataSetter = "data[" + dataName + "] = ";
            String inputGetter = "input[" + symbolName + "]";
            target.accept((ShapeVisitor)new MemberSerializer((MemberShape)member, dataSetter, inputGetter, true));
        });
    }

    protected void renderPayloadBodyBuilder(OperationShape operation, Shape inputShape, MemberShape payloadMember, Shape target) {
        String symbolName = ":" + this.symbolProvider.toMemberName(payloadMember);
        String inputGetter = "input[" + symbolName + "]";
        target.accept((ShapeVisitor)new PayloadMemberSerializer(payloadMember, inputGetter));
    }

    protected void renderNoPayloadBodyBuilder(OperationShape operation, Shape inputShape) {
        this.writer.write((Object)"", new Object[0]).write((Object)"http_req.headers['Content-Type'] = 'application/json'", new Object[0]).write((Object)"data = {}", new Object[0]).call(() -> this.renderMemberBuilders(inputShape)).write((Object)"http_req.body = StringIO.new(Seahorse::JSON.dump(data))", new Object[0]);
    }

    protected void renderStructureMemberBuilders(StructureShape shape) {
        this.renderMemberBuilders((Shape)shape);
    }

    protected void renderListMemberBuilder(ListShape shape) {
        Shape memberTarget = this.model.expectShape(shape.getMember().getTarget());
        memberTarget.accept((ShapeVisitor)new MemberSerializer(shape.getMember(), "data << ", "element", false));
    }

    protected void renderUnionMemberBuilder(UnionShape shape, MemberShape member) {
        Shape target = this.model.expectShape(member.getTarget());
        String symbolName = RubyFormatter.asSymbol((String)this.symbolProvider.toMemberName(member));
        String dataSetter = "data[" + symbolName + "] = ";
        target.accept((ShapeVisitor)new MemberSerializer(member, dataSetter, "input", false));
    }

    protected void renderMapMemberBuilder(MapShape shape) {
        Shape valueTarget = this.model.expectShape(shape.getValue().getTarget());
        valueTarget.accept((ShapeVisitor)new MemberSerializer(shape.getValue(), "data[key] = ", "value", false));
    }

    protected void renderSetMemberBuilder(SetShape shape) {
        Shape memberTarget = this.model.expectShape(shape.getMember().getTarget());
        memberTarget.accept((ShapeVisitor)new MemberSerializer(shape.getMember(), "data << ", "element", false));
    }

    private class PayloadMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;
        private final String inputGetter;

        PayloadMemberSerializer(MemberShape memberShape, String inputGetter) {
            this.memberShape = memberShape;
            this.inputGetter = inputGetter;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            BuilderGenerator.this.writer.write((Object)"http_req.headers['Content-Type'] = 'text/plain'", new Object[0]).write((Object)"http_req.body = StringIO.new($L || '')", new Object[]{this.inputGetter});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            Optional mediaTypeTrait = shape.getTrait(MediaTypeTrait.class);
            String mediaType = "application/octet-stream";
            if (mediaTypeTrait.isPresent()) {
                mediaType = ((MediaTypeTrait)mediaTypeTrait.get()).getValue();
            }
            BuilderGenerator.this.writer.write((Object)"http_req.headers['Content-Type'] = '$L'", new Object[]{mediaType}).write((Object)"http_req.body = StringIO.new($L || '')", new Object[]{this.inputGetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        private void defaultComplexSerializer(Shape shape) {
            BuilderGenerator.this.writer.write((Object)"http_req.headers['Content-Type'] = 'application/json'", new Object[0]).write((Object)"data = Builders::$1L.build($2L) unless $2L.nil?", new Object[]{BuilderGenerator.this.symbolProvider.toSymbol(shape).getName(), this.inputGetter}).write((Object)"http_req.body = StringIO.new(Seahorse::JSON.dump(data))", new Object[0]);
        }
    }

    private class MemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String dataSetter;
        private final MemberShape memberShape;
        private final boolean checkRequired;

        MemberSerializer(MemberShape memberShape, String dataSetter, String inputGetter, boolean checkRequired) {
            this.inputGetter = inputGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
            this.checkRequired = checkRequired;
        }

        private String checkRequired(Shape shape) {
            if (this.checkRequired) {
                return " unless " + this.inputGetter + ".nil?";
            }
            return "";
        }

        protected Void getDefault(Shape shape) {
            BuilderGenerator.this.writer.write((Object)"$L$L$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired(shape)});
            return null;
        }

        public Void blobShape(BlobShape shape) {
            BuilderGenerator.this.writer.write((Object)"$LBase64::encode64($L).strip$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired((Shape)shape)});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        BuilderGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_epoch_seconds($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired((Shape)shape)});
                        break;
                    }
                    case HTTP_DATE: {
                        BuilderGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_http_date($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired((Shape)shape)});
                        break;
                    }
                    default: {
                        BuilderGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_date_time($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired((Shape)shape)});
                        break;
                    }
                }
            } else {
                BuilderGenerator.this.writer.write((Object)"$LSeahorse::TimeHelper.to_date_time($L)$L", new Object[]{this.dataSetter, this.inputGetter, this.checkRequired((Shape)shape)});
            }
            return null;
        }

        private void defaultComplexSerializer(Shape shape) {
            BuilderGenerator.this.writer.write((Object)"$LBuilders::$L.build($L)$L", new Object[]{this.dataSetter, BuilderGenerator.this.symbolProvider.toSymbol(shape).getName(), this.inputGetter, this.checkRequired(shape)});
        }

        public Void listShape(ListShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void setShape(SetShape shape) {
            BuilderGenerator.this.writer.write((Object)"$LBuilders::$L.build($L).to_a$L", new Object[]{this.dataSetter, BuilderGenerator.this.symbolProvider.toSymbol((Shape)shape).getName(), this.inputGetter, this.checkRequired((Shape)shape)});
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.defaultComplexSerializer((Shape)shape);
            return null;
        }
    }
}

