/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.rulesengine;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.WriteAdditionalFiles;
import software.amazon.smithy.ruby.codegen.util.RubySource;
import software.amazon.smithy.utils.SmithyBuilder;

public final class FunctionBinding {
    private final String id;
    private final String rubyMethodName;
    private final WriteAdditionalFiles writeAdditionalFiles;

    private FunctionBinding(Builder builder) {
        this.id = builder.id;
        this.rubyMethodName = builder.rubyMethodName;
        this.writeAdditionalFiles = builder.writeAdditionalFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static List<FunctionBinding> standardLibraryFunctions() {
        return List.of(FunctionBinding.builder().id("isValidHostLabel").rubyMethodName("Hearth::EndpointRules::valid_host_label?").build(), FunctionBinding.builder().id("parseURL").rubyMethodName("Hearth::EndpointRules::parse_url").build(), FunctionBinding.builder().id("substring").rubyMethodName("Hearth::EndpointRules::substring").build(), FunctionBinding.builder().id("uriEncode").rubyMethodName("Hearth::EndpointRules::uri_encode").build());
    }

    public String getId() {
        return this.id;
    }

    public String getRubyMethodName() {
        return this.rubyMethodName;
    }

    public List<String> writeAdditionalFiles(GenerationContext context) {
        return this.writeAdditionalFiles.writeAdditionalFiles(context);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionBinding)) {
            return false;
        }
        FunctionBinding other = (FunctionBinding)o;
        return this.id.equals(other.id);
    }

    public static class Builder
    implements SmithyBuilder<FunctionBinding> {
        private String id;
        private String rubyMethodName;
        private WriteAdditionalFiles writeAdditionalFiles = context -> Collections.emptyList();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder rubyMethodName(String rubyMethodName) {
            this.rubyMethodName = rubyMethodName;
            return this;
        }

        public Builder writeAdditionalFiles(WriteAdditionalFiles w) {
            this.writeAdditionalFiles = Objects.requireNonNull(w);
            return this;
        }

        public Builder rubySource(String rubyFileName) {
            this.writeAdditionalFiles = RubySource.rubySource(rubyFileName, "endpoint/");
            return this;
        }

        public FunctionBinding build() {
            return new FunctionBinding(this);
        }
    }
}

