/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.RequiresLengthTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ValidatorsGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(ValidatorsGenerator.class.getName());

    public ValidatorsGenerator(ContextualDirective<GenerationContext, RubySettings> directive) {
        super(directive);
    }

    @Override
    String getModule() {
        return "Validators";
    }

    public void render() {
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).apiPrivate().openBlock("module Validators", new Object[0])).call(() -> this.renderValidators((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote validators to " + this.rbFile());
    }

    private void renderValidators(RubyCodeWriter writer) {
        Model modelWithoutTraitShapes = ModelTransformer.create().getModelWithoutTraitShapes(this.model);
        new Walker(modelWithoutTraitShapes).walkShapes((Shape)this.context.service()).stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(shape -> shape.accept((ShapeVisitor)new Visitor(writer)));
    }

    private final class Visitor
    extends ShapeVisitor.Default<Void> {
        private final RubyCodeWriter writer;

        private Visitor(RubyCodeWriter writer) {
            this.writer = writer;
        }

        public Void structureShape(StructureShape structureShape) {
            Collection members = structureShape.members();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ValidatorsGenerator.this.symbolProvider.toSymbol((Shape)structureShape).getName()})).openBlock("def self.validate!(input, context:)", new Object[0])).write("$T.validate_types!(input, $T, context: context)", new Object[]{Hearth.VALIDATOR, ValidatorsGenerator.this.context.symbolProvider().toSymbol((Shape)structureShape)})).call(() -> this.renderValidatorsForStructureMembers(members))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        private void renderValidatorsForStructureMembers(Collection<MemberShape> members) {
            members.forEach(member -> {
                Shape target = ValidatorsGenerator.this.model.expectShape(member.getTarget());
                String symbolName = ":" + ValidatorsGenerator.this.symbolProvider.toMemberName(member);
                String input = "input[" + symbolName + "]";
                String context = "\"#{context}[" + symbolName + "]\"";
                if (member.hasTrait(RequiredTrait.class)) {
                    this.writer.write("$T.validate_required!($L, context: $L)", new Object[]{Hearth.VALIDATOR, input, context});
                }
                target.accept((ShapeVisitor)new MemberValidator(this.writer, ValidatorsGenerator.this.symbolProvider, input, context, false));
            });
        }

        public Void mapShape(MapShape mapShape) {
            Shape valueTarget = ValidatorsGenerator.this.model.expectShape(mapShape.getValue().getTarget());
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ValidatorsGenerator.this.symbolProvider.toSymbol((Shape)mapShape).getName()})).openBlock("def self.validate!(input, context:)", new Object[0])).write("$T.validate_types!(input, ::Hash, context: context)", new Object[]{Hearth.VALIDATOR})).openBlock("input.each do |key, value|", new Object[0])).write("$T.validate_types!(key, ::String, ::Symbol, context: \"#{context}.keys\")", new Object[]{Hearth.VALIDATOR})).call(() -> valueTarget.accept((ShapeVisitor)new MemberValidator(this.writer, ValidatorsGenerator.this.symbolProvider, "value", "\"#{context}[:#{key}]\"", false)))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        public Void listShape(ListShape listShape) {
            Shape memberTarget = ValidatorsGenerator.this.model.expectShape(listShape.getMember().getTarget());
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ValidatorsGenerator.this.symbolProvider.toSymbol((Shape)listShape).getName()})).openBlock("def self.validate!(input, context:)", new Object[0])).write("$T.validate_types!(input, ::Array, context: context)", new Object[]{Hearth.VALIDATOR})).openBlock("input.each_with_index do |element, index|", new Object[0])).call(() -> memberTarget.accept((ShapeVisitor)new MemberValidator(this.writer, ValidatorsGenerator.this.symbolProvider, "element", "\"#{context}[#{index}]\"", false)))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape unionShape) {
            Symbol unionType = ValidatorsGenerator.this.context.symbolProvider().toSymbol((Shape)unionShape);
            String shapeName = unionType.getName();
            Collection unionMemberShapes = unionShape.members();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ValidatorsGenerator.this.symbolProvider.toSymbol((Shape)unionShape).getName()})).openBlock("def self.validate!(input, context:)", new Object[0])).write("case input", new Object[0])).call(() -> unionMemberShapes.forEach(unionMemberShape -> {
                String unionMemberName = ValidatorsGenerator.this.symbolProvider.toMemberName(unionMemberShape);
                ((RubyCodeWriter)this.writer.write("when $T", new Object[]{ValidatorsGenerator.this.context.symbolProvider().toSymbol((Shape)unionMemberShape)})).indent();
                ValidatorsGenerator.this.model.expectShape(unionMemberShape.getTarget()).accept((ShapeVisitor)new MemberValidator(this.writer, ValidatorsGenerator.this.symbolProvider, "input.__getobj__", "context", false));
                this.writer.dedent();
            }))).write("else", new Object[0])).write("  raise ArgumentError,", new Object[0])).write("        \"Expected #{context} to be a union member of \"\\", new Object[0])).write("        \"Types::" + shapeName + ", got #{input.class}.\"", new Object[0])).write("end", new Object[0])).closeBlock("end", new Object[0])).withQualifiedNamespace("Validators", () -> this.renderValidatorsForUnionMembers(unionMemberShapes)).closeBlock("end", new Object[0]);
            return null;
        }

        public Void documentShape(DocumentShape documentShape) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ValidatorsGenerator.this.symbolProvider.toSymbol((Shape)documentShape).getName()})).openBlock("def self.validate!(input, context:)", new Object[0])).write("$T.validate_types!(input, ::Hash, ::String, ::Array, ::TrueClass, ::FalseClass, ::Numeric, context: context)", new Object[]{Hearth.VALIDATOR})).write("case input", new Object[0])).openBlock("when ::Hash", new Object[0])).write("input.each do |k,v|", new Object[0])).indent()).write("validate!(v, context: \"#{context}[:#{k}]\")", new Object[0])).closeBlock("end", new Object[0])).dedent()).write("when ::Array", new Object[0])).indent()).openBlock("input.each_with_index do |v, i|", new Object[0])).write("validate!(v, context: \"#{context}[#{i}]\")", new Object[0])).closeBlock("end", new Object[0])).dedent()).write("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }

        private void renderValidatorsForUnionMembers(Collection<MemberShape> members) {
            members.forEach(member -> {
                String name = ValidatorsGenerator.this.symbolProvider.toMemberName(member);
                Shape target = ValidatorsGenerator.this.model.expectShape(member.getTarget());
                ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{name})).openBlock("def self.validate!(input, context:)", new Object[0])).call(() -> target.accept((ShapeVisitor)new MemberValidator(this.writer, ValidatorsGenerator.this.symbolProvider, "input", "context", true)))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            });
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        private static class MemberValidator
        extends ShapeVisitor.Default<Void> {
            private final RubyCodeWriter writer;
            private final SymbolProvider symbolProvider;
            private final String input;
            private final String context;
            private Boolean renderUnionMemberValidator;

            MemberValidator(RubyCodeWriter writer, SymbolProvider symbolProvider, String input, String context, Boolean renderUnionMemberValidator) {
                this.writer = writer;
                this.symbolProvider = symbolProvider;
                this.input = input;
                this.context = context;
                this.renderUnionMemberValidator = renderUnionMemberValidator;
            }

            protected Void getDefault(Shape shape) {
                return null;
            }

            public Void blobShape(BlobShape shape) {
                if (shape.hasTrait(StreamingTrait.class)) {
                    ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("unless $1L.respond_to?(:read) || $1L.respond_to?(:readpartial)", new Object[]{this.input})).write("raise ArgumentError, \"Expected #{context} to be an IO like object, got #{$L.class}\"", new Object[]{this.input})).closeBlock("end", new Object[0]);
                    if (shape.hasTrait(RequiresLengthTrait.class)) {
                        ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("\nunless $1L.respond_to?(:size)", new Object[]{this.input})).write("raise ArgumentError, \"Expected #{context} to respond_to(:size)\"", new Object[0])).closeBlock("end", new Object[0]);
                    }
                } else {
                    this.writer.write("$T.validate_types!($L, ::String, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                }
                return null;
            }

            public Void booleanShape(BooleanShape shape) {
                this.writer.write("$T.validate_types!($L, ::TrueClass, ::FalseClass, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void listShape(ListShape shape) {
                Object content = "$1L.validate!($2L, context: $3L) unless $2L.nil?";
                if (this.renderUnionMemberValidator.booleanValue()) {
                    content = "Validators::" + (String)content;
                }
                this.writer.write(content, new Object[]{this.symbolProvider.toSymbol((Shape)shape).getName(), this.input, this.context});
                return null;
            }

            public Void byteShape(ByteShape shape) {
                this.writer.write("$T.validate_types!($L, ::Integer, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void shortShape(ShortShape shape) {
                this.writer.write("$T.validate_types!($L, ::Integer, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void integerShape(IntegerShape shape) {
                this.writer.write("$T.validate_types!($L, ::Integer, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void longShape(LongShape shape) {
                this.writer.write("$T.validate_types!($L, ::Integer, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void floatShape(FloatShape shape) {
                this.writer.write("$T.validate_types!($L, ::Float, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void documentShape(DocumentShape shape) {
                Object content = "$1L.validate!($2L, context: $3L) unless $2L.nil?";
                if (this.renderUnionMemberValidator.booleanValue()) {
                    content = "Validators::" + (String)content;
                }
                this.writer.write(content, new Object[]{this.symbolProvider.toSymbol((Shape)shape).getName(), this.input, this.context});
                return null;
            }

            public Void doubleShape(DoubleShape shape) {
                this.writer.write("$T.validate_types!($L, ::Float, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void bigDecimalShape(BigDecimalShape shape) {
                this.writer.write("$T.validate_types!($L, $T, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, RubyImportContainer.BIG_DECIMAL, this.context});
                return null;
            }

            public Void mapShape(MapShape shape) {
                Object content = "$1L.validate!($2L, context: $3L) unless $2L.nil?";
                if (this.renderUnionMemberValidator.booleanValue()) {
                    content = "Validators::" + (String)content;
                }
                this.writer.write(content, new Object[]{this.symbolProvider.toSymbol((Shape)shape).getName(), this.input, this.context});
                return null;
            }

            public Void stringShape(StringShape shape) {
                this.writer.write("$T.validate_types!($L, ::String, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, this.context});
                return null;
            }

            public Void structureShape(StructureShape shape) {
                Object content = "$1L.validate!($2L, context: $3L) unless $2L.nil?";
                if (this.renderUnionMemberValidator.booleanValue()) {
                    content = "Validators::" + (String)content;
                }
                this.writer.write(content, new Object[]{this.symbolProvider.toSymbol((Shape)shape).getName(), this.input, this.context});
                return null;
            }

            public Void unionShape(UnionShape shape) {
                this.writer.write("$1L.validate!($2L, context: $3L) unless $2L.nil?", new Object[]{this.symbolProvider.toSymbol((Shape)shape).getName(), this.input, this.context});
                return null;
            }

            public Void timestampShape(TimestampShape shape) {
                this.writer.write("$T.validate_types!($L, $T, context: $L)", new Object[]{Hearth.VALIDATOR, this.input, RubyImportContainer.TIME, this.context});
                return null;
            }
        }
    }
}

