/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.ruby.codegen.CodegenUtils;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RestStubsGeneratorBase;

public abstract class StubsGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(RestStubsGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final Set<ShapeId> generatedStubs;
    protected final RubyCodeWriter writer;
    protected final SymbolProvider symbolProvider;

    public StubsGeneratorBase(GenerationContext context) {
        this.settings = context.settings();
        this.model = context.model();
        this.generatedStubs = new HashSet<ShapeId>();
        this.context = context;
        this.writer = new RubyCodeWriter(context.settings().getModule() + "::Stubs");
        this.symbolProvider = context.symbolProvider();
    }

    protected abstract void renderUnionStubMethod(UnionShape var1);

    protected abstract void renderListStubMethod(ListShape var1);

    protected abstract void renderMapStubMethod(MapShape var1);

    protected abstract void renderStructureStubMethod(StructureShape var1);

    protected abstract void renderOperationStubMethod(OperationShape var1, Shape var2);

    protected abstract void renderErrorStubMethod(Shape var1);

    public void render(FileManifest fileManifest) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).apiPrivate().openBlock("module Stubs", new Object[0])).call(() -> this.renderStubs())).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/stubs.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote stubs to " + fileName);
    }

    private void renderStubs() {
        TreeSet<Shape> shapesToBeRendered = CodegenUtils.getAlphabeticalOrderedShapesSet();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.service()));
        containedOperations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> {
            Shape outputShape = this.model.expectShape(o.getOutputShape());
            shapesToBeRendered.add((Shape)o);
            this.generatedStubs.add(o.toShapeId());
            this.generatedStubs.add(outputShape.toShapeId());
            Iterator it = new Walker(this.model).iterateShapes(outputShape);
            while (it.hasNext()) {
                Shape s = (Shape)it.next();
                if (this.generatedStubs.contains(s.getId())) continue;
                this.generatedStubs.add(s.getId());
                shapesToBeRendered.add(s);
            }
            for (ShapeId errorShapeId : o.getErrors()) {
                Iterator errIt = new Walker(this.model).iterateShapes(this.model.expectShape(errorShapeId));
                while (errIt.hasNext()) {
                    Shape s = (Shape)errIt.next();
                    if (this.generatedStubs.contains(s.getId())) continue;
                    this.generatedStubs.add(s.getId());
                    shapesToBeRendered.add(s);
                }
            }
        });
        shapesToBeRendered.forEach(shape -> {
            if (shape instanceof OperationShape) {
                OperationShape operation = (OperationShape)shape;
                Shape outputShape = this.model.expectShape(operation.getOutputShape());
                this.renderStubsForOperation(operation, outputShape);
            } else if (shape.hasTrait(ErrorTrait.class)) {
                this.renderErrorStub((Shape)shape);
            } else {
                shape.accept((ShapeVisitor)new StubClassGenerator());
            }
        });
    }

    private void renderStubsForOperation(OperationShape operation, Shape outputShape) {
        this.generatedStubs.add(outputShape.getId());
        String outputShapeName = this.symbolProvider.toSymbol(outputShape).getName();
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)operation).getName()})).call(() -> this.renderBuildMethod(outputShapeName))).write("", new Object[0])).call(() -> this.renderValidateMethod(outputShapeName))).write("", new Object[0])).call(() -> this.renderDefaultMethod(outputShape))).write("", new Object[0])).call(() -> this.renderOperationStubMethod(operation, outputShape))).closeBlock("end", new Object[0]);
    }

    private void renderErrorStub(Shape errorShape) {
        String errorShapeName = this.symbolProvider.toSymbol(errorShape).getName();
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{errorShapeName})).call(() -> this.renderBuildMethod(errorShapeName))).write("", new Object[0])).call(() -> this.renderValidateMethod(errorShapeName))).write("", new Object[0])).call(() -> this.renderDefaultMethod(errorShape))).write("", new Object[0])).call(() -> this.renderErrorStubMethod(errorShape))).closeBlock("end", new Object[0]);
    }

    private void renderBuildMethod(String className) {
        ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.build(params, context:)", new Object[0])).write("Params::$L.build(params, context: context)", new Object[]{className})).closeBlock("end", new Object[0]);
    }

    private void renderValidateMethod(String className) {
        ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.validate!(output, context:)", new Object[0])).write("Validators::$L.validate!(output, context: context)", new Object[]{className})).closeBlock("end", new Object[0]);
    }

    private void renderDefaultMethod(Shape shape) {
        ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.default(visited = [])", new Object[0])).call(() -> this.renderMemberDefaults(shape))).closeBlock("end", new Object[0]);
    }

    protected void renderMemberDefaults(Shape s) {
        this.writer.openBlock("{", new Object[0]);
        s.members().forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String symbolName = this.symbolProvider.toMemberName(member);
            String dataSetter = symbolName + ": ";
            target.accept((ShapeVisitor)new MemberDefaults(dataSetter, ",", symbolName));
        });
        this.writer.closeBlock("}", new Object[0]);
    }

    private class MemberDefaults
    extends ShapeVisitor.Default<Void> {
        private final String eol;
        private final String dataSetter;
        private final String memberName;

        MemberDefaults(String dataSetter, String eol, String memberName) {
            this.eol = eol;
            this.dataSetter = dataSetter;
            this.memberName = memberName;
        }

        protected Void getDefault(Shape shape) {
            StubsGeneratorBase.this.writer.write("$Lnil$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void blobShape(BlobShape blob) {
            StubsGeneratorBase.this.writer.write("$L'$L'$L", new Object[]{this.dataSetter, this.memberName, this.eol});
            return null;
        }

        public Void byteShape(ByteShape shape) {
            StubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void shortShape(ShortShape shape) {
            StubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            StubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void longShape(LongShape shape) {
            StubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void floatShape(FloatShape shape) {
            StubsGeneratorBase.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void doubleShape(DoubleShape shape) {
            StubsGeneratorBase.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void bigIntegerShape(BigIntegerShape shape) {
            StubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void bigDecimalShape(BigDecimalShape shape) {
            StubsGeneratorBase.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void stringShape(StringShape shape) {
            StubsGeneratorBase.this.writer.write("$L'$L'$L", new Object[]{this.dataSetter, this.memberName, this.eol});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            StubsGeneratorBase.this.writer.write("$LTime.now$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            StubsGeneratorBase.this.writer.write("$Lfalse$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        private void complexShapeDefaults(Shape shape) {
            StubsGeneratorBase.this.writer.write("$L$L.default(visited)$L", new Object[]{this.dataSetter, StubsGeneratorBase.this.symbolProvider.toSymbol(shape).getName(), this.eol});
        }

        public Void listShape(ListShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }
    }

    private class StubClassGenerator
    extends ShapeVisitor.Default<Void> {
        private StubClassGenerator() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            String name = StubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)StubsGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{name})).openBlock("def self.default(visited = [])", new Object[0])).write("return nil if visited.include?('$L')", new Object[]{name})).write("visited = visited + ['$L']", new Object[]{name})).call(() -> StubsGeneratorBase.this.renderMemberDefaults((Shape)shape))).closeBlock("end", new Object[0])).write("", new Object[0])).call(() -> StubsGeneratorBase.this.renderStructureStubMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void listShape(ListShape shape) {
            String name = StubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            Shape memberTarget = StubsGeneratorBase.this.model.expectShape(shape.getMember().getTarget());
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)StubsGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{name})).openBlock("def self.default(visited = [])", new Object[0])).write("return nil if visited.include?('$L')", new Object[]{name})).write("visited = visited + ['$L']", new Object[]{name})).openBlock("[", new Object[0])).call(() -> memberTarget.accept((ShapeVisitor)new MemberDefaults("", "", StubsGeneratorBase.this.symbolProvider.toMemberName(shape.getMember()))))).closeBlock("]", new Object[0])).closeBlock("end", new Object[0])).write("", new Object[0])).call(() -> StubsGeneratorBase.this.renderListStubMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            String name = StubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            Shape valueTarget = StubsGeneratorBase.this.model.expectShape(shape.getValue().getTarget());
            String symbolName = StubsGeneratorBase.this.symbolProvider.toMemberName(shape.getKey());
            String dataSetter = symbolName + ": ";
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)StubsGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{name})).openBlock("def self.default(visited = [])", new Object[0])).write("return nil if visited.include?('$L')", new Object[]{name})).write("visited = visited + ['$L']", new Object[]{name})).openBlock("{", new Object[0])).call(() -> valueTarget.accept((ShapeVisitor)new MemberDefaults(dataSetter, "", StubsGeneratorBase.this.symbolProvider.toMemberName(shape.getValue()))))).closeBlock("}", new Object[0])).closeBlock("end", new Object[0])).write("", new Object[0])).call(() -> StubsGeneratorBase.this.renderMapStubMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            String name = StubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)StubsGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{name})).openBlock("def self.default(visited = [])", new Object[0])).write("return nil if visited.include?('$L')", new Object[]{name})).write("visited = visited + ['$L']", new Object[]{name})).call(() -> {
                StubsGeneratorBase.this.writer.openBlock("{", new Object[0]);
                MemberShape defaultMember = (MemberShape)shape.members().iterator().next();
                Shape target = StubsGeneratorBase.this.model.expectShape(defaultMember.getTarget());
                String symbolName = RubyFormatter.toSnakeCase(StubsGeneratorBase.this.symbolProvider.toMemberName(defaultMember));
                String dataSetter = symbolName + ": ";
                target.accept((ShapeVisitor)new MemberDefaults(dataSetter, ",", symbolName));
                StubsGeneratorBase.this.writer.closeBlock("}", new Object[0]);
            })).closeBlock("end", new Object[0])).write("", new Object[0])).call(() -> StubsGeneratorBase.this.renderUnionStubMethod(shape))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void documentShape(DocumentShape shape) {
            String name = StubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)StubsGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{name})).openBlock("def self.default(visited = [])", new Object[0])).write("return nil if visited.include?('$L')", new Object[]{name})).write("visited = visited + ['$L']", new Object[]{name})).write("{ '$L' => [0, 1, 2] }", new Object[]{name})).closeBlock("end", new Object[0])).write("", new Object[0])).openBlock("def self.stub(stub = {})", new Object[0])).write("stub", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
            return null;
        }
    }
}

