/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ClientFragment {
    private final Set<ClientConfig> clientConfig;
    private final RenderOperation render;

    public ClientFragment(Builder builder) {
        this.clientConfig = builder.clientConfig;
        this.render = builder.render;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<ClientConfig> getClientConfig() {
        return this.clientConfig;
    }

    public String render(GenerationContext context) {
        return this.render.render(this, context);
    }

    public static class Builder
    implements SmithyBuilder<ClientFragment> {
        private Set<ClientConfig> clientConfig = new HashSet<ClientConfig>();
        private RenderOperation render = (f, c) -> "";

        public Builder addConfig(ClientConfig config) {
            this.clientConfig.add(Objects.requireNonNull(config));
            return this;
        }

        public Builder config(Collection<ClientConfig> config) {
            this.clientConfig = new HashSet<ClientConfig>(config);
            return this;
        }

        public Builder render(RenderOperation r) {
            this.render = r;
            return this;
        }

        public Builder render(String staticRubyStatement) {
            this.render = (f, c) -> staticRubyStatement;
            return this;
        }

        public ClientFragment build() {
            return new ClientFragment(this);
        }
    }

    @FunctionalInterface
    public static interface RenderOperation {
        public String render(ClientFragment var1, GenerationContext var2);
    }
}

