/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.ClientConfig;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class MiddlewareBuilder {
    private final Map<MiddlewareStackStep, List<Middleware>> middlewares = new HashMap<MiddlewareStackStep, List<Middleware>>();

    public MiddlewareBuilder() {
        Arrays.stream(MiddlewareStackStep.values()).forEach(step -> {
            List cfr_ignored_0 = this.middlewares.put((MiddlewareStackStep)((Object)step), new ArrayList());
        });
    }

    public void register(Middleware middleware) {
        this.middlewares.get((Object)middleware.getStep()).add(middleware);
    }

    public void register(List<Middleware> middleware) {
        middleware.forEach(m -> this.register((Middleware)m));
    }

    public Set<ClientConfig> getClientConfig(GenerationContext context) {
        Model model = context.getModel();
        ServiceShape service = context.getService();
        HashSet<ClientConfig> config = new HashSet<ClientConfig>();
        for (MiddlewareStackStep step : MiddlewareStackStep.values()) {
            Set stepConfig = this.middlewares.get((Object)step).stream().filter(m -> m.includeFor(model, service)).map(m -> m.getClientConfig()).flatMap(Collection::stream).collect(Collectors.toSet());
            config.addAll(stepConfig);
        }
        return config;
    }

    public List<String> writeAdditionalFiles(GenerationContext context) {
        return this.middlewares.values().stream().flatMap(Collection::stream).map(m -> m.writeAdditionalFiles(context)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void render(RubyCodeWriter writer, GenerationContext context, OperationShape operation) {
        Model model = context.getModel();
        ServiceShape service = context.getService();
        for (MiddlewareStackStep step : MiddlewareStackStep.values()) {
            List orderedStepMiddleware = this.middlewares.get((Object)step).stream().filter(m -> m.includeFor(model, service, operation)).sorted(Comparator.comparing(Middleware::getOrder)).collect(Collectors.toList());
            for (Middleware middleware : orderedStepMiddleware) {
                middleware.renderAdd(writer, context, operation);
            }
        }
    }

    public void addDefaultMiddleware(GenerationContext context) {
        ApplicationTransport transport = context.getApplicationTransport();
        RubySymbolProvider symbolProvider = new RubySymbolProvider(context.getModel(), context.getRubySettings(), "Client", false);
        ClientConfig validateInput = new ClientConfig.Builder().name("validate_input").type("Boolean").defaultValue("true").documentation("When `true`, request parameters are validated using the modeled shapes.").build();
        Middleware validate = new Middleware.Builder().klass("Seahorse::Middleware::Validate").step(MiddlewareStackStep.INITIALIZE).operationParams((ctx, operation) -> {
            ShapeId inputShapeId = operation.getInputShape();
            Shape inputShape = ctx.getModel().expectShape(inputShapeId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("validator", "Validators::" + symbolProvider.toSymbol(inputShape).getName());
            return params;
        }).addConfig(validateInput).build();
        Middleware build = new Middleware.Builder().klass("Seahorse::Middleware::Build").step(MiddlewareStackStep.SERIALIZE).operationParams((ctx, operation) -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("builder", "Builders::" + symbolProvider.toSymbol((Shape)operation).getName());
            return params;
        }).build();
        ClientConfig stubResponses = new ClientConfig.Builder().name("stub_responses").type("Bool").defaultValue("false").documentation("Enable response stubbing. See documentation for {#stub_responses}").build();
        ClientConfig stubs = new ClientConfig.Builder().name("stubs").type("Seahorse::Stubbing::Stubs").initializationCustomization("@stubs = Seahorse::Stubbing::Stubs.new").build();
        Middleware send = new Middleware.Builder().klass("Seahorse::Middleware::Send").step(MiddlewareStackStep.SEND).addParam("client", transport.getTransportClient().render(context)).operationParams((ctx, operation) -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("stub_class", "Stubs::" + symbolProvider.toSymbol((Shape)operation).getName());
            return params;
        }).addConfig(stubResponses).addConfig(stubs).build();
        this.register(validate);
        this.register(build);
        this.register(send);
        this.register(transport.defaultMiddleware(context));
    }
}

