/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.PaginatedIndex;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class PaginatorsGenerator {
    private static final Logger LOGGER = Logger.getLogger(PaginatorsGenerator.class.getName());
    private final GenerationContext context;
    private final RubySettings settings;
    private final Model model;
    private final RubyCodeWriter writer;
    private final RubyCodeWriter rbsWriter;
    private final SymbolProvider symbolProvider;

    public PaginatorsGenerator(GenerationContext context) {
        this.context = context;
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.writer = new RubyCodeWriter();
        this.rbsWriter = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Paginators", false);
    }

    public void render() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.writer.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Paginators", new Object[0]).call(() -> this.renderPaginators()).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/paginators.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote paginators to " + fileName);
    }

    public void renderRbs() {
        FileManifest fileManifest = this.context.getFileManifest();
        this.rbsWriter.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Paginators", new Object[0]).call(() -> this.renderRbsPaginators()).write((Object)"", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String typesFile = this.settings.getGemName() + "/sig/" + this.settings.getGemName() + "/paginators.rbs";
        fileManifest.writeFile(typesFile, this.rbsWriter.toString());
        LOGGER.fine("Wrote paginators types to " + typesFile);
    }

    private void renderPaginators() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        PaginatedIndex paginatedIndex = PaginatedIndex.of((Model)this.model);
        topDownIndex.getContainedOperations((ToShapeId)this.context.getService()).stream().forEach(operation -> {
            Optional paginationInfoOptional = paginatedIndex.getPaginationInfo((ToShapeId)this.context.getService(), (ToShapeId)operation);
            if (paginationInfoOptional.isPresent()) {
                PaginationInfo paginationInfo = (PaginationInfo)paginationInfoOptional.get();
                String operationName = this.symbolProvider.toSymbol((Shape)operation).getName();
                this.renderPaginator(operationName, paginationInfo);
            }
        });
    }

    private void renderRbsPaginators() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        PaginatedIndex paginatedIndex = PaginatedIndex.of((Model)this.model);
        topDownIndex.getContainedOperations((ToShapeId)this.context.getService()).stream().forEach(operation -> {
            Optional paginationInfoOptional = paginatedIndex.getPaginationInfo((ToShapeId)this.context.getService(), (ToShapeId)operation);
            if (paginationInfoOptional.isPresent()) {
                PaginationInfo paginationInfo = (PaginationInfo)paginationInfoOptional.get();
                String operationName = this.symbolProvider.toSymbol((Shape)operation).getName();
                this.renderRbsPaginator(operationName, paginationInfo);
            }
        });
    }

    private void renderPaginator(String operationName, PaginationInfo paginationInfo) {
        this.writer.write("", new Object[0]).openBlock("class $L", new Object[]{operationName}).call(() -> this.renderPaginatorInitializeDocumentation(operationName)).openBlock("def initialize(client, params = {}, options = {})", new Object[0]).write((Object)"@params = params", new Object[0]).write((Object)"@options = options", new Object[0]).write((Object)"@client = client", new Object[0]).closeBlock("end", new Object[0]).call(() -> this.renderPaginatorPages(operationName, paginationInfo)).call(() -> {
            if (!paginationInfo.getItemsMemberPath().isEmpty()) {
                this.renderPaginatorItems(paginationInfo, operationName);
            }
        }).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated paginator for " + operationName);
    }

    private void renderRbsPaginator(String operationName, PaginationInfo paginationInfo) {
        this.rbsWriter.write("", new Object[0]).openBlock("class $L", new Object[]{operationName}).write((Object)"def initialize: (untyped client, ?::Hash[untyped, untyped] params, ?::Hash[untyped, untyped] options) -> void\n", new Object[0]).write((Object)"def pages: () -> untyped", new Object[0]).call(() -> {
            if (!paginationInfo.getItemsMemberPath().isEmpty()) {
                this.rbsWriter.write("def items: () -> untyped", new Object[0]);
            }
        }).closeBlock("end", new Object[0]);
    }

    private void renderPaginatorInitializeDocumentation(String operationName) {
        String snakeOperationName = RubyFormatter.toSnakeCase(operationName);
        this.writer.doc(() -> this.writer.write("@param [Client] client", new Object[0]).write((Object)"@param [Hash] params (see Client#$L)", new Object[]{snakeOperationName}).write((Object)"@param [Hash] options (see Client#$L)", new Object[]{snakeOperationName}));
    }

    private void renderPaginatorPages(String operationName, PaginationInfo paginationInfo) {
        String inputToken = RubyFormatter.toSnakeCase(paginationInfo.getInputTokenMember().getMemberName());
        String outputToken = paginationInfo.getOutputTokenMemberPath().stream().map(member -> RubyFormatter.toSnakeCase(member.getMemberName())).collect(Collectors.joining("."));
        String snakeOperationName = RubyFormatter.toSnakeCase(operationName);
        this.writer.call(() -> this.renderPaginatorPagesDocumentation(snakeOperationName)).openBlock("def pages", new Object[0]).write((Object)"params = @params", new Object[0]).openBlock("Enumerator.new do |e|", new Object[0]).write((Object)"@prev_token = params[:$L]", new Object[]{inputToken}).write((Object)"response = @client.$L(params, @options)", new Object[]{snakeOperationName}).write((Object)"e.yield(response)", new Object[0]).write((Object)"output_token = response.$L", new Object[]{outputToken}).write((Object)"", new Object[0]).openBlock("until output_token.nil? || @prev_token == output_token", new Object[0]).write((Object)"params = params.merge($L: output_token)", new Object[]{inputToken}).write((Object)"response = @client.$L(params, @options)", new Object[]{snakeOperationName}).write((Object)"e.yield(response)", new Object[0]).write((Object)"output_token = response.$L", new Object[]{outputToken}).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
    }

    private void renderPaginatorPagesDocumentation(String snakeOperationName) {
        this.writer.doc(() -> this.writer.write("Iterate all response pages of the $L operation.", new Object[]{snakeOperationName}).write((Object)"@return [Enumerator]", new Object[0]));
    }

    private void renderPaginatorItems(PaginationInfo paginationInfo, String operationName) {
        String items = paginationInfo.getItemsMemberPath().stream().map(member -> RubyFormatter.toSnakeCase(member.getMemberName())).collect(Collectors.joining("."));
        this.writer.write("", new Object[0]).call(() -> this.renderPaginatorItemsDocumentation(operationName)).openBlock("def items", new Object[0]).openBlock("Enumerator.new do |e|", new Object[0]).openBlock("pages.each do |page|", new Object[0]).openBlock("page.$L.each do |item|", new Object[]{items}).write((Object)"e.yield(item)", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
    }

    private void renderPaginatorItemsDocumentation(String operationName) {
        String snakeOperationName = RubyFormatter.toSnakeCase(operationName);
        this.writer.doc(() -> this.writer.write("Iterate all items from pages in the $L operation.", new Object[]{snakeOperationName}).write((Object)"@return [Enumerator]", new Object[0]));
    }
}

