/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpResponseCodeTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;

public abstract class HttpStubsGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(HttpStubsGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final Set<ShapeId> generatedStubs;
    protected final RubyCodeWriter writer;
    protected final SymbolProvider symbolProvider;

    public HttpStubsGeneratorBase(GenerationContext context) {
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.generatedStubs = new HashSet<ShapeId>();
        this.context = context;
        this.writer = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Stubs", true);
    }

    protected abstract void renderPayloadBodyStub(OperationShape var1, Shape var2, MemberShape var3, Shape var4);

    protected abstract void renderNoPayloadBodyStub(OperationShape var1, Shape var2);

    protected abstract void renderUnionMemberStubbers(UnionShape var1);

    protected abstract void renderListMemberStub(ListShape var1);

    protected abstract void renderSetMemberStub(SetShape var1);

    protected abstract void renderMapMemberStub(MapShape var1);

    protected abstract void renderStructureMemberStubbers(StructureShape var1);

    public void render(FileManifest fileManifest) {
        this.writer.writePreamble().openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Stubs", new Object[0]).call(() -> this.renderStubs()).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/stubs.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote stubs to " + fileName);
    }

    private void renderStubs() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.getService()));
        containedOperations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> {
            Shape outputShape = this.model.expectShape(o.getOutputShape());
            this.renderStubsForOperation((OperationShape)o, outputShape);
            this.generatedStubs.add(o.toShapeId());
            Iterator it = new Walker(this.model).iterateShapes(outputShape);
            while (it.hasNext()) {
                Shape s = (Shape)it.next();
                if (this.generatedStubs.contains(s.getId())) continue;
                this.generatedStubs.add(s.getId());
                s.accept((ShapeVisitor)new StubClassGenerator());
            }
        });
    }

    private void renderStubsForOperation(OperationShape operation, Shape outputShape) {
        this.writer.write("", new Object[0]).write((Object)"# Operation Stubber for $L", new Object[]{operation.getId().getName()}).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)operation).getName()}).write((Object)"", new Object[0]).openBlock("def self.default(visited=[])", new Object[0]).call(() -> this.renderMemberDefaults(outputShape)).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).openBlock("def self.stub(http_resp, stub:)", new Object[0]).write((Object)"data = {}", new Object[0]).call(() -> operation.getTrait(HttpTrait.class).ifPresent(httpTrait -> this.writer.write("http_resp.status = $1L", new Object[]{httpTrait.getCode()}))).call(() -> this.renderHeaderStubbers(operation, outputShape)).call(() -> this.renderPrefixHeadersStubbers(operation, outputShape)).call(() -> this.renderResponseCodeStubber(operation, outputShape)).call(() -> this.renderOperationBodyStubber(operation, outputShape)).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated stubber for operation " + operation.getId().getName());
    }

    protected void renderOperationBodyStubber(OperationShape operation, Shape outputShape) {
        this.generatedStubs.add(outputShape.getId());
        boolean serializeBody = outputShape.members().stream().anyMatch(m -> !m.hasTrait(HttpLabelTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class) && !m.hasTrait(HttpResponseCodeTrait.class));
        List httpPayloadMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpPayloadTrait.class)).collect(Collectors.toList());
        if (httpPayloadMembers.size() == 0) {
            if (serializeBody) {
                this.renderNoPayloadBodyStub(operation, outputShape);
            }
        } else {
            MemberShape payloadMember = (MemberShape)httpPayloadMembers.get(0);
            Shape target = this.model.expectShape(payloadMember.getTarget());
            this.renderPayloadBodyStub(operation, outputShape, payloadMember, target);
        }
    }

    protected void renderHeaderStubbers(OperationShape operation, Shape outputShape) {
        List headerMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpHeaderTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpHeaderTrait headerTrait = (HttpHeaderTrait)m2.expectTrait(HttpHeaderTrait.class);
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_resp.headers['" + headerTrait.getValue() + "'] = ";
            String valueGetter = "stub[" + symbolName + "]";
            this.model.expectShape(m2.getTarget()).accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, valueGetter));
        }
    }

    protected void renderPrefixHeadersStubbers(OperationShape operation, Shape outputShape) {
        List headerMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpPrefixHeadersTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpPrefixHeadersTrait headerTrait = (HttpPrefixHeadersTrait)m2.expectTrait(HttpPrefixHeadersTrait.class);
            String prefix = headerTrait.getValue();
            MapShape targetShape = (MapShape)this.model.expectShape(m2.getTarget(), MapShape.class);
            Shape valueShape = this.model.expectShape(targetShape.getValue().getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_resp.headers[\"" + prefix + "#{key}\"] = ";
            this.writer.openBlock("stub[$L].each do |key, value|", new Object[]{symbolName}).call(() -> {
                Void cfr_ignored_0 = (Void)valueShape.accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, "value"));
            }).closeBlock("end", new Object[0]);
        }
    }

    protected void renderResponseCodeStubber(OperationShape operation, Shape outputShape) {
        List responseCodeMembers = outputShape.members().stream().filter(m -> m.hasTrait(HttpResponseCodeTrait.class)).collect(Collectors.toList());
        if (responseCodeMembers.size() == 1) {
            MemberShape responseCodeMember = (MemberShape)responseCodeMembers.get(0);
            this.writer.write("http_resp.status = stub[:$L]", new Object[]{this.symbolProvider.toMemberName(responseCodeMember)});
        }
    }

    protected void renderMemberDefaults(Shape s) {
        this.writer.openBlock("{", new Object[0]);
        s.members().forEach(member -> {
            Shape target = this.model.expectShape(member.getTarget());
            String symbolName = this.symbolProvider.toMemberName(member);
            String dataSetter = symbolName + ": ";
            target.accept((ShapeVisitor)new MemberDefaults(dataSetter, ",", symbolName));
        });
        this.writer.closeBlock("}", new Object[0]);
    }

    private class HeaderListMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;

        HeaderListMemberSerializer(MemberShape memberShape) {
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            HttpStubsGeneratorBase.this.writer.write(".map { |s| s.to_s }", new Object[0]);
            return null;
        }

        public Void stringShape(StringShape shape) {
            HttpStubsGeneratorBase.this.writer.write(".map { |s| (s.include?('\"') || s.include?(\",\")) ? \"\\\"#{s.gsub('\"', '\\\"')}\\\"\" : s }", new Object[0]);
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        HttpStubsGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_epoch_seconds(s) }", new Object[0]);
                        break;
                    }
                    case DATE_TIME: {
                        HttpStubsGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_date_time(s) }", new Object[0]);
                        break;
                    }
                    default: {
                        HttpStubsGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_date_time(s) }", new Object[0]);
                        break;
                    }
                }
            } else {
                HttpStubsGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_date_time(s) }", new Object[0]);
            }
            return null;
        }
    }

    private class HeaderSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String dataSetter;
        private final MemberShape memberShape;

        HeaderSerializer(MemberShape memberShape, String dataSetter, String inputGetter) {
            this.inputGetter = inputGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            HttpStubsGeneratorBase.this.writer.write("$1L$2L.to_s unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(MediaTypeTrait.class)) {
                HttpStubsGeneratorBase.this.writer.write("$1LBase64::encode64($2L).strip unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter});
            } else {
                HttpStubsGeneratorBase.this.writer.write("$1L$2L unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter});
            }
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (!format.isPresent()) {
                format = shape.getTrait(TimestampFormatTrait.class);
            }
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        HttpStubsGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_epoch_seconds($2L).to_i unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
                        break;
                    }
                    case DATE_TIME: {
                        HttpStubsGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_date_time($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
                        break;
                    }
                    default: {
                        HttpStubsGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_http_date($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
                        break;
                    }
                }
            } else {
                HttpStubsGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_http_date($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
            }
            return null;
        }

        public Void listShape(ListShape shape) {
            HttpStubsGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter}).write((Object)"$1L$2L", new Object[]{this.dataSetter, this.inputGetter}).indent().write((Object)".compact", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)HttpStubsGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberSerializer(shape.getMember()));
            }).write((Object)".join(', ')", new Object[0]).dedent().closeBlock("end", new Object[0]);
            return null;
        }

        public Void setShape(SetShape shape) {
            HttpStubsGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter}).write((Object)"$1L$2L", new Object[]{this.dataSetter, this.inputGetter}).indent().write((Object)".to_a", new Object[0]).write((Object)".compact", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)HttpStubsGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberSerializer(shape.getMember()));
            }).write((Object)".join(', ')", new Object[0]).dedent().closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            return null;
        }

        public Void unionShape(UnionShape shape) {
            return null;
        }
    }

    private class MemberDefaults
    extends ShapeVisitor.Default<Void> {
        private final String eol;
        private final String dataSetter;
        private final String memberName;

        MemberDefaults(String dataSetter, String eol, String memberName) {
            this.eol = eol;
            this.dataSetter = dataSetter;
            this.memberName = memberName;
        }

        protected Void getDefault(Shape shape) {
            HttpStubsGeneratorBase.this.writer.write("$Lnil$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void blobShape(BlobShape blob) {
            HttpStubsGeneratorBase.this.writer.write("$L'$L'$L", new Object[]{this.dataSetter, this.memberName, this.eol});
            return null;
        }

        public Void byteShape(ByteShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void shortShape(ShortShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void integerShape(IntegerShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void longShape(LongShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void floatShape(FloatShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void doubleShape(DoubleShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void bigIntegerShape(BigIntegerShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void bigDecimalShape(BigDecimalShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L1.0$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void stringShape(StringShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$L'$L'$L", new Object[]{this.dataSetter, this.memberName, this.eol});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$LTime.now$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        public Void booleanShape(BooleanShape shape) {
            HttpStubsGeneratorBase.this.writer.write("$Lfalse$L", new Object[]{this.dataSetter, this.eol});
            return null;
        }

        private void complexShapeDefaults(Shape shape) {
            HttpStubsGeneratorBase.this.writer.write("$LStubs::$L.default(visited)$L", new Object[]{this.dataSetter, HttpStubsGeneratorBase.this.symbolProvider.toSymbol(shape).getName(), this.eol});
        }

        public Void listShape(ListShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }

        public Void setShape(SetShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }

        public Void mapShape(MapShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }

        public Void structureShape(StructureShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            this.complexShapeDefaults((Shape)shape);
            return null;
        }
    }

    private class StubClassGenerator
    extends ShapeVisitor.Default<Void> {
        private StubClassGenerator() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            String name = HttpStubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            HttpStubsGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Structure Stubber for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{name}).write((Object)"", new Object[0]).openBlock("def self.default(visited=[])", new Object[0]).write((Object)"return nil if visited.include?('$L')", new Object[]{name}).write((Object)"visited = visited + ['$L']", new Object[]{name}).call(() -> HttpStubsGeneratorBase.this.renderMemberDefaults((Shape)shape)).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).openBlock("def self.stub(stub = {})", new Object[0]).write((Object)"stub ||= {}", new Object[0]).write((Object)"data = {}", new Object[0]).call(() -> HttpStubsGeneratorBase.this.renderStructureMemberStubbers(shape)).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void listShape(ListShape shape) {
            String name = HttpStubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            Shape memberTarget = HttpStubsGeneratorBase.this.model.expectShape(shape.getMember().getTarget());
            HttpStubsGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# List Stubber for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{name}).openBlock("def self.default(visited=[])", new Object[0]).write((Object)"return nil if visited.include?('$L')", new Object[]{name}).write((Object)"visited = visited + ['$L']", new Object[]{name}).openBlock("[", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)memberTarget.accept((ShapeVisitor)new MemberDefaults("", "", HttpStubsGeneratorBase.this.symbolProvider.toMemberName(shape.getMember())));
            }).closeBlock("]", new Object[0]).closeBlock("end", new Object[0]).openBlock("def self.stub(stub = [])", new Object[0]).write((Object)"data = []", new Object[0]).openBlock("stub.each do |element|", new Object[0]).call(() -> HttpStubsGeneratorBase.this.renderListMemberStub(shape)).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void setShape(SetShape shape) {
            String name = HttpStubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            MemberShape member = shape.getMember();
            Shape memberTarget = HttpStubsGeneratorBase.this.model.expectShape(member.getTarget());
            HttpStubsGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Set Stubber for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{name}).openBlock("def self.default(visited=[])", new Object[0]).write((Object)"return nil if visited.include?('$L')", new Object[]{name}).write((Object)"visited = visited + ['$L']", new Object[]{name}).openBlock("[", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)memberTarget.accept((ShapeVisitor)new MemberDefaults("", "", HttpStubsGeneratorBase.this.symbolProvider.toMemberName(shape.getMember())));
            }).closeBlock("]", new Object[0]).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).openBlock("def self.stub(stub = [])", new Object[0]).write((Object)"data = Set.new", new Object[0]).openBlock("stub.each do |element|", new Object[0]).call(() -> HttpStubsGeneratorBase.this.renderSetMemberStub(shape)).closeBlock("end", new Object[0]).write((Object)"data.to_a", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            String name = HttpStubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            Shape valueTarget = HttpStubsGeneratorBase.this.model.expectShape(shape.getValue().getTarget());
            HttpStubsGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Map Stubber for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{name}).openBlock("def self.default(visited=[])", new Object[0]).write((Object)"return nil if visited.include?('$L')", new Object[]{name}).write((Object)"visited = visited + ['$L']", new Object[]{name}).openBlock("{", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)valueTarget.accept((ShapeVisitor)new MemberDefaults("test_key: ", "", HttpStubsGeneratorBase.this.symbolProvider.toMemberName(shape.getValue())));
            }).closeBlock("}", new Object[0]).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).openBlock("def self.stub(stub = {})", new Object[0]).write((Object)"data = {}", new Object[0]).openBlock("stub.each do |key, value|", new Object[0]).call(() -> HttpStubsGeneratorBase.this.renderMapMemberStub(shape)).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            String name = HttpStubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            HttpStubsGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Union Stubber for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{name}).openBlock("\ndef self.default(visited=[])", new Object[0]).write((Object)"return nil if visited.include?('$L')", new Object[]{name}).write((Object)"visited = visited + ['$L']", new Object[]{name}).call(() -> {
                HttpStubsGeneratorBase.this.writer.openBlock("{", new Object[0]);
                MemberShape defaultMember = (MemberShape)shape.members().iterator().next();
                Shape target = HttpStubsGeneratorBase.this.model.expectShape(defaultMember.getTarget());
                String symbolName = RubyFormatter.toSnakeCase(HttpStubsGeneratorBase.this.symbolProvider.toMemberName(defaultMember));
                String dataSetter = symbolName + ": ";
                target.accept((ShapeVisitor)new MemberDefaults(dataSetter, ",", symbolName));
                HttpStubsGeneratorBase.this.writer.closeBlock("}", new Object[0]);
            }).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).openBlock("def self.stub(stub = {})", new Object[0]).write((Object)"stub ||= {}", new Object[0]).write((Object)"data = {}", new Object[0]).call(() -> HttpStubsGeneratorBase.this.renderUnionMemberStubbers(shape)).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void documentShape(DocumentShape shape) {
            String name = HttpStubsGeneratorBase.this.symbolProvider.toSymbol((Shape)shape).getName();
            HttpStubsGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Document Type Stubber for $L", new Object[]{name}).openBlock("class $L", new Object[]{name}).openBlock("def self.default(visited=[])", new Object[0]).write((Object)"return nil if visited.include?('$L')", new Object[]{name}).write((Object)"visited = visited + ['$L']", new Object[]{name}).write((Object)"{ '$L' => [0, 1, 2] }", new Object[]{name}).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).openBlock("def self.stub(stub = {})", new Object[0]).write((Object)"stub", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }
    }
}

