/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class HttpBuilderGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(HttpBuilderGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final Set<ShapeId> generatedBuilders;
    protected final RubyCodeWriter writer;
    protected final SymbolProvider symbolProvider;

    public HttpBuilderGeneratorBase(GenerationContext context) {
        this.settings = context.getRubySettings();
        this.model = context.getModel();
        this.generatedBuilders = new HashSet<ShapeId>();
        this.context = context;
        this.writer = new RubyCodeWriter();
        this.symbolProvider = new RubySymbolProvider(this.model, this.settings, "Builder", true);
    }

    protected abstract void renderPayloadBodyBuilder(OperationShape var1, Shape var2, MemberShape var3, Shape var4);

    protected abstract void renderNoPayloadBodyBuilder(OperationShape var1, Shape var2);

    protected abstract void renderStructureMemberBuilders(StructureShape var1);

    protected abstract void renderListMemberBuilder(ListShape var1);

    protected abstract void renderSetMemberBuilder(SetShape var1);

    protected abstract void renderUnionMemberBuilder(UnionShape var1, MemberShape var2);

    protected abstract void renderMapMemberBuilder(MapShape var1);

    public void render(FileManifest fileManifest) {
        this.writer.writePreamble().write("require 'base64'\n", new Object[0]).openBlock("module $L", new Object[]{this.settings.getModule()}).openBlock("module Builders", new Object[0]).call(() -> this.renderBuilders()).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/builders.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote builders to " + fileName);
    }

    protected void renderBuilders() {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.getService()));
        containedOperations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> {
            Shape inputShape = this.model.expectShape(o.getInputShape());
            this.renderBuildersForOperation((OperationShape)o, inputShape);
            this.generatedBuilders.add(o.toShapeId());
            this.generatedBuilders.add(inputShape.toShapeId());
            Iterator it = new Walker(this.model).iterateShapes(inputShape);
            while (it.hasNext()) {
                Shape s = (Shape)it.next();
                if (this.generatedBuilders.contains(s.getId())) continue;
                this.generatedBuilders.add(s.getId());
                s.accept((ShapeVisitor)new BuilderClassGenerator());
            }
        });
    }

    protected void renderBuildersForOperation(OperationShape operation, Shape inputShape) {
        Symbol symbol = this.symbolProvider.toSymbol((Shape)operation);
        this.writer.write("", new Object[0]).write((Object)"# Operation Builder for $L", new Object[]{operation.getId().getName()}).openBlock("class $L", new Object[]{symbol.getName()}).openBlock("def self.build(http_req, input:)", new Object[0]).call(() -> operation.getTrait(HttpTrait.class).ifPresent(httpTrait -> this.writer.write("http_req.http_method = '$L'", new Object[]{httpTrait.getMethod()}))).call(() -> this.renderUriBuilder(operation, inputShape)).call(() -> this.renderQueryInputBuilder(operation, inputShape)).call(() -> this.renderHeadersBuilder(operation, inputShape)).call(() -> this.renderPrefixHeadersBuilder(operation, inputShape)).call(() -> this.renderOperationBodyBuilder(operation, inputShape)).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated operation builder for: " + operation.getId().getName());
    }

    protected void renderQueryInputBuilder(OperationShape operation, Shape inputShape) {
        String inputGetter;
        List queryMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpQueryTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : queryMembers) {
            HttpQueryTrait queryTrait = (HttpQueryTrait)m2.expectTrait(HttpQueryTrait.class);
            inputGetter = "input[:" + this.symbolProvider.toMemberName(m2) + "]";
            Shape target = this.model.expectShape(m2.getTarget());
            target.accept((ShapeVisitor)new QueryMemberSerializer(m2, "'" + queryTrait.getValue() + "'", inputGetter));
            LOGGER.finest("Generated query input builder for " + m2.getMemberName());
        }
        List queryParamsMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpQueryParamsTrait.class)).collect(Collectors.toList());
        for (MemberShape m3 : queryParamsMembers) {
            inputGetter = "input[:" + this.symbolProvider.toMemberName(m3) + "]";
            MapShape queryParamMap = (MapShape)this.model.expectShape(m3.getTarget(), MapShape.class);
            Shape target = this.model.expectShape(queryParamMap.getValue().getTarget());
            this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{inputGetter}).openBlock("$1L.each do |k, v|", new Object[]{inputGetter}).call(() -> {
                Void cfr_ignored_0 = (Void)target.accept((ShapeVisitor)new QueryMemberSerializer(queryParamMap.getValue(), "k", "v"));
            }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            LOGGER.finest("Generated query params builder for " + m3.getMemberName());
        }
    }

    protected void renderHeadersBuilder(OperationShape operation, Shape inputShape) {
        List headerMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpHeaderTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpHeaderTrait headerTrait = (HttpHeaderTrait)m2.expectTrait(HttpHeaderTrait.class);
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_req.headers['" + headerTrait.getValue() + "'] = ";
            String valueGetter = "input[" + symbolName + "]";
            this.model.expectShape(m2.getTarget()).accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, valueGetter));
            LOGGER.finest("Generated header builder for " + m2.getMemberName());
        }
    }

    protected void renderPrefixHeadersBuilder(OperationShape operation, Shape inputShape) {
        List headerMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpPrefixHeadersTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpPrefixHeadersTrait headerTrait = (HttpPrefixHeadersTrait)m2.expectTrait(HttpPrefixHeadersTrait.class);
            String prefix = headerTrait.getValue();
            MapShape targetShape = (MapShape)this.model.expectShape(m2.getTarget(), MapShape.class);
            Shape valueShape = this.model.expectShape(targetShape.getValue().getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_req.headers[\"" + prefix + "#{key}\"] = ";
            this.writer.openBlock("input[$L].each do |key, value|", new Object[]{symbolName}).call(() -> {
                Void cfr_ignored_0 = (Void)valueShape.accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, "value"));
            }).closeBlock("end", new Object[0]);
            LOGGER.finest("Generated prefix header builder for " + m2.getMemberName());
        }
    }

    protected void renderUriBuilder(OperationShape operation, Shape inputShape) {
        List labelMembers;
        HttpTrait httpTrait = (HttpTrait)operation.expectTrait(HttpTrait.class);
        String uri = httpTrait.getUri().toString();
        String[] uriParts = uri.split("[?]");
        if (uriParts.length > 1) {
            uri = uriParts[0];
            this.writer.openBlock("CGI.parse('$L').each do |k,v|", new Object[]{uriParts[1]}).write((Object)"v.each { |q_v| http_req.append_query_param(k, q_v) }", new Object[0]).closeBlock("end", new Object[0]);
        }
        if ((labelMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpLabelTrait.class)).collect(Collectors.toList())).size() > 0) {
            Optional<Object> greedyLabel = Optional.empty();
            Matcher greedyMatch = Pattern.compile("[{]([a-zA-Z0-9_]+)[+][}]").matcher(uri);
            if (greedyMatch.find()) {
                greedyLabel = Optional.of(greedyMatch.group(1));
                uri = greedyMatch.replaceAll("%<$1>s");
            }
            String formatUri = uri.replaceAll("[{]([a-zA-Z0-9_]+)[}]", "%<$1>s");
            StringBuffer formatArgs = new StringBuffer();
            for (MemberShape m2 : labelMembers) {
                Shape target = this.model.expectShape(m2.getTarget());
                if (greedyLabel.isPresent() && ((String)greedyLabel.get()).equals(m2.getMemberName())) {
                    formatArgs.append(",\n  " + m2.getMemberName() + ": (" + (String)target.accept((ShapeVisitor)new LabelMemberSerializer(m2)) + ").split('/').map { |s| Seahorse::HTTP.uri_escape(s) }.join('/')");
                } else {
                    formatArgs.append(",\n  " + m2.getMemberName() + ": Seahorse::HTTP.uri_escape(" + (String)target.accept((ShapeVisitor)new LabelMemberSerializer(m2)) + ")");
                }
                LOGGER.finest("Generated label for " + m2.getMemberName());
            }
            this.writer.openBlock("http_req.append_path(format(", new Object[0]);
            this.writer.write("  '$L'$L\n)", new Object[]{formatUri, formatArgs.toString()});
            this.writer.closeBlock(")", new Object[0]);
        } else {
            this.writer.write("http_req.append_path('$L')", new Object[]{uri});
        }
    }

    protected void renderOperationBodyBuilder(OperationShape operation, Shape inputShape) {
        this.generatedBuilders.add(inputShape.getId());
        boolean serializeBody = inputShape.members().stream().anyMatch(m -> !m.hasTrait(HttpLabelTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class));
        if (serializeBody) {
            List httpPayloadMembers = inputShape.members().stream().filter(m -> m.hasTrait(HttpPayloadTrait.class)).collect(Collectors.toList());
            if (httpPayloadMembers.size() == 0) {
                this.renderNoPayloadBodyBuilder(operation, inputShape);
            } else {
                MemberShape payloadMember = (MemberShape)httpPayloadMembers.get(0);
                Shape target = this.model.expectShape(payloadMember.getTarget());
                this.renderPayloadBodyBuilder(operation, inputShape, payloadMember, target);
            }
        }
    }

    protected class BuilderClassGenerator
    extends ShapeVisitor.Default<Void> {
        protected BuilderClassGenerator() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            Symbol symbol = HttpBuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            HttpBuilderGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Structure Builder for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{symbol.getName()}).openBlock("def self.build(input)", new Object[0]).write((Object)"data = {}", new Object[0]).call(() -> HttpBuilderGeneratorBase.this.renderStructureMemberBuilders(shape)).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void listShape(ListShape shape) {
            Symbol symbol = HttpBuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            HttpBuilderGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# List Builder for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{symbol.getName()}).openBlock("def self.build(input)", new Object[0]).write((Object)"data = []", new Object[0]).openBlock("input.each do |element|", new Object[0]).call(() -> HttpBuilderGeneratorBase.this.renderListMemberBuilder(shape)).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void setShape(SetShape shape) {
            Symbol symbol = HttpBuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            HttpBuilderGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Set Builder for $L", new Object[]{shape.getId().getName()}).openBlock("\nclass $L", new Object[]{symbol.getName()}).openBlock("def self.build(input)", new Object[0]).write((Object)"data = Set.new", new Object[0]).openBlock("input.each do |element|", new Object[0]).call(() -> HttpBuilderGeneratorBase.this.renderSetMemberBuilder(shape)).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            Symbol symbol = HttpBuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            HttpBuilderGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Map Builder for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{symbol.getName()}).openBlock("def self.build(input)", new Object[0]).write((Object)"data = {}", new Object[0]).openBlock("input.each do |key, value|", new Object[0]).call(() -> HttpBuilderGeneratorBase.this.renderMapMemberBuilder(shape)).closeBlock("end", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape shape) {
            Symbol symbol = HttpBuilderGeneratorBase.this.symbolProvider.toSymbol((Shape)shape);
            HttpBuilderGeneratorBase.this.writer.write("", new Object[0]).write((Object)"# Structure Builder for $L", new Object[]{shape.getId().getName()}).openBlock("class $L", new Object[]{symbol.getName()}).openBlock("def self.build(input)", new Object[0]).write((Object)"data = {}", new Object[0]).write((Object)"case input", new Object[0]);
            shape.members().forEach(member -> {
                HttpBuilderGeneratorBase.this.writer.write("when Types::$L::$L", new Object[]{shape.getId().getName(), HttpBuilderGeneratorBase.this.symbolProvider.toMemberName(member)}).indent();
                HttpBuilderGeneratorBase.this.renderUnionMemberBuilder(shape, (MemberShape)member);
                HttpBuilderGeneratorBase.this.writer.dedent();
            });
            HttpBuilderGeneratorBase.this.writer.openBlock("else", new Object[0]).write((Object)"raise ArgumentError,\n\"Expected input to be one of the subclasses of Types::$L\"", new Object[]{symbol.getName()}).closeBlock("end", new Object[0]).write((Object)"", new Object[0]).write((Object)"data", new Object[0]).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }
    }

    protected class QueryMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String headerName;
        private final MemberShape memberShape;

        QueryMemberSerializer(MemberShape memberShape, String headerName, String inputGetter) {
            this.inputGetter = inputGetter;
            this.headerName = headerName;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            HttpBuilderGeneratorBase.this.writer.write("http_req.append_query_param($1L, $2L.to_s) unless $2L.nil?", new Object[]{this.headerName, this.inputGetter});
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (!format.isPresent()) {
                format = shape.getTrait(TimestampFormatTrait.class);
            }
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        HttpBuilderGeneratorBase.this.writer.write("http_req.append_query_param($1L, Seahorse::TimeHelper.to_epoch_seconds($2L).to_i) unless $2L.nil?", new Object[]{this.headerName, this.inputGetter});
                        break;
                    }
                    case HTTP_DATE: {
                        HttpBuilderGeneratorBase.this.writer.write("http_req.append_query_param($1L, Seahorse::TimeHelper.to_http_date($2L)) unless $2L.nil?", new Object[]{this.headerName, this.inputGetter});
                        break;
                    }
                    default: {
                        HttpBuilderGeneratorBase.this.writer.write("http_req.append_query_param($1L, Seahorse::TimeHelper.to_date_time($2L)) unless $2L.nil?", new Object[]{this.headerName, this.inputGetter});
                        break;
                    }
                }
            } else {
                HttpBuilderGeneratorBase.this.writer.write("http_req.append_query_param($1L, Seahorse::TimeHelper.to_date_time($2L)) unless $2L.nil?", new Object[]{this.headerName, this.inputGetter});
            }
            return null;
        }

        public Void listShape(ListShape shape) {
            Shape target = HttpBuilderGeneratorBase.this.model.expectShape(shape.getMember().getTarget());
            HttpBuilderGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter}).openBlock("$1L.each do |value|", new Object[]{this.inputGetter}).call(() -> {
                Void cfr_ignored_0 = (Void)target.accept((ShapeVisitor)new QueryMemberSerializer(shape.getMember(), this.headerName, "value"));
            }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void setShape(SetShape shape) {
            Shape target = HttpBuilderGeneratorBase.this.model.expectShape(shape.getMember().getTarget());
            HttpBuilderGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter}).openBlock("$1L.each do |value|", new Object[]{this.inputGetter}).call(() -> {
                Void cfr_ignored_0 = (Void)target.accept((ShapeVisitor)new QueryMemberSerializer(shape.getMember(), this.headerName, "value"));
            }).closeBlock("end", new Object[0]).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            return null;
        }

        public Void unionShape(UnionShape shape) {
            return null;
        }
    }

    protected class LabelMemberSerializer
    extends ShapeVisitor.Default<String> {
        private final MemberShape memberShape;

        LabelMemberSerializer(MemberShape memberShape) {
            this.memberShape = memberShape;
        }

        protected String getDefault(Shape shape) {
            String symbolName = ":" + HttpBuilderGeneratorBase.this.symbolProvider.toMemberName(this.memberShape);
            return "input[" + symbolName + "].to_s";
        }

        public String timestampShape(TimestampShape shape) {
            Optional formatTrait = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (!formatTrait.isPresent()) {
                formatTrait = shape.getTrait(TimestampFormatTrait.class);
            }
            TimestampFormatTrait.Format format = TimestampFormatTrait.Format.DATE_TIME;
            if (formatTrait.isPresent()) {
                format = ((TimestampFormatTrait)formatTrait.get()).getFormat();
            }
            String symbolName = ":" + HttpBuilderGeneratorBase.this.symbolProvider.toMemberName(this.memberShape);
            switch (format) {
                case EPOCH_SECONDS: {
                    return "Seahorse::TimeHelper.to_epoch_seconds(input[" + symbolName + "]).to_i.to_s";
                }
                case HTTP_DATE: {
                    return "Seahorse::TimeHelper.to_http_date(input[" + symbolName + "])";
                }
            }
            return "Seahorse::TimeHelper.to_date_time(input[" + symbolName + "])";
        }
    }

    protected class HeaderListMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;

        HeaderListMemberSerializer(MemberShape memberShape) {
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            HttpBuilderGeneratorBase.this.writer.write(".map { |s| s.to_s }", new Object[0]);
            return null;
        }

        public Void stringShape(StringShape shape) {
            HttpBuilderGeneratorBase.this.writer.write(".map { |s| (s.include?('\"') || s.include?(\",\")) ? \"\\\"#{s.gsub('\"', '\\\"')}\\\"\" : s }", new Object[0]);
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        HttpBuilderGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_epoch_seconds(s) }", new Object[0]);
                        break;
                    }
                    case DATE_TIME: {
                        HttpBuilderGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_date_time(s) }", new Object[0]);
                        break;
                    }
                    default: {
                        HttpBuilderGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_http_date(s) }", new Object[0]);
                        break;
                    }
                }
            } else {
                HttpBuilderGeneratorBase.this.writer.write(".map { |s| Seahorse::TimeHelper.to_http_date(s) }", new Object[0]);
            }
            return null;
        }
    }

    protected class HeaderSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String dataSetter;
        private final MemberShape memberShape;

        HeaderSerializer(MemberShape memberShape, String dataSetter, String inputGetter) {
            this.inputGetter = inputGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            HttpBuilderGeneratorBase.this.writer.write("$1L$2L.to_s unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(MediaTypeTrait.class)) {
                HttpBuilderGeneratorBase.this.writer.write("$1LBase64::encode64($2L).strip unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter});
            } else {
                HttpBuilderGeneratorBase.this.writer.write("$1L$2L unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter});
            }
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            Optional format = this.memberShape.getTrait(TimestampFormatTrait.class);
            if (!format.isPresent()) {
                format = shape.getTrait(TimestampFormatTrait.class);
            }
            if (format.isPresent()) {
                switch (((TimestampFormatTrait)format.get()).getFormat()) {
                    case EPOCH_SECONDS: {
                        HttpBuilderGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_epoch_seconds($2L).to_i unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
                        break;
                    }
                    case DATE_TIME: {
                        HttpBuilderGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_date_time($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
                        break;
                    }
                    default: {
                        HttpBuilderGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_http_date($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
                        break;
                    }
                }
            } else {
                HttpBuilderGeneratorBase.this.writer.write("$1LSeahorse::TimeHelper.to_http_date($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
            }
            return null;
        }

        public Void listShape(ListShape shape) {
            HttpBuilderGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter}).write((Object)"$1L$2L", new Object[]{this.dataSetter, this.inputGetter}).indent().write((Object)".compact", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)HttpBuilderGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberSerializer(shape.getMember()));
            }).write((Object)".join(', ')", new Object[0]).dedent().closeBlock("end", new Object[0]);
            return null;
        }

        public Void setShape(SetShape shape) {
            HttpBuilderGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter}).write((Object)"$1L$2L", new Object[]{this.dataSetter, this.inputGetter}).indent().write((Object)".to_a", new Object[0]).write((Object)".compact", new Object[0]).call(() -> {
                Void cfr_ignored_0 = (Void)HttpBuilderGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberSerializer(shape.getMember()));
            }).write((Object)".join(', ')", new Object[0]).dedent().closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            return null;
        }

        public Void unionShape(UnionShape shape) {
            return null;
        }
    }
}

