/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.CodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.knowledge.SerdeIndex;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.JsonSerdeDescriptorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.JsonSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeStructGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeUnionGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataSerializerGenerator;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J.\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/JsonSerializerGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataSerializerGenerator;", "protocolGenerator", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGenerator;", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGenerator;)V", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "addNestedDocumentSerializers", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "documentSerializer", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "operationSerializer", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "payloadSerializer", "member", "renderSerializeOperationBody", "documentMembers", "renderSerializerBody", "smithy-kotlin-codegen"})
public class JsonSerializerGenerator
implements StructuredDataSerializerGenerator {
    @NotNull
    private final HttpBindingProtocolGenerator protocolGenerator;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public JsonSerializerGenerator(@NotNull HttpBindingProtocolGenerator protocolGenerator) {
        Intrinsics.checkNotNullParameter((Object)protocolGenerator, (String)"protocolGenerator");
        this.protocolGenerator = protocolGenerator;
        this.defaultTimestampFormat = TimestampFormatTrait.Format.EPOCH_SECONDS;
    }

    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @Override
    @NotNull
    public Symbol operationSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull List<MemberShape> members) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Shape input = ctx.getModel().expectShape((ShapeId)op.getInput().get());
        Symbol symbol = ctx.getSymbolProvider().toSymbol(input);
        return SerdeExtKt.bodySerializer(op, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(this, ctx, op, symbol, members){
            final /* synthetic */ JsonSerializerGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ OperationShape $op;
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ List<MemberShape> $members;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$op = $op;
                this.$symbol = $symbol;
                this.$members = $members;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                JsonSerializerGenerator.access$addNestedDocumentSerializers(this.this$0, this.$ctx, (Shape)this.$op, writer);
                String fnName = SerdeExtKt.bodySerializerName(this.$op);
                Object[] objectArray = new Object[]{fnName, RuntimeTypes.Core.INSTANCE.getExecutionContext(), this.$symbol};
                writer.openBlock("private fun #L(context: #T, input: #T): ByteArray {", objectArray).call(() -> operationSerializer.1.invoke$lambda-0(this.this$0, this.$ctx, this.$op, this.$members, writer)).closeBlock("}", new Object[0]);
            }

            private static final void invoke$lambda-0(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, List $members, KotlinWriter $writer) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
                Intrinsics.checkNotNullParameter((Object)$members, (String)"$members");
                Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
                JsonSerializerGenerator.access$renderSerializeOperationBody(this$0, $ctx, $op, $members, $writer);
            }
        }));
    }

    private final void addNestedDocumentSerializers(ProtocolGenerator.GenerationContext ctx, Shape shape, KotlinWriter writer) {
        SerdeIndex serdeIndex = SerdeIndex.Companion.of(ctx.getModel());
        Set<Shape> shapesRequiringDocumentSerializer = serdeIndex.requiresDocumentSerializer(shape);
        Iterable $this$forEach$iv = shapesRequiringDocumentSerializer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape it = (Shape)element$iv;
            boolean bl = false;
            Symbol nestedStructOrUnionSerializer = this.documentSerializer(ctx, it);
            KotlinWriter.addImport$default(writer, nestedStructOrUnionSerializer, null, 2, null);
        }
    }

    private final void renderSerializeOperationBody(ProtocolGenerator.GenerationContext ctx, OperationShape op, List<MemberShape> documentMembers, KotlinWriter writer) {
        Shape shape = ctx.getModel().expectShape((ShapeId)op.getInput().get());
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonSerializer()};
        writer.write("val serializer = #T()", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"shape");
        this.renderSerializerBody(ctx, shape, documentMembers, writer);
        writer.write("return serializer.toByteArray()", new Object[0]);
    }

    private final Symbol documentSerializer(ProtocolGenerator.GenerationContext ctx, Shape shape) {
        Symbol symbol = ctx.getSymbolProvider().toSymbol(shape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
        return SerdeExtKt.documentSerializer(symbol, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(symbol, this, ctx, shape){
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ JsonSerializerGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ Shape $shape;
            {
                this.$symbol = $symbol;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$shape = $shape;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                Object[] objectArray = this.$symbol;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"symbol");
                String fnName = SerdeExtKt.documentSerializerName((Symbol)objectArray);
                objectArray = new Object[]{fnName, RuntimeTypes.Serde.INSTANCE.getSerializer(), this.$symbol};
                writer.openBlock("internal fun #L(serializer: #T, input: #T) {", objectArray).call(() -> documentSerializer.1.invoke$lambda-0(this.this$0, this.$ctx, this.$shape, writer)).closeBlock("}", new Object[0]);
            }

            private static final void invoke$lambda-0(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, Shape $shape, KotlinWriter $writer) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)$shape, (String)"$shape");
                Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
                Collection collection = $shape.members();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"shape.members()");
                JsonSerializerGenerator.access$renderSerializerBody(this$0, $ctx, $shape, CollectionsKt.toList((Iterable)collection), $writer);
            }
        }));
    }

    private final void renderSerializerBody(ProtocolGenerator.GenerationContext ctx, Shape shape, List<MemberShape> members, KotlinWriter writer) {
        new JsonSerdeDescriptorGenerator(ProtocolGeneratorKt.toRenderingContext(ctx, this.protocolGenerator, shape, writer), members).render();
        if (shape.isUnionShape()) {
            new SerializeUnionGenerator(ctx, members, writer, this.getDefaultTimestampFormat()).render();
        } else {
            new SerializeStructGenerator(ctx, members, writer, this.getDefaultTimestampFormat()).render();
        }
    }

    @Override
    @NotNull
    public Symbol payloadSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull MemberShape member) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Shape target = ctx.getModel().expectShape(member.getTarget());
        Symbol symbol = ctx.getSymbolProvider().toSymbol((Shape)member);
        Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
        Symbol serializeFn = this.documentSerializer(ctx, target);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
        String fnName = SerdeExtKt.payloadSerializerName(symbol);
        return SerdeExtKt.payloadSerializer(symbol, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(this, ctx, target, fnName, symbol, serializeFn){
            final /* synthetic */ JsonSerializerGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ Shape $target;
            final /* synthetic */ String $fnName;
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ Symbol $serializeFn;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$target = $target;
                this.$fnName = $fnName;
                this.$symbol = $symbol;
                this.$serializeFn = $serializeFn;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                Object[] objectArray = this.$target;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"target");
                JsonSerializerGenerator.access$addNestedDocumentSerializers(this.this$0, this.$ctx, (Shape)objectArray, writer);
                CodeWriter codeWriter = writer;
                objectArray = new Object[2];
                objectArray[0] = this.$fnName;
                Symbol symbol = this.$symbol;
                Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
                objectArray[1] = symbol;
                CodeWriterExtKt.withBlock(codeWriter, "internal fun #L(input: #T): ByteArray {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this.$serializeFn){
                    final /* synthetic */ Symbol $serializeFn;
                    {
                        this.$serializeFn = $serializeFn;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonSerializer()};
                        $this$withBlock.write("val serializer = #T()", objectArray);
                        objectArray = new Object[]{this.$serializeFn};
                        $this$withBlock.write("#T(serializer, input)", objectArray);
                        $this$withBlock.write("return serializer.toByteArray()", new Object[0]);
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ void access$addNestedDocumentSerializers(JsonSerializerGenerator $this, ProtocolGenerator.GenerationContext ctx, Shape shape, KotlinWriter writer) {
        $this.addNestedDocumentSerializers(ctx, shape, writer);
    }

    public static final /* synthetic */ void access$renderSerializeOperationBody(JsonSerializerGenerator $this, ProtocolGenerator.GenerationContext ctx, OperationShape op, List documentMembers, KotlinWriter writer) {
        $this.renderSerializeOperationBody(ctx, op, documentMembers, writer);
    }

    public static final /* synthetic */ void access$renderSerializerBody(JsonSerializerGenerator $this, ProtocolGenerator.GenerationContext ctx, Shape shape, List members, KotlinWriter writer) {
        $this.renderSerializerBody(ctx, shape, members, writer);
    }
}

