/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.endpoints.discovery;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryTrait;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegatorKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.SdkEndpointBuiltinIntegration;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.discovery.EndpointDiscovererInterfaceGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/DefaultEndpointDiscovererGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "delegator", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;)V", "symbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "service", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "clientSymbol", "kotlin.jvm.PlatformType", "operationName", "", "render", "", "renderAsEndpointResolver", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderInvalidate", "Companion", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nDefaultEndpointDiscovererGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEndpointDiscovererGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/DefaultEndpointDiscovererGenerator\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,104:1\n43#2:105\n78#2:106\n43#2:107\n*S KotlinDebug\n*F\n+ 1 DefaultEndpointDiscovererGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/DefaultEndpointDiscovererGenerator\n*L\n21#1:105\n24#1:106\n25#1:107\n*E\n"})
public final class DefaultEndpointDiscovererGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodegenContext ctx;
    @NotNull
    private final KotlinDelegator delegator;
    @NotNull
    private final Symbol symbol;
    @NotNull
    private final ServiceShape service;
    private final Symbol clientSymbol;
    @NotNull
    private final String operationName;

    /*
     * WARNING - void declaration
     */
    public DefaultEndpointDiscovererGenerator(@NotNull CodegenContext ctx, @NotNull KotlinDelegator delegator) {
        void $this$expectShape$iv;
        void $this$operationName_u24lambda_u240;
        void $this$expectShape$iv2;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        this.ctx = ctx;
        this.delegator = delegator;
        this.symbol = Companion.symbolFor(this.ctx.getSettings());
        Model model = this.ctx.getModel();
        Object shapeId$iv = this.ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv2.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        this.service = (ServiceShape)shape;
        this.clientSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)this.service);
        shapeId$iv = this;
        DefaultEndpointDiscovererGenerator defaultEndpointDiscovererGenerator = this;
        boolean bl = false;
        Shape $this$expectTrait$iv = (Shape)$this$operationName_u24lambda_u240.service;
        boolean $i$f$expectTrait22 = false;
        Trait trait = $this$expectTrait$iv.expectTrait(ClientEndpointDiscoveryTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(...)");
        ClientEndpointDiscoveryTrait epDiscoveryTrait = (ClientEndpointDiscoveryTrait)trait;
        Model $i$f$expectTrait22 = $this$operationName_u24lambda_u240.ctx.getModel();
        ShapeId shapeId = epDiscoveryTrait.getOperation();
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"getOperation(...)");
        ShapeId shapeId$iv2 = shapeId;
        boolean $i$f$expectShape2 = false;
        Shape shape2 = $this$expectShape$iv.expectShape(shapeId$iv2, OperationShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"expectShape(...)");
        OperationShape operation = (OperationShape)shape2;
        defaultEndpointDiscovererGenerator.operationName = NamingKt.defaultName(operation);
    }

    public final void render() {
        KotlinDelegatorKt.applyFileWriter(this.delegator, this.symbol, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> DefaultEndpointDiscovererGenerator.render$lambda$2(this, arg_0)));
    }

    private final void renderAsEndpointResolver(KotlinWriter $this$renderAsEndpointResolver) {
        AbstractCodeWriter abstractCodeWriter = $this$renderAsEndpointResolver;
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.clientSymbol, (String)"clientSymbol");
        objectArray[1] = RuntimeTypes.HttpClient.Operation.INSTANCE.getEndpointResolver();
        AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "override fun asEndpointResolver(client: #1T, delegate: #2T): #2T = #2T { request ->", "}", objectArray, DefaultEndpointDiscovererGenerator::renderAsEndpointResolver$lambda$5);
    }

    private final void renderInvalidate(KotlinWriter $this$renderInvalidate) {
        Object[] objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getExecutionContext()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$renderInvalidate, "override public suspend fun invalidate(context: #T) {", "}", objectArray, DefaultEndpointDiscovererGenerator::renderInvalidate$lambda$6);
    }

    private static final Unit render$lambda$2$lambda$1(DefaultEndpointDiscovererGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.renderAsEndpointResolver($this$withBlock);
        $this$withBlock.write("", new Object[0]);
        this$0.renderInvalidate($this$withBlock);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$2(DefaultEndpointDiscovererGenerator this$0, KotlinWriter $this$applyFileWriter) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyFileWriter), (String)"$this$applyFileWriter");
        String service = NamingKt.clientName(this$0.ctx.getSettings().getSdkId());
        $this$applyFileWriter.dokka(StringsKt.trimIndent((String)("\n                    A class which looks up specific endpoints for " + service + " calls via the `" + this$0.operationName + "` API. These\n                    unique endpoints are cached as appropriate to avoid unnecessary latency in subsequent calls.\n                    @param cache An [ExpiringKeyedCache] implementation used to cache discovered hosts\n                ")));
        Object[] objectArray = new Object[]{this$0.ctx.getSettings().getApi().getVisibility(), this$0.symbol, RuntimeTypes.Core.Collections.INSTANCE.getExpiringKeyedCache(), RuntimeTypes.Core.Net.INSTANCE.getHost(), RuntimeTypes.Core.Collections.INSTANCE.getPeriodicSweepCache(), KotlinTypes.Time.INSTANCE.getMinutes(), EndpointDiscovererInterfaceGenerator.Companion.symbolFor(this$0.ctx.getSettings())};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$applyFileWriter, "#1L class #2T(#1L val cache: #3T<DiscoveryParams, #4T> = #5T(10.#6T)) : #7T {", "}", objectArray, arg_0 -> DefaultEndpointDiscovererGenerator.render$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderAsEndpointResolver$lambda$5$lambda$4$lambda$3(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("originalEndpoint.uri.copy { host = discoveredHost },", new Object[0]);
        $this$withBlock.write("originalEndpoint.headers,", new Object[0]);
        $this$withBlock.write("originalEndpoint.attributes,", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderAsEndpointResolver$lambda$5$lambda$4(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("val identity = request.identity", new Object[0]);
        Object[] objectArray = new Object[]{RuntimeTypes.Auth.Credentials.AwsCredentials.INSTANCE.getCredentials()};
        $this$withBlock.write("require(identity is #T) { \"Endpoint discovery requires AWS credentials\" }", objectArray);
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("val cacheKey = DiscoveryParams(client.config.region, identity.accessKeyId)", new Object[0]);
        $this$withBlock.write("request.context[DiscoveryParamsKey] = cacheKey", new Object[0]);
        $this$withBlock.write("val discoveredHost = cache.get(cacheKey) { discoverHost(client) }", new Object[0]);
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("val originalEndpoint = delegate.resolve(request)", new Object[0]);
        objectArray = new Object[]{RuntimeTypes.SmithyClient.Endpoints.INSTANCE.getEndpoint()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "#T(", ")", objectArray, DefaultEndpointDiscovererGenerator::renderAsEndpointResolver$lambda$5$lambda$4$lambda$3);
        AbstractCodeWriterExtKt.closeAndOpenBlock((AbstractCodeWriter)$this$withBlock, "} else {", new Object[0]);
        $this$withBlock.write("delegate.resolve(request)", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderAsEndpointResolver$lambda$5(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{SdkEndpointBuiltinIntegration.Companion.getEndpointUrlProp().getPropertyName()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "if (client.config.#L == null) {", "}", objectArray, DefaultEndpointDiscovererGenerator::renderAsEndpointResolver$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    private static final Unit renderInvalidate$lambda$6(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("context.getOrNull(DiscoveryParamsKey)?.let { cache.invalidate(it) }", new Object[0]);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/DefaultEndpointDiscovererGenerator$Companion;", "", "<init>", "()V", "symbolFor", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Symbol symbolFor(@NotNull KotlinSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)arg_0 -> Companion.symbolFor$lambda$0(settings, arg_0)));
        }

        private static final Unit symbolFor$lambda$0(KotlinSettings $settings, SymbolBuilder $this$buildSymbol) {
            Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
            String clientName = NamingKt.clientName($settings.getSdkId());
            $this$buildSymbol.setName("Default" + clientName + "EndpointDiscoverer");
            $this$buildSymbol.setNamespace($settings.getPkg().getName() + ".endpoints");
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

