/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.kotlin.codegen.core.KotlinSymbolProvider;
import software.amazon.smithy.kotlin.codegen.model.traits.OperationInput;
import software.amazon.smithy.kotlin.codegen.model.traits.OperationOutput;
import software.amazon.smithy.kotlin.codegen.model.traits.SyntheticClone;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AnnotationTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.UnitTypeTrait;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/model/OperationNormalizer;", "", "<init>", "()V", "REQUEST_SUFFIX", "", "RESPONSE_SUFFIX", "transform", "Lsoftware/amazon/smithy/model/Model;", "model", "service", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "validateTransform", "", "operations", "", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "syntheticShapeId", "opShapeId", "suffix", "emptyOperationIOStruct", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "cloneOperationIOShape", "structure", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nOperationNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperationNormalizer.kt\nsoftware/amazon/smithy/kotlin/codegen/model/OperationNormalizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,126:1\n1863#2,2:127\n1368#2:129\n1454#2,5:130\n774#2:135\n865#2,2:136\n1611#2,9:138\n1863#2:147\n1864#2:149\n1620#2:150\n1611#2,9:151\n1863#2:160\n1864#2:162\n1620#2:163\n827#2:164\n855#2,2:165\n1#3:148\n1#3:161\n43#4:167\n43#4:168\n73#4:169\n*S KotlinDebug\n*F\n+ 1 OperationNormalizer.kt\nsoftware/amazon/smithy/kotlin/codegen/model/OperationNormalizer\n*L\n47#1:127,2\n70#1:129\n70#1:130,5\n80#1:135\n80#1:136,2\n83#1:138,9\n83#1:147\n83#1:149\n83#1:150\n84#1:151,9\n84#1:160\n84#1:162\n84#1:163\n90#1:164\n90#1:165,2\n83#1:148\n84#1:161\n49#1:167\n53#1:168\n77#1:169\n*E\n"})
public final class OperationNormalizer {
    @NotNull
    public static final OperationNormalizer INSTANCE = new OperationNormalizer();
    @NotNull
    private static final String REQUEST_SUFFIX = "Request";
    @NotNull
    private static final String RESPONSE_SUFFIX = "Response";

    private OperationNormalizer() {
    }

    @NotNull
    public final Model transform(@NotNull Model model, @NotNull ShapeId service) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        Set operations = topDownIndex.getContainedOperations((ToShapeId)service);
        Intrinsics.checkNotNull((Object)operations);
        this.validateTransform(model, service, operations);
        Model.Builder builder = model.toBuilder();
        Iterable $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape operation = (OperationShape)element$iv;
            boolean bl = false;
            StructureShape structureShape = operation.getInput().map(arg_0 -> OperationNormalizer.transform$lambda$6$lambda$1(arg_0 -> OperationNormalizer.transform$lambda$6$lambda$0(operation, model, arg_0), arg_0)).orElseGet(() -> OperationNormalizer.transform$lambda$6$lambda$2(operation));
            Intrinsics.checkNotNullExpressionValue((Object)structureShape, (String)"orElseGet(...)");
            StructureShape newInputShape = structureShape;
            Shape[] shapeArray = operation.getOutput().map(arg_0 -> OperationNormalizer.transform$lambda$6$lambda$4(arg_0 -> OperationNormalizer.transform$lambda$6$lambda$3(operation, model, arg_0), arg_0)).orElseGet(() -> OperationNormalizer.transform$lambda$6$lambda$5(operation));
            Intrinsics.checkNotNullExpressionValue((Object)shapeArray, (String)"orElseGet(...)");
            Shape[] newOutputShape = shapeArray;
            shapeArray = new Shape[]{newInputShape, newOutputShape};
            builder.addShapes(shapeArray);
            builder.addShape((Shape)operation.toBuilder().input((ToShapeId)newInputShape).output((ToShapeId)newOutputShape).build());
        }
        Model model2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)model2, (String)"build(...)");
        return model2;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateTransform(Model model, ShapeId service, Set<OperationShape> operations) {
        void $this$filterNotTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = operations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            OperationShape it = (OperationShape)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{it.getId().getName() + REQUEST_SUFFIX, it.getId().getName() + RESPONSE_SUFFIX};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set newNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterator shapes = new Walker(model).iterateShapes(model.expectShape(service));
        Intrinsics.checkNotNull((Object)shapes);
        List shapesResultingInType = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)shapes), OperationNormalizer::validateTransform$lambda$8));
        Iterable $this$filter$iv = shapesResultingInType;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Shape it = (Shape)element$iv$iv;
            boolean bl = false;
            if (!newNames.contains(it.getId().getName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List possibleConflicts = (List)destination$iv$iv2;
        if (possibleConflicts.isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = operations;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Iterable<ShapeId> destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            ShapeId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            OperationShape it = (OperationShape)element$iv$iv;
            boolean bl3 = false;
            Optional optional = it.getInput();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getInput(...)");
            if ((ShapeId)OptionalExtKt.getOrNull(optional) == null) continue;
            boolean bl4 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Set operationInputIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Iterable $this$mapNotNull$iv2 = operations;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv3 = $this$mapNotNull$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            ShapeId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl5 = false;
            OperationShape it = (OperationShape)element$iv$iv;
            boolean bl6 = false;
            Optional optional = it.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getOutput(...)");
            if ((ShapeId)OptionalExtKt.getOrNull(optional) == null) continue;
            boolean bl7 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        Set operationOutputIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
        Set allIds = SetsKt.plus((Set)operationInputIds, (Iterable)operationOutputIds);
        Iterable $this$filterNot$iv = possibleConflicts;
        boolean $i$f$filterNot = false;
        Iterable $i$f$mapNotNullTo22 = $this$filterNot$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Shape it = (Shape)element$iv$iv;
            boolean bl8 = false;
            if (allIds.contains(it.getId())) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        List realConflicts = (List)destination$iv$iv5;
        if (!((Collection)realConflicts).isEmpty()) {
            String formatted = CollectionsKt.joinToString$default((Iterable)realConflicts, (CharSequence)"\n", (CharSequence)" * ", null, (int)0, null, OperationNormalizer::validateTransform$lambda$13, (int)28, null);
            throw new CodegenException(StringsKt.trimMargin$default((String)("renaming operation inputs or outputs will result in a conflict for:\n                |" + formatted + "\n                |Fix by supplying a manual rename customization for the shapes listed.\n                "), null, (int)1, null));
        }
    }

    private final ShapeId syntheticShapeId(ShapeId opShapeId, String suffix) {
        String string = opShapeId.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespace(...)");
        String[] stringArray = new String[]{"."};
        String lastNs = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        ShapeId shapeId = ShapeId.fromParts((String)("smithy.kotlin.synthetic." + lastNs), (String)(opShapeId.getName() + suffix));
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"fromParts(...)");
        return shapeId;
    }

    private final StructureShape emptyOperationIOStruct(ShapeId opShapeId, String suffix) {
        StructureShape structureShape = ((StructureShape.Builder)((StructureShape.Builder)((StructureShape.Builder)StructureShape.builder().id(this.syntheticShapeId(opShapeId, suffix))).addTrait((Trait)SyntheticClone.Companion.build((Function1<? super SyntheticClone.Builder, Unit>)((Function1)OperationNormalizer::emptyOperationIOStruct$lambda$14)))).addTrait((Trait)(Intrinsics.areEqual((Object)suffix, (Object)REQUEST_SUFFIX) ? (AnnotationTrait)new OperationInput() : (AnnotationTrait)new OperationOutput()))).build();
        Intrinsics.checkNotNullExpressionValue((Object)structureShape, (String)"build(...)");
        return structureShape;
    }

    private final StructureShape cloneOperationIOShape(ShapeId opShapeId, StructureShape structure, String suffix) {
        StructureShape structureShape = ((StructureShape.Builder)((StructureShape.Builder)((StructureShape.Builder)structure.toBuilder().id(this.syntheticShapeId(opShapeId, suffix))).addTrait((Trait)SyntheticClone.Companion.build((Function1<? super SyntheticClone.Builder, Unit>)((Function1)arg_0 -> OperationNormalizer.cloneOperationIOShape$lambda$15(structure, arg_0))))).addTrait((Trait)(Intrinsics.areEqual((Object)suffix, (Object)REQUEST_SUFFIX) ? (AnnotationTrait)new OperationInput() : (AnnotationTrait)new OperationOutput()))).build();
        Intrinsics.checkNotNullExpressionValue((Object)structureShape, (String)"build(...)");
        return structureShape;
    }

    /*
     * WARNING - void declaration
     */
    private static final StructureShape transform$lambda$6$lambda$0(OperationShape $operation, Model $model, ShapeId it) {
        void $this$expectShape$iv;
        ShapeId shapeId = $operation.getId();
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"getId(...)");
        Model model = $model;
        Intrinsics.checkNotNull((Object)it);
        ShapeId shapeId$iv = it;
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, StructureShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        return INSTANCE.cloneOperationIOShape(shapeId, (StructureShape)shape, REQUEST_SUFFIX);
    }

    private static final StructureShape transform$lambda$6$lambda$1(Function1 $tmp0, Object p0) {
        return (StructureShape)$tmp0.invoke(p0);
    }

    private static final StructureShape transform$lambda$6$lambda$2(OperationShape $operation) {
        ShapeId shapeId = $operation.getId();
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"getId(...)");
        return INSTANCE.emptyOperationIOStruct(shapeId, REQUEST_SUFFIX);
    }

    /*
     * WARNING - void declaration
     */
    private static final StructureShape transform$lambda$6$lambda$3(OperationShape $operation, Model $model, ShapeId it) {
        void $this$expectShape$iv;
        ShapeId shapeId = $operation.getId();
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"getId(...)");
        Model model = $model;
        Intrinsics.checkNotNull((Object)it);
        ShapeId shapeId$iv = it;
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, StructureShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        return INSTANCE.cloneOperationIOShape(shapeId, (StructureShape)shape, RESPONSE_SUFFIX);
    }

    private static final StructureShape transform$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        return (StructureShape)$tmp0.invoke(p0);
    }

    private static final StructureShape transform$lambda$6$lambda$5(OperationShape $operation) {
        ShapeId shapeId = $operation.getId();
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"getId(...)");
        return INSTANCE.emptyOperationIOStruct(shapeId, RESPONSE_SUFFIX);
    }

    private static final boolean validateTransform$lambda$8(Shape it) {
        Intrinsics.checkNotNull((Object)it);
        Shape $this$hasTrait$iv = it;
        boolean $i$f$hasTrait = false;
        return !$this$hasTrait$iv.hasTrait(Trait.class) && KotlinSymbolProvider.Companion.isTypeGeneratedForShape(it);
    }

    private static final CharSequence validateTransform$lambda$13(Shape it) {
        String string = it.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit emptyOperationIOStruct$lambda$14(SyntheticClone.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$build), (String)"$this$build");
        $this$build.setArchetype(UnitTypeTrait.UNIT);
        return Unit.INSTANCE;
    }

    private static final Unit cloneOperationIOShape$lambda$15(StructureShape $structure, SyntheticClone.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$build), (String)"$this$build");
        $this$build.setArchetype($structure.getId());
        return Unit.INSTANCE;
    }
}

