/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.core.RenderingContext;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SdkFieldDescriptorTrait;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeDescriptorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006H\u0014J(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00062\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020 H\u0014J\"\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010\u001f\u001a\u00020 H\u0014J\"\u0010\"\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020$H\u0002R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR*\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007 \u0010*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000f0\u000fX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/AbstractSerdeDescriptorGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SerdeDescriptorGenerator;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "Lsoftware/amazon/smithy/model/shapes/Shape;", "memberShapes", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;Ljava/util/List;)V", "getCtx", "()Lsoftware/amazon/smithy/kotlin/codegen/core/RenderingContext;", "objectShape", "getObjectShape", "()Lsoftware/amazon/smithy/model/shapes/Shape;", "", "kotlin.jvm.PlatformType", "getMemberShapes", "()Ljava/util/Collection;", "Ljava/util/Collection;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "getWriter", "()Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "render", "", "getObjectDescriptorTraits", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SdkFieldDescriptorTrait;", "getFieldDescriptorTraits", "member", "targetShape", "nameSuffix", "", "renderFieldDescriptor", "renderContainerFieldDescriptors", "level", "", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nAbstractSerdeDescriptorGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSerdeDescriptorGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/AbstractSerdeDescriptorGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1#2:182\n1053#3:183\n1863#3,2:184\n1863#3,2:186\n*S KotlinDebug\n*F\n+ 1 AbstractSerdeDescriptorGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/AbstractSerdeDescriptorGenerator\n*L\n72#1:183\n132#1:184,2\n84#1:186,2\n*E\n"})
public abstract class AbstractSerdeDescriptorGenerator
implements SerdeDescriptorGenerator {
    @NotNull
    private final RenderingContext<Shape> ctx;
    @NotNull
    private final Shape objectShape;
    private final Collection<MemberShape> memberShapes;
    @NotNull
    private final KotlinWriter writer;

    public AbstractSerdeDescriptorGenerator(@NotNull RenderingContext<Shape> ctx, @Nullable List<MemberShape> memberShapes) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.ctx = ctx;
        Shape shape = this.ctx.getShape();
        if (shape == null) {
            AbstractSerdeDescriptorGenerator abstractSerdeDescriptorGenerator = this;
            boolean bl = false;
            AbstractSerdeDescriptorGenerator abstractSerdeDescriptorGenerator2 = abstractSerdeDescriptorGenerator;
            String string = "rendering context requires shape to not be null";
            throw new IllegalArgumentException(string.toString());
        }
        this.objectShape = shape;
        List<MemberShape> list = memberShapes;
        this.memberShapes = list != null ? (Collection)list : this.objectShape.members();
        this.writer = this.ctx.getWriter();
    }

    public /* synthetic */ AbstractSerdeDescriptorGenerator(RenderingContext renderingContext, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = null;
        }
        this(renderingContext, list);
    }

    @NotNull
    protected final RenderingContext<Shape> getCtx() {
        return this.ctx;
    }

    @NotNull
    protected final Shape getObjectShape() {
        return this.objectShape;
    }

    protected final Collection<MemberShape> getMemberShapes() {
        return this.memberShapes;
    }

    @NotNull
    protected final KotlinWriter getWriter() {
        return this.writer;
    }

    @Override
    public void render() {
        if (this.memberShapes.isEmpty()) {
            return;
        }
        Object[] objectArray = new Symbol[]{RuntimeTypes.Serde.INSTANCE.getSdkFieldDescriptor(), RuntimeTypes.Serde.INSTANCE.getSdkObjectDescriptor(), RuntimeTypes.Serde.INSTANCE.getSerialKind(), RuntimeTypes.Serde.INSTANCE.getDeserializeStruct(), RuntimeTypes.Serde.INSTANCE.getDeserializeList(), RuntimeTypes.Serde.INSTANCE.getDeserializeMap(), RuntimeTypes.Serde.INSTANCE.getField(), RuntimeTypes.Serde.INSTANCE.getAsSdkSerializable(), RuntimeTypes.Serde.INSTANCE.getSerializeStruct(), RuntimeTypes.Serde.INSTANCE.getSerializeList(), RuntimeTypes.Serde.INSTANCE.getSerializeMap()};
        Set serdeDescriptorSymbols = SetsKt.setOf((Object[])objectArray);
        KotlinWriterKt.addImport(this.writer, (Iterable<Symbol>)serdeDescriptorSymbols);
        Collection<MemberShape> collection = this.memberShapes;
        Intrinsics.checkNotNullExpressionValue(collection, (String)"memberShapes");
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        List sortedMembers = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        for (MemberShape member : sortedMembers) {
            Shape nestedMember;
            Shape memberTarget = this.ctx.getModel().expectShape(member.getTarget());
            Intrinsics.checkNotNull((Object)memberTarget);
            AbstractSerdeDescriptorGenerator.renderFieldDescriptor$default(this, member, memberTarget, null, 4, null);
            Shape shape = nestedMember = SerdeExtKt.childShape(memberTarget, this.ctx.getModel());
            boolean bl = shape != null ? SerdeExtKt.isContainerShape(shape) : false;
            if (!bl) continue;
            AbstractSerdeDescriptorGenerator.renderContainerFieldDescriptors$default(this, member, nestedMember, 0, 4, null);
        }
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {", "}", new Object[0], arg_0 -> AbstractSerdeDescriptorGenerator.render$lambda$3(this, sortedMembers, arg_0));
        this.writer.write("", new Object[0]);
    }

    @NotNull
    protected List<SdkFieldDescriptorTrait> getObjectDescriptorTraits() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<SdkFieldDescriptorTrait> getFieldDescriptorTraits(@NotNull MemberShape member, @NotNull Shape targetShape, @NotNull String nameSuffix) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        Intrinsics.checkNotNullParameter((Object)nameSuffix, (String)"nameSuffix");
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List getFieldDescriptorTraits$default(AbstractSerdeDescriptorGenerator abstractSerdeDescriptorGenerator, MemberShape memberShape, Shape shape, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFieldDescriptorTraits");
        }
        if ((n & 4) != 0) {
            string = "";
        }
        return abstractSerdeDescriptorGenerator.getFieldDescriptorTraits(memberShape, shape, string);
    }

    protected void renderFieldDescriptor(@NotNull MemberShape member, @NotNull Shape targetShape, @NotNull String nameSuffix) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        Intrinsics.checkNotNullParameter((Object)nameSuffix, (String)"nameSuffix");
        String descriptorName = SerdeExtKt.descriptorName(member, nameSuffix);
        String serialKind = SerdeExtKt.serialKind(targetShape);
        List<SdkFieldDescriptorTrait> traits = this.getFieldDescriptorTraits(member, targetShape, nameSuffix);
        if (traits.isEmpty()) {
            Object[] objectArray = new Object[]{descriptorName, serialKind};
            kotlinWriter = (KotlinWriter)this.writer.write("val #L = SdkFieldDescriptor(#L)", objectArray);
        } else {
            Iterable $this$forEach$iv = traits;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SdkFieldDescriptorTrait trait = (SdkFieldDescriptorTrait)element$iv;
                boolean bl = false;
                KotlinWriter.addImport$default(this.writer, trait.getSymbol(), null, 2, null);
            }
            Object[] objectArray = new Object[]{descriptorName, serialKind, CollectionsKt.joinToString$default((Iterable)traits, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
            kotlinWriter = (KotlinWriter)this.writer.write("val #L = SdkFieldDescriptor(#L, #L)", objectArray);
        }
    }

    public static /* synthetic */ void renderFieldDescriptor$default(AbstractSerdeDescriptorGenerator abstractSerdeDescriptorGenerator, MemberShape memberShape, Shape shape, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderFieldDescriptor");
        }
        if ((n & 4) != 0) {
            string = "";
        }
        abstractSerdeDescriptorGenerator.renderFieldDescriptor(memberShape, shape, string);
    }

    private final void renderContainerFieldDescriptors(MemberShape member, Shape targetShape, int level) {
        Shape nestedTarget;
        this.renderFieldDescriptor(member, targetShape, "_C" + level);
        Shape shape = nestedTarget = SerdeExtKt.childShape(targetShape, this.ctx.getModel());
        boolean bl = shape != null ? SerdeExtKt.isContainerShape(shape) : false;
        if (bl) {
            this.renderContainerFieldDescriptors(member, nestedTarget, level + 1);
        }
    }

    static /* synthetic */ void renderContainerFieldDescriptors$default(AbstractSerdeDescriptorGenerator abstractSerdeDescriptorGenerator, MemberShape memberShape, Shape shape, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderContainerFieldDescriptors");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        abstractSerdeDescriptorGenerator.renderContainerFieldDescriptors(memberShape, shape, n);
    }

    private static final Unit render$lambda$3(AbstractSerdeDescriptorGenerator this$0, List $sortedMembers, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        List<SdkFieldDescriptorTrait> objTraits = this$0.getObjectDescriptorTraits();
        Iterable $this$forEach$iv = objTraits;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkFieldDescriptorTrait trait = (SdkFieldDescriptorTrait)element$iv;
            boolean bl = false;
            KotlinWriter.addImport$default(this$0.writer, trait.getSymbol(), null, 2, null);
            this$0.writer.write("trait(" + trait + ')', new Object[0]);
        }
        for (MemberShape member : $sortedMembers) {
            Object[] objectArray = new Object[]{SerdeExtKt.descriptorName$default(member, null, 1, null)};
            $this$withBlock.write("field(#L)", objectArray);
        }
        return Unit.INSTANCE;
    }
}

