/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolContentTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpTraitResolver;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "contentTypes", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolContentTypes;", "<init>", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/model/shapes/ServiceShape;Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolContentTypes;)V", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "defaultContentType", "", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/lang/String;)V", "bindingIndex", "Lsoftware/amazon/smithy/model/knowledge/HttpBindingIndex;", "topDownIndex", "Lsoftware/amazon/smithy/model/knowledge/TopDownIndex;", "bindingOperations", "", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "httpTrait", "Lsoftware/amazon/smithy/model/traits/HttpTrait;", "operationShape", "requestBindings", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingDescriptor;", "responseBindings", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "determineRequestContentType", "determineTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "member", "Lsoftware/amazon/smithy/model/shapes/ToShapeId;", "location", "Lsoftware/amazon/smithy/model/knowledge/HttpBinding$Location;", "defaultFormat", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nHttpBindingResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpBindingResolver.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpTraitResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,167:1\n774#2:168\n865#2:169\n866#2:171\n1557#2:173\n1628#2,3:174\n1557#2:177\n1628#2,3:178\n72#3:170\n77#3:172\n*S KotlinDebug\n*F\n+ 1 HttpBindingResolver.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpTraitResolver\n*L\n139#1:168\n139#1:169\n139#1:171\n147#1:173\n147#1:174,3\n152#1:177\n152#1:178,3\n139#1:170\n142#1:172\n*E\n"})
public final class HttpTraitResolver
implements HttpBindingResolver {
    @NotNull
    private final Model model;
    @NotNull
    private final ServiceShape serviceShape;
    @NotNull
    private final ProtocolContentTypes contentTypes;
    @NotNull
    private final HttpBindingIndex bindingIndex;
    @NotNull
    private final TopDownIndex topDownIndex;

    public HttpTraitResolver(@NotNull Model model, @NotNull ServiceShape serviceShape, @NotNull ProtocolContentTypes contentTypes) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
        Intrinsics.checkNotNullParameter((Object)contentTypes, (String)"contentTypes");
        this.model = model;
        this.serviceShape = serviceShape;
        this.contentTypes = contentTypes;
        HttpBindingIndex httpBindingIndex = HttpBindingIndex.of((Model)this.model);
        Intrinsics.checkNotNullExpressionValue((Object)httpBindingIndex, (String)"of(...)");
        this.bindingIndex = httpBindingIndex;
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        Intrinsics.checkNotNullExpressionValue((Object)topDownIndex, (String)"of(...)");
        this.topDownIndex = topDownIndex;
    }

    public HttpTraitResolver(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull String defaultContentType) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)defaultContentType, (String)"defaultContentType");
        this(ctx.getModel(), ctx.getService(), ProtocolContentTypes.Companion.consistent(defaultContentType));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<OperationShape> bindingOperations() {
        void $this$filterTo$iv$iv;
        Set set = this.topDownIndex.getContainedOperations((ToShapeId)this.serviceShape);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getContainedOperations(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OperationShape op = (OperationShape)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)op);
            Shape $this$hasTrait$iv = (Shape)op;
            boolean $i$f$hasTrait = false;
            if (!$this$hasTrait$iv.hasTrait(HttpTrait.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public HttpTrait httpTrait(@NotNull OperationShape operationShape) {
        Intrinsics.checkNotNullParameter((Object)operationShape, (String)"operationShape");
        Shape $this$expectTrait$iv = (Shape)operationShape;
        boolean $i$f$expectTrait = false;
        Trait trait = $this$expectTrait$iv.expectTrait(HttpTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(...)");
        return (HttpTrait)trait;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpBindingDescriptor> requestBindings(@NotNull OperationShape operationShape) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)operationShape, (String)"operationShape");
        Iterable $this$map$iv = this.bindingIndex.getRequestBindings((ToShapeId)operationShape).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HttpBinding httpBinding = (HttpBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new HttpBindingDescriptor((HttpBinding)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpBindingDescriptor> responseBindings(@NotNull Shape shape) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape shape2 = shape;
        if (shape2 instanceof OperationShape || shape2 instanceof StructureShape) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.bindingIndex.getResponseBindings((ToShapeId)shape.toShapeId()).values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HttpBinding httpBinding = (HttpBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new HttpBindingDescriptor((HttpBinding)it));
            }
        } else {
            throw new IllegalStateException(((Function0)() -> HttpTraitResolver.responseBindings$lambda$3(shape)).toString());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String determineRequestContentType(@NotNull OperationShape operationShape) {
        Intrinsics.checkNotNullParameter((Object)operationShape, (String)"operationShape");
        Optional optional = this.bindingIndex.determineRequestContentType((ToShapeId)operationShape, this.contentTypes.getRequestContentType(), this.contentTypes.getEventStreamContentType());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"determineRequestContentType(...)");
        return (String)OptionalExtKt.getOrNull(optional);
    }

    @Override
    @NotNull
    public TimestampFormatTrait.Format determineTimestampFormat(@NotNull ToShapeId member, @NotNull HttpBinding.Location location, @NotNull TimestampFormatTrait.Format defaultFormat) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)defaultFormat, (String)"defaultFormat");
        TimestampFormatTrait.Format format = this.bindingIndex.determineTimestampFormat(member, location, defaultFormat);
        Intrinsics.checkNotNullExpressionValue((Object)format, (String)"determineTimestampFormat(...)");
        return format;
    }

    private static final String responseBindings$lambda$3(Shape $shape) {
        return "Unimplemented resolving bindings for " + $shape.getClass().getCanonicalName();
    }
}

