/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.ExpressionRenderer;
import software.amazon.smithy.kotlin.codegen.rendering.util.ConfigProperty;
import software.amazon.smithy.kotlin.codegen.rendering.util.ConfigPropertyType;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Expression;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a,\u0010\r\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"renderAuthSchemes", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "authSchemes", "Lsoftware/amazon/smithy/rulesengine/language/syntax/expressions/Expression;", "expressionRenderer", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/ExpressionRenderer;", "renderFieldsForScheme", "scheme", "Lsoftware/amazon/smithy/model/node/ObjectNode;", "renderSigV4Fields", "renderSigV4AFields", "renderOrElse", "optionalNode", "Ljava/util/Optional;", "Lsoftware/amazon/smithy/model/node/Node;", "whenNullValue", "", "credentialsProviderProp", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/util/ConfigProperty;", "getCredentialsProviderProp", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/util/ConfigProperty;", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nSigV4AuthSchemeIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SigV4AuthSchemeIntegration.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/auth/SigV4AuthSchemeIntegrationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n774#2:268\n865#2,2:269\n1863#2,2:272\n1#3:271\n*S KotlinDebug\n*F\n+ 1 SigV4AuthSchemeIntegration.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/auth/SigV4AuthSchemeIntegrationKt\n*L\n189#1:268\n189#1:269,2\n197#1:272,2\n*E\n"})
public final class SigV4AuthSchemeIntegrationKt {
    @NotNull
    private static final ConfigProperty credentialsProviderProp = ConfigProperty.Companion.invoke((Function1<? super ConfigProperty.Builder, Unit>)((Function1)SigV4AuthSchemeIntegrationKt::credentialsProviderProp$lambda$6));

    /*
     * WARNING - void declaration
     */
    private static final void renderAuthSchemes(KotlinWriter writer, Expression authSchemes, ExpressionRenderer expressionRenderer) {
        block1: {
            List schemes;
            List list;
            void $this$filterTo$iv$iv;
            ArrayNode arrayNode = authSchemes.toNode().expectArrayNode();
            Intrinsics.checkNotNullExpressionValue((Object)arrayNode, (String)"expectArrayNode(...)");
            Iterable $this$filter$iv = (Iterable)arrayNode;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Node it = (Node)element$iv$iv;
                boolean bl = false;
                String name = it.expectObjectNode().expectStringMember("name").getValue();
                if (!(Intrinsics.areEqual((Object)name, (Object)"sigv4") || Intrinsics.areEqual((Object)name, (Object)"sigv4a"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List it = list = (List)destination$iv$iv;
            boolean bl = false;
            List list2 = schemes = !((Collection)it).isEmpty() ? list : null;
            if (list2 == null) break block1;
            it = list2;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{RuntimeTypes.SmithyClient.Endpoints.INSTANCE.getSigningContextAttributeKey()};
            writer.writeInline("#T to ", objectArray);
            KotlinWriter cfr_ignored_0 = (KotlinWriter)AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "listOf(", ")", new Object[0], arg_0 -> SigV4AuthSchemeIntegrationKt.renderAuthSchemes$lambda$5$lambda$4(schemes, expressionRenderer, writer, arg_0));
        }
    }

    private static final void renderFieldsForScheme(KotlinWriter writer, ObjectNode scheme, ExpressionRenderer expressionRenderer) {
        String string = scheme.expectStringMember("name").getValue();
        if (Intrinsics.areEqual((Object)string, (Object)"sigv4")) {
            SigV4AuthSchemeIntegrationKt.renderSigV4Fields(writer, scheme, expressionRenderer);
        } else if (Intrinsics.areEqual((Object)string, (Object)"sigv4a")) {
            SigV4AuthSchemeIntegrationKt.renderSigV4AFields(writer, scheme, expressionRenderer);
        }
    }

    private static final void renderSigV4Fields(KotlinWriter writer, ObjectNode scheme, ExpressionRenderer expressionRenderer) {
        writer.writeInline("signingRegion = ", new Object[0]);
        Optional optional = scheme.getStringMember("signingRegion");
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getStringMember(...)");
        SigV4AuthSchemeIntegrationKt.renderOrElse(writer, expressionRenderer, optional, "null");
    }

    private static final void renderSigV4AFields(KotlinWriter writer, ObjectNode scheme, ExpressionRenderer expressionRenderer) {
        writer.writeInline("signingRegionSet = ", new Object[0]);
        Expression expression = Expression.fromNode((Node)((Node)scheme.expectArrayMember("signingRegionSet")));
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"fromNode(...)");
        expressionRenderer.renderExpression(expression);
        writer.write(",", new Object[0]);
    }

    private static final void renderOrElse(KotlinWriter $this$renderOrElse, ExpressionRenderer expressionRenderer, Optional<? extends Node> optionalNode, String whenNullValue) {
        Object object;
        Node nullableNode = OptionalExtKt.getOrNull(optionalNode);
        if (nullableNode == null) {
            object = $this$renderOrElse.writeInline(whenNullValue, new Object[0]);
        } else {
            Expression expression = Expression.fromNode((Node)nullableNode);
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"fromNode(...)");
            object = expressionRenderer.renderExpression(expression);
        }
        $this$renderOrElse.write(",", new Object[0]);
    }

    @NotNull
    public static final ConfigProperty getCredentialsProviderProp() {
        return credentialsProviderProp;
    }

    private static final Unit renderAuthSchemes$lambda$5$lambda$4$lambda$3$lambda$2(ExpressionRenderer $expressionRenderer, ObjectNode $scheme, KotlinWriter $writer, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.writeInline("serviceName = ", new Object[0]);
        Optional optional = $scheme.getStringMember("signingName");
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getStringMember(...)");
        SigV4AuthSchemeIntegrationKt.renderOrElse($this$withBlock, $expressionRenderer, optional, "null");
        $this$withBlock.writeInline("disableDoubleUriEncode = ", new Object[0]);
        Optional optional2 = $scheme.getBooleanMember("disableDoubleEncoding");
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getBooleanMember(...)");
        SigV4AuthSchemeIntegrationKt.renderOrElse($this$withBlock, $expressionRenderer, optional2, "false");
        Intrinsics.checkNotNull((Object)$scheme);
        SigV4AuthSchemeIntegrationKt.renderFieldsForScheme($writer, $scheme, $expressionRenderer);
        return Unit.INSTANCE;
    }

    private static final Unit renderAuthSchemes$lambda$5$lambda$4(List $schemes, ExpressionRenderer $expressionRenderer, KotlinWriter $writer, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$forEach$iv = $schemes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Symbol symbol;
            Node it = (Node)element$iv;
            boolean bl = false;
            ObjectNode scheme = it.expectObjectNode();
            Object[] schemeName = scheme.expectStringMember("name").getValue();
            Object[] objectArray = schemeName;
            if (Intrinsics.areEqual((Object)objectArray, (Object)"sigv4")) {
                symbol = RuntimeTypes.Auth.HttpAuthAws.INSTANCE.getSigV4();
            } else {
                if (!Intrinsics.areEqual((Object)objectArray, (Object)"sigv4a")) continue;
                symbol = RuntimeTypes.Auth.HttpAuthAws.INSTANCE.getSigV4A();
            }
            Symbol authFactoryFn = symbol;
            objectArray = new Object[]{authFactoryFn};
            AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "#T(", "),", objectArray, arg_0 -> SigV4AuthSchemeIntegrationKt.renderAuthSchemes$lambda$5$lambda$4$lambda$3$lambda$2($expressionRenderer, scheme, $writer, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit credentialsProviderProp$lambda$6(ConfigProperty.Builder $this$ConfigProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$ConfigProperty, (String)"$this$ConfigProperty");
        $this$ConfigProperty.setSymbol(RuntimeTypes.Auth.Credentials.AwsCredentials.INSTANCE.getCredentialsProvider());
        $this$ConfigProperty.setBaseClass(RuntimeTypes.Auth.Credentials.AwsCredentials.INSTANCE.getCredentialsProviderConfig());
        $this$ConfigProperty.useNestedBuilderBaseClass();
        $this$ConfigProperty.setDocumentation("The AWS credentials provider to use for authenticating requests. \nNOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK\nclient will not close it when the client is closed.");
        $this$ConfigProperty.setPropertyType(new ConfigPropertyType.Required(null, 1, null));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$renderAuthSchemes(KotlinWriter writer, Expression authSchemes, ExpressionRenderer expressionRenderer) {
        SigV4AuthSchemeIntegrationKt.renderAuthSchemes(writer, authSchemes, expressionRenderer);
    }
}

