/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependencyKt;
import software.amazon.smithy.kotlin.codegen.rendering.GradleWriter;
import software.amazon.smithy.kotlin.codegen.rendering.Scope;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0087\u0001\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u001f\u0010\u0010\u001a\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u00132\u001f\u0010\u0015\u001a\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u00132\u001f\u0010\u0016\u001a\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u0013\u001a\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u0087\u0001\u0010\u0018\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u001f\u0010\u0010\u001a\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u00132\u001f\u0010\u0015\u001a\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u00132\u001f\u0010\u0016\u001a\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u0013\u001a.\u0010\u0019\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"'\u0010\u0015\u001a\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\u0002`\u0014\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"JVM_TARGET_VERSION", "", "writeGradleBuild", "", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "manifest", "Lsoftware/amazon/smithy/build/FileManifest;", "dependencies", "", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDependency;", "renderKmpGradleBuild", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/GradleWriter;", "isRootModule", "", "pluginsRenderer", "Lkotlin/Function1;", "Lsoftware/amazon/smithy/utils/AbstractCodeWriter;", "Lkotlin/ExtensionFunctionType;", "Lsoftware/amazon/smithy/kotlin/codegen/core/InlineCodeWriter;", "repositoryRenderer", "annotationRenderer", "renderRootJvmPluginConfig", "renderJvmGradleBuild", "renderDependencies", "scope", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/Scope;", "isKmp", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nGradleGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/GradleGeneratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n774#2:255\n865#2,2:256\n1863#2,2:258\n*S KotlinDebug\n*F\n+ 1 GradleGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/GradleGeneratorKt\n*L\n217#1:255\n217#1:256,2\n224#1:258,2\n*E\n"})
public final class GradleGeneratorKt {
    @NotNull
    private static final String JVM_TARGET_VERSION;
    @NotNull
    private static final Function1<AbstractCodeWriter<?>, Unit> repositoryRenderer;

    public static final void writeGradleBuild(@NotNull KotlinSettings settings, @NotNull FileManifest manifest, @NotNull List<KotlinDependency> dependencies) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        GradleWriter writer = new GradleWriter(null, 1, null);
        boolean isKmp = settings.getBuild().getGenerateMultiplatformProject();
        boolean isRootModule = settings.getBuild().getGenerateFullProject();
        Function1 annotationRenderer = arg_0 -> GradleGeneratorKt.writeGradleBuild$lambda$1(settings, arg_0);
        Function1 pluginsBodyRenderer = arg_0 -> GradleGeneratorKt.writeGradleBuild$lambda$3(isKmp, isRootModule, arg_0);
        if (isKmp) {
            GradleGeneratorKt.renderKmpGradleBuild(writer, isRootModule, dependencies, pluginsBodyRenderer, repositoryRenderer, annotationRenderer);
        } else {
            GradleGeneratorKt.renderJvmGradleBuild(writer, isRootModule, dependencies, pluginsBodyRenderer, repositoryRenderer, annotationRenderer);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String contents = string;
        manifest.writeFile("build.gradle.kts", contents);
        if (settings.getBuild().getGenerateFullProject()) {
            manifest.writeFile("settings.gradle.kts", "");
        }
    }

    public static final void renderKmpGradleBuild(@NotNull GradleWriter writer, boolean isRootModule, @NotNull List<KotlinDependency> dependencies, @NotNull Function1<? super AbstractCodeWriter<?>, Unit> pluginsRenderer, @NotNull Function1<? super AbstractCodeWriter<?>, Unit> repositoryRenderer, @NotNull Function1<? super AbstractCodeWriter<?>, Unit> annotationRenderer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(pluginsRenderer, (String)"pluginsRenderer");
        Intrinsics.checkNotNullParameter(repositoryRenderer, (String)"repositoryRenderer");
        Intrinsics.checkNotNullParameter(annotationRenderer, (String)"annotationRenderer");
        Object[] objectArray = new Object[]{pluginsRenderer, arg_0 -> GradleGeneratorKt.renderKmpGradleBuild$lambda$4(isRootModule, arg_0), arg_0 -> GradleGeneratorKt.renderKmpGradleBuild$lambda$5(isRootModule, repositoryRenderer, arg_0), arg_0 -> GradleGeneratorKt.renderKmpGradleBuild$lambda$6(isRootModule, arg_0), arg_0 -> GradleGeneratorKt.renderKmpGradleBuild$lambda$7(dependencies, arg_0), arg_0 -> GradleGeneratorKt.renderKmpGradleBuild$lambda$8(dependencies, arg_0), annotationRenderer};
        writer.write("plugins {\n    #W\n}  \n#W\n\nkotlin {\n    #W\n    #W\n    sourceSets {\n        val commonMain by getting {\n            dependencies {\n                #W\n            }\n        }\n        val commonTest by getting {\n            dependencies {\n                #W\n            }\n        }\n    }\n    val optInAnnotations = listOf(\n        #W\n    )\n    kotlin.sourceSets.all {\n        optInAnnotations.forEach { languageSettings.optIn(it) }\n    }\n}", objectArray);
    }

    public static final void renderRootJvmPluginConfig(@NotNull GradleWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Object[] objectArray = new Object[]{JVM_TARGET_VERSION};
        writer.write("jvm {\n    compilations.all {\n        kotlinOptions.jvmTarget = #S\n    }\n    testRuns[\"test\"].executionTask.configure {\n        useJUnitPlatform()\n        testLogging {\n            events(\"passed\", \"skipped\", \"failed\")\n            showStandardStreams = true\n            showStackTraces = true\n            showExceptions = true\n            exceptionFormat = org.gradle.api.tasks.testing.logging.TestExceptionFormat.FULL\n        }\n    }\n}", objectArray);
    }

    public static final void renderJvmGradleBuild(@NotNull GradleWriter writer, boolean isRootModule, @NotNull List<KotlinDependency> dependencies, @NotNull Function1<? super AbstractCodeWriter<?>, Unit> pluginsRenderer, @NotNull Function1<? super AbstractCodeWriter<?>, Unit> repositoryRenderer, @NotNull Function1<? super AbstractCodeWriter<?>, Unit> annotationRenderer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(pluginsRenderer, (String)"pluginsRenderer");
        Intrinsics.checkNotNullParameter(repositoryRenderer, (String)"repositoryRenderer");
        Intrinsics.checkNotNullParameter(annotationRenderer, (String)"annotationRenderer");
        Object[] objectArray = new Object[]{pluginsRenderer, arg_0 -> GradleGeneratorKt.renderJvmGradleBuild$lambda$9(isRootModule, repositoryRenderer, arg_0), arg_0 -> GradleGeneratorKt.renderJvmGradleBuild$lambda$10(dependencies, arg_0), annotationRenderer, arg_0 -> GradleGeneratorKt.renderJvmGradleBuild$lambda$11(isRootModule, arg_0)};
        writer.write("plugins {\n    #W\n}\n#W\n\ndependencies {\n    #W\n}\nval optInAnnotations = listOf(\n    #W\n)\nkotlin {\n    #W\n    sourceSets.all {\n        optInAnnotations.forEach { languageSettings.optIn(it) }\n    }\n}\n\ntasks.test {\n    useJUnitPlatform()\n    testLogging {\n        events(\"passed\", \"skipped\", \"failed\")\n        showStandardStreams = true\n        showStackTraces = true\n        showExceptions = true\n        exceptionFormat = org.gradle.api.tasks.testing.logging.TestExceptionFormat.FULL\n    }\n}", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final void renderDependencies(GradleWriter writer, Scope scope, boolean isKmp, List<KotlinDependency> dependencies) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (!isKmp) {
            writer.write("implementation(kotlin(\"stdlib\"))", new Object[0]);
        }
        Object object = new Function1[]{GradleGeneratorKt::renderDependencies$lambda$12, GradleGeneratorKt::renderDependencies$lambda$13};
        List orderedDependencies = CollectionsKt.sortedWith((Iterable)dependencies, (Comparator)ComparisonsKt.compareBy((Function1[])object));
        object = orderedDependencies;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinDependency it = (KotlinDependency)element$iv$iv;
            boolean bl = false;
            boolean bl2 = isKmp ? (scope == Scope.SOURCE ? !it.getConfig().isTestScope() : it.getConfig().isTestScope()) : true;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinDependency dependency = (KotlinDependency)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{dependency.getGroup(), dependency.getArtifact(), dependency.getVersion()};
            writer.write((Object)((Object)dependency.getConfig()) + "(\"#L:#L:#L\")", objectArray);
        }
    }

    private static final CharSequence writeGradleBuild$lambda$1$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '\"' + it + '\"';
    }

    private static final Unit writeGradleBuild$lambda$1(KotlinSettings $settings, AbstractCodeWriter abstractCodeWriter) {
        List annotations;
        Intrinsics.checkNotNullParameter((Object)abstractCodeWriter, (String)"<this>");
        List list = $settings.getBuild().getOptInAnnotations();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (!((Collection)(annotations = list)).isEmpty()) {
            String formatted = CollectionsKt.joinToString$default((Iterable)annotations, (CharSequence)",\n", null, null, (int)0, null, GradleGeneratorKt::writeGradleBuild$lambda$1$lambda$0, (int)30, null);
            abstractCodeWriter.write((Object)formatted, new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeGradleBuild$lambda$3$lambda$2(boolean $isRootModule, AbstractCodeWriter w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        if ($isRootModule) {
            Object[] objectArray = new Object[]{KotlinDependencyKt.getKOTLIN_COMPILER_VERSION()};
            w.write((Object)"version #S", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeGradleBuild$lambda$3(boolean $isKmp, boolean $isRootModule, AbstractCodeWriter abstractCodeWriter) {
        Intrinsics.checkNotNullParameter((Object)abstractCodeWriter, (String)"<this>");
        String pluginName = $isKmp ? "multiplatform" : "jvm";
        Object[] objectArray = new Object[]{arg_0 -> GradleGeneratorKt.writeGradleBuild$lambda$3$lambda$2($isRootModule, arg_0)};
        abstractCodeWriter.write((Object)("kotlin(\"" + pluginName + "\") #W"), objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderKmpGradleBuild$lambda$4(boolean $isRootModule, GradleWriter w) {
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        if ($isRootModule) {
            w.write("explicitApi()", new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderKmpGradleBuild$lambda$5(boolean $isRootModule, Function1 $repositoryRenderer, GradleWriter w) {
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        if ($isRootModule) {
            $repositoryRenderer.invoke((Object)w);
        }
        return Unit.INSTANCE;
    }

    private static final Object renderKmpGradleBuild$lambda$6(boolean $isRootModule, GradleWriter w) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        if ($isRootModule) {
            GradleGeneratorKt.renderRootJvmPluginConfig(w);
            unit = Unit.INSTANCE;
        } else {
            unit = w.write("jvm()", new Object[0]);
        }
        return unit;
    }

    private static final Unit renderKmpGradleBuild$lambda$7(List $dependencies, GradleWriter w) {
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        GradleGeneratorKt.renderDependencies(w, Scope.SOURCE, true, $dependencies);
        return Unit.INSTANCE;
    }

    private static final Unit renderKmpGradleBuild$lambda$8(List $dependencies, GradleWriter w) {
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        GradleGeneratorKt.renderDependencies(w, Scope.TEST, true, $dependencies);
        return Unit.INSTANCE;
    }

    private static final Unit renderJvmGradleBuild$lambda$9(boolean $isRootModule, Function1 $repositoryRenderer, GradleWriter w) {
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        if ($isRootModule) {
            $repositoryRenderer.invoke((Object)w);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderJvmGradleBuild$lambda$10(List $dependencies, GradleWriter w) {
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        GradleGeneratorKt.renderDependencies(w, Scope.SOURCE, false, $dependencies);
        return Unit.INSTANCE;
    }

    private static final Unit renderJvmGradleBuild$lambda$11(boolean $isRootModule, GradleWriter w) {
        Intrinsics.checkNotNullParameter((Object)((Object)w), (String)"w");
        if ($isRootModule) {
            w.write("explicitApi()", new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Comparable renderDependencies$lambda$12(KotlinDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getConfig());
    }

    private static final Comparable renderDependencies$lambda$13(KotlinDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getArtifact());
    }

    private static final Unit repositoryRenderer$lambda$16(AbstractCodeWriter abstractCodeWriter) {
        Intrinsics.checkNotNullParameter((Object)abstractCodeWriter, (String)"<this>");
        abstractCodeWriter.write((Object)"repositories {\n    mavenLocal()\n    mavenCentral()\n}", new Object[0]);
        return Unit.INSTANCE;
    }

    static {
        String string = System.getProperty("smithy.kotlin.codegen.jvmTargetVersion", "1.8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        JVM_TARGET_VERSION = string;
        repositoryRenderer = GradleGeneratorKt::repositoryRenderer$lambda$16;
    }
}

