/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.util;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.kotlin.codegen.utils.StringsKt;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"format", "", "Lsoftware/amazon/smithy/model/node/Node;", "smithy-kotlin-codegen"})
public final class NodeKt {
    @NotNull
    public static final String format(@NotNull Node $this$format) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Node node = $this$format;
        if (node instanceof NullNode) {
            string = "null";
        } else if (node instanceof StringNode) {
            String string2 = ((StringNode)$this$format).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            string = StringsKt.dq(string2);
        } else if (node instanceof BooleanNode) {
            string = String.valueOf(((BooleanNode)$this$format).getValue());
        } else if (node instanceof NumberNode) {
            string = ((NumberNode)$this$format).getValue().toString();
        } else if (node instanceof ArrayNode) {
            List list = ((ArrayNode)$this$format).getElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getElements(...)");
            string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", (CharSequence)"listOf(", (CharSequence)")", (int)0, null, NodeKt::format$lambda$0, (int)24, null);
        } else if (node instanceof ObjectNode) {
            string = CollectionsKt.joinToString$default((Iterable)((ObjectNode)$this$format).getStringMap().entrySet(), (CharSequence)", ", (CharSequence)"mapOf(", (CharSequence)")", (int)0, null, NodeKt::format$lambda$1, (int)24, null);
        } else {
            throw new IllegalStateException("Unexpected node type: " + $this$format);
        }
        return string;
    }

    private static final CharSequence format$lambda$0(Node element) {
        Intrinsics.checkNotNull((Object)element);
        return NodeKt.format(element);
    }

    private static final CharSequence format$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String key = (String)entry.getKey();
        Node value = (Node)entry.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        Intrinsics.checkNotNull((Object)key);
        StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.dq(key)).append(" to ");
        Intrinsics.checkNotNull((Object)value);
        return stringBuilder2.append(NodeKt.format(value)).toString();
    }
}

