/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.DeserializeStructGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.NestedIdentifierType;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J(\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0004J\b\u0010(\u001a\u00020\u0019H\u0016J(\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0015H\u0002J(\u0010.\u001a\u00020\u00192\u0006\u0010*\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J(\u0010/\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0015H\u0002J0\u00101\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u00103\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u001cH\u0004J(\u00105\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u0015H\u0002J0\u00107\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u00108\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u00104\u001a\u00020\"H\u0004J\u0010\u00109\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0006H\u0014J(\u0010:\u001a\u00020\u00192\u0006\u0010*\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J(\u0010;\u001a\u00020\u00192\u0006\u0010*\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006="}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;)V", "getCtx", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getMembers", "()Ljava/util/List;", "getWriter", "()Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "collectionReturnExpression", "", "memberShape", "defaultCollectionName", "delegateListDeserialization", "", "rootMemberShape", "listShape", "Lsoftware/amazon/smithy/model/shapes/CollectionShape;", "nestingLevel", "", "parentMemberName", "delegateMapDeserialization", "mapShape", "Lsoftware/amazon/smithy/model/shapes/MapShape;", "deserializationResultName", "defaultName", "deserializerForShape", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "render", "renderElement", "elementShape", "isSparse", "", "listMemberName", "renderEntry", "renderListElement", "parentListMemberName", "renderListEntry", "collectionShape", "renderListMemberDeserializer", "targetShape", "renderMapElement", "parentMapMemberName", "renderMapEntry", "renderMapMemberDeserializer", "renderMemberShape", "renderNestedStructureElement", "renderNestedStructureEntry", "renderShapeDeserializer", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nDeserializeStructGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeserializeStructGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,610:1\n72#2:611\n82#2:612\n*S KotlinDebug\n*F\n+ 1 DeserializeStructGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator\n*L\n397#1:611\n574#1:612\n*E\n"})
public class DeserializeStructGenerator {
    @NotNull
    private final ProtocolGenerator.GenerationContext ctx;
    @NotNull
    private final List<MemberShape> members;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public DeserializeStructGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<MemberShape> members, @NotNull KotlinWriter writer, @NotNull TimestampFormatTrait.Format defaultTimestampFormat) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)defaultTimestampFormat, (String)"defaultTimestampFormat");
        this.ctx = ctx;
        this.members = members;
        this.writer = writer;
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    @NotNull
    protected final ProtocolGenerator.GenerationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    protected final List<MemberShape> getMembers() {
        return this.members;
    }

    @NotNull
    protected final KotlinWriter getWriter() {
        return this.writer;
    }

    @NotNull
    protected final TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @NotNull
    public String collectionReturnExpression(@NotNull MemberShape memberShape2, @NotNull String defaultCollectionName) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)defaultCollectionName, (String)"defaultCollectionName");
        return defaultCollectionName;
    }

    @NotNull
    public String deserializationResultName(@NotNull String defaultName) {
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        return defaultName;
    }

    public void render() {
        String string;
        if (!((Collection)this.members).isEmpty()) {
            string = "OBJ_DESCRIPTOR";
        } else {
            KotlinWriter.addImport$default(this.writer, RuntimeTypes.Serde.INSTANCE.getSdkObjectDescriptor(), null, 2, null);
            string = "SdkObjectDescriptor.build {}";
        }
        String objDescriptor = string;
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeStruct()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "deserializer.#T(" + objDescriptor + ") {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this){
            final /* synthetic */ DeserializeStructGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "loop@while (true) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0){
                    final /* synthetic */ DeserializeStructGenerator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "when (findNextFieldIndex()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0){
                            final /* synthetic */ DeserializeStructGenerator this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                Iterable $this$sortedBy$iv = this.this$0.getMembers();
                                boolean $i$f$sortedBy = false;
                                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                    public final int compare(T a, T b) {
                                        MemberShape it = (MemberShape)a;
                                        boolean bl = false;
                                        Comparable comparable = (Comparable)((Object)it.getMemberName());
                                        it = (MemberShape)b;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
                                    }
                                });
                                DeserializeStructGenerator deserializeStructGenerator = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    MemberShape memberShape2 = (MemberShape)element$iv;
                                    boolean bl = false;
                                    deserializeStructGenerator.renderMemberShape(memberShape2);
                                }
                                $this$withBlock.write("null -> break@loop", new Object[0]);
                                $this$withBlock.write("else -> skipValue()", new Object[0]);
                            }
                        });
                    }
                });
            }
        });
    }

    protected void renderMemberShape(@NotNull MemberShape memberShape2) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        Shape targetShape = this.ctx.getModel().expectShape(memberShape2.getTarget());
        ShapeType shapeType = targetShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)targetShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListMemberDeserializer(memberShape2, (CollectionShape)targetShape);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)targetShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapMemberDeserializer(memberShape2, (MapShape)targetShape);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.renderShapeDeserializer(memberShape2);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected shape type: " + targetShape.getType()).toString());
            }
        }
    }

    public void renderShapeDeserializer(@NotNull MemberShape memberShape2) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape2);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape2, null, 1, null);
        String deserialize = this.deserializerForShape((Shape)memberShape2);
        this.writer.write(descriptorName + ".index -> builder." + memberName + " = " + deserialize, new Object[0]);
    }

    protected final void renderMapMemberDeserializer(@NotNull MemberShape memberShape2, @NotNull MapShape targetShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        int nestingLevel = 0;
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape2);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape2, null, 1, null);
        String valueCollector = this.deserializationResultName("builder." + memberName);
        String mutableCollectionName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.MAP);
        String collectionReturnExpression = this.collectionReturnExpression(memberShape2, mutableCollectionName);
        AbstractCodeWriter abstractCodeWriter = ((KotlinWriter)this.writer.write(descriptorName + ".index -> " + valueCollector + " = ", new Object[0])).indent();
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"indent(...)");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeMap()};
        ((KotlinWriter)AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "deserializer.#T(" + descriptorName + ") {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(mutableCollectionName, this, targetShape, collectionReturnExpression, memberShape2, nestingLevel){
            final /* synthetic */ String $mutableCollectionName;
            final /* synthetic */ DeserializeStructGenerator this$0;
            final /* synthetic */ MapShape $targetShape;
            final /* synthetic */ String $collectionReturnExpression;
            final /* synthetic */ MemberShape $memberShape;
            final /* synthetic */ int $nestingLevel;
            {
                this.$mutableCollectionName = $mutableCollectionName;
                this.this$0 = $receiver;
                this.$targetShape = $targetShape;
                this.$collectionReturnExpression = $collectionReturnExpression;
                this.$memberShape = $memberShape;
                this.$nestingLevel = $nestingLevel;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Object[] objectArray = new Object[]{this.$mutableCollectionName, KotlinTypes.Collections.INSTANCE.getMutableMapOf(), this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)this.$targetShape.getValue()), DeserializeStructGeneratorKt.access$nullabilitySuffix(ShapeExtKt.isSparse((Shape)this.$targetShape))};
                $this$withBlock.write("val #L = #T<String, #T#L>()", objectArray);
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextEntry()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0, this.$memberShape, this.$targetShape, this.$nestingLevel, this.$mutableCollectionName){
                    final /* synthetic */ DeserializeStructGenerator this$0;
                    final /* synthetic */ MemberShape $memberShape;
                    final /* synthetic */ MapShape $targetShape;
                    final /* synthetic */ int $nestingLevel;
                    final /* synthetic */ String $mutableCollectionName;
                    {
                        this.this$0 = $receiver;
                        this.$memberShape = $memberShape;
                        this.$targetShape = $targetShape;
                        this.$nestingLevel = $nestingLevel;
                        this.$mutableCollectionName = $mutableCollectionName;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        DeserializeStructGenerator.access$delegateMapDeserialization(this.this$0, this.$memberShape, this.$targetShape, this.$nestingLevel, this.$mutableCollectionName);
                    }
                });
                $this$withBlock.write(this.$collectionReturnExpression, new Object[0]);
            }
        })).dedent();
    }

    private final void delegateMapDeserialization(MemberShape rootMemberShape, MapShape mapShape, int nestingLevel, String parentMemberName) {
        Shape elementShape = this.ctx.getModel().expectShape(mapShape.getValue().getTarget());
        boolean isSparse = ShapeExtKt.isSparse((Shape)mapShape);
        ShapeType shapeType = elementShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderEntry(elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListEntry(rootMemberShape, (CollectionShape)elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapEntry(rootMemberShape, (MapShape)elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 4: 
            case 5: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderNestedStructureEntry(elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            default: {
                throw new IllegalStateException(("Unhandled type " + elementShape.getType()).toString());
            }
        }
    }

    private final void renderNestedStructureEntry(Shape elementShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String populateNullValuePostfix;
        String deserializerFn = this.deserializerForShape(elementShape);
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String string = populateNullValuePostfix = isSparse ? "" : "; continue";
        if (elementShape.isStructureShape() || elementShape.isUnionShape()) {
            Symbol symbol2 = this.ctx.getSymbolProvider().toSymbol(elementShape);
            Intrinsics.checkNotNull((Object)symbol2);
            KotlinWriter.addImport$default(this.writer, symbol2, null, 2, null);
        }
        this.writer.write("val " + keyName + " = key()", new Object[0]);
        this.writer.write("val " + valueName + " = if (nextHasValue()) { " + deserializerFn + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    private final void renderMapEntry(MemberShape rootMemberShape, MapShape mapShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        int nextNestingLevel = nestingLevel + 1;
        String memberName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.MAP);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, memberName);
        this.writer.write("val " + keyName + " = key()", new Object[0]);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + valueName + " =", "", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(populateNullValuePostfix, descriptorName, memberName, this, mapShape, collectionReturnExpression, rootMemberShape, nextNestingLevel){
            final /* synthetic */ String $populateNullValuePostfix;
            final /* synthetic */ String $descriptorName;
            final /* synthetic */ String $memberName;
            final /* synthetic */ DeserializeStructGenerator this$0;
            final /* synthetic */ MapShape $mapShape;
            final /* synthetic */ String $collectionReturnExpression;
            final /* synthetic */ MemberShape $rootMemberShape;
            final /* synthetic */ int $nextNestingLevel;
            {
                this.$populateNullValuePostfix = $populateNullValuePostfix;
                this.$descriptorName = $descriptorName;
                this.$memberName = $memberName;
                this.this$0 = $receiver;
                this.$mapShape = $mapShape;
                this.$collectionReturnExpression = $collectionReturnExpression;
                this.$rootMemberShape = $rootMemberShape;
                this.$nextNestingLevel = $nextNestingLevel;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "if (nextHasValue()) {", "} else { deserializeNull()" + this.$populateNullValuePostfix + " }", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.$descriptorName, this.$memberName, this.this$0, this.$mapShape, this.$collectionReturnExpression, this.$rootMemberShape, this.$nextNestingLevel){
                    final /* synthetic */ String $descriptorName;
                    final /* synthetic */ String $memberName;
                    final /* synthetic */ DeserializeStructGenerator this$0;
                    final /* synthetic */ MapShape $mapShape;
                    final /* synthetic */ String $collectionReturnExpression;
                    final /* synthetic */ MemberShape $rootMemberShape;
                    final /* synthetic */ int $nextNestingLevel;
                    {
                        this.$descriptorName = $descriptorName;
                        this.$memberName = $memberName;
                        this.this$0 = $receiver;
                        this.$mapShape = $mapShape;
                        this.$collectionReturnExpression = $collectionReturnExpression;
                        this.$rootMemberShape = $rootMemberShape;
                        this.$nextNestingLevel = $nextNestingLevel;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeMap()};
                        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "deserializer.#T(" + this.$descriptorName + ") {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this.$memberName, this.this$0, this.$mapShape, this.$collectionReturnExpression, this.$rootMemberShape, this.$nextNestingLevel){
                            final /* synthetic */ String $memberName;
                            final /* synthetic */ DeserializeStructGenerator this$0;
                            final /* synthetic */ MapShape $mapShape;
                            final /* synthetic */ String $collectionReturnExpression;
                            final /* synthetic */ MemberShape $rootMemberShape;
                            final /* synthetic */ int $nextNestingLevel;
                            {
                                this.$memberName = $memberName;
                                this.this$0 = $receiver;
                                this.$mapShape = $mapShape;
                                this.$collectionReturnExpression = $collectionReturnExpression;
                                this.$rootMemberShape = $rootMemberShape;
                                this.$nextNestingLevel = $nextNestingLevel;
                                super(1);
                            }

                            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                Object[] objectArray = new Object[]{this.$memberName, KotlinTypes.Collections.INSTANCE.getMutableMapOf(), this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)this.$mapShape.getValue()), DeserializeStructGeneratorKt.access$nullabilitySuffix(ShapeExtKt.isSparse((Shape)this.$mapShape))};
                                $this$withBlock.write("val #L = #T<String, #T#L>()", objectArray);
                                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextEntry()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0, this.$rootMemberShape, this.$mapShape, this.$nextNestingLevel, this.$memberName){
                                    final /* synthetic */ DeserializeStructGenerator this$0;
                                    final /* synthetic */ MemberShape $rootMemberShape;
                                    final /* synthetic */ MapShape $mapShape;
                                    final /* synthetic */ int $nextNestingLevel;
                                    final /* synthetic */ String $memberName;
                                    {
                                        this.this$0 = $receiver;
                                        this.$rootMemberShape = $rootMemberShape;
                                        this.$mapShape = $mapShape;
                                        this.$nextNestingLevel = $nextNestingLevel;
                                        this.$memberName = $memberName;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                        DeserializeStructGenerator.access$delegateMapDeserialization(this.this$0, this.$rootMemberShape, this.$mapShape, this.$nextNestingLevel, this.$memberName);
                                    }
                                });
                                $this$withBlock.write(this.$collectionReturnExpression, new Object[0]);
                            }
                        });
                    }
                });
            }
        });
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    private final void renderListEntry(MemberShape rootMemberShape, CollectionShape collectionShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        int nextNestingLevel = nestingLevel + 1;
        String memberName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.COLLECTION);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, memberName);
        this.writer.write("val " + keyName + " = key()", new Object[0]);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + valueName + " =", "", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(populateNullValuePostfix, descriptorName, memberName, this, collectionShape, collectionReturnExpression, rootMemberShape, nextNestingLevel){
            final /* synthetic */ String $populateNullValuePostfix;
            final /* synthetic */ String $descriptorName;
            final /* synthetic */ String $memberName;
            final /* synthetic */ DeserializeStructGenerator this$0;
            final /* synthetic */ CollectionShape $collectionShape;
            final /* synthetic */ String $collectionReturnExpression;
            final /* synthetic */ MemberShape $rootMemberShape;
            final /* synthetic */ int $nextNestingLevel;
            {
                this.$populateNullValuePostfix = $populateNullValuePostfix;
                this.$descriptorName = $descriptorName;
                this.$memberName = $memberName;
                this.this$0 = $receiver;
                this.$collectionShape = $collectionShape;
                this.$collectionReturnExpression = $collectionReturnExpression;
                this.$rootMemberShape = $rootMemberShape;
                this.$nextNestingLevel = $nextNestingLevel;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "if (nextHasValue()) {", "} else { deserializeNull()" + this.$populateNullValuePostfix + " }", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.$descriptorName, this.$memberName, this.this$0, this.$collectionShape, this.$collectionReturnExpression, this.$rootMemberShape, this.$nextNestingLevel){
                    final /* synthetic */ String $descriptorName;
                    final /* synthetic */ String $memberName;
                    final /* synthetic */ DeserializeStructGenerator this$0;
                    final /* synthetic */ CollectionShape $collectionShape;
                    final /* synthetic */ String $collectionReturnExpression;
                    final /* synthetic */ MemberShape $rootMemberShape;
                    final /* synthetic */ int $nextNestingLevel;
                    {
                        this.$descriptorName = $descriptorName;
                        this.$memberName = $memberName;
                        this.this$0 = $receiver;
                        this.$collectionShape = $collectionShape;
                        this.$collectionReturnExpression = $collectionReturnExpression;
                        this.$rootMemberShape = $rootMemberShape;
                        this.$nextNestingLevel = $nextNestingLevel;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeList()};
                        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "deserializer.#T(" + this.$descriptorName + ") {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this.$memberName, this.this$0, this.$collectionShape, this.$collectionReturnExpression, this.$rootMemberShape, this.$nextNestingLevel){
                            final /* synthetic */ String $memberName;
                            final /* synthetic */ DeserializeStructGenerator this$0;
                            final /* synthetic */ CollectionShape $collectionShape;
                            final /* synthetic */ String $collectionReturnExpression;
                            final /* synthetic */ MemberShape $rootMemberShape;
                            final /* synthetic */ int $nextNestingLevel;
                            {
                                this.$memberName = $memberName;
                                this.this$0 = $receiver;
                                this.$collectionShape = $collectionShape;
                                this.$collectionReturnExpression = $collectionReturnExpression;
                                this.$rootMemberShape = $rootMemberShape;
                                this.$nextNestingLevel = $nextNestingLevel;
                                super(1);
                            }

                            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                Object[] objectArray = new Object[]{this.$memberName, KotlinTypes.Collections.INSTANCE.getMutableListOf(), this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)this.$collectionShape.getMember()), DeserializeStructGeneratorKt.access$nullabilitySuffix(ShapeExtKt.isSparse((Shape)this.$collectionShape))};
                                $this$withBlock.write("val #L = #T<#T#L>()", objectArray);
                                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextElement()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0, this.$rootMemberShape, this.$collectionShape, this.$nextNestingLevel, this.$memberName){
                                    final /* synthetic */ DeserializeStructGenerator this$0;
                                    final /* synthetic */ MemberShape $rootMemberShape;
                                    final /* synthetic */ CollectionShape $collectionShape;
                                    final /* synthetic */ int $nextNestingLevel;
                                    final /* synthetic */ String $memberName;
                                    {
                                        this.this$0 = $receiver;
                                        this.$rootMemberShape = $rootMemberShape;
                                        this.$collectionShape = $collectionShape;
                                        this.$nextNestingLevel = $nextNestingLevel;
                                        this.$memberName = $memberName;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                        DeserializeStructGenerator.access$delegateListDeserialization(this.this$0, this.$rootMemberShape, this.$collectionShape, this.$nextNestingLevel, this.$memberName);
                                    }
                                });
                                $this$withBlock.write(this.$collectionReturnExpression, new Object[0]);
                            }
                        });
                    }
                });
            }
        });
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    private final void renderEntry(Shape elementShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String deserializerFn = this.deserializerForShape(elementShape);
        String keyName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.KEY);
        String valueName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.VALUE);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        this.writer.write("val " + keyName + " = key()", new Object[0]);
        this.writer.write("val " + valueName + " = if (nextHasValue()) { " + deserializerFn + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(parentMemberName + '[' + keyName + "] = " + valueName, new Object[0]);
    }

    protected final void renderListMemberDeserializer(@NotNull MemberShape memberShape2, @NotNull CollectionShape targetShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        int nestingLevel = 0;
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape2);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape2, null, 1, null);
        String valueCollector = this.deserializationResultName("builder." + memberName);
        String mutableCollectionName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.COLLECTION);
        String collectionReturnExpression = this.collectionReturnExpression(memberShape2, mutableCollectionName);
        AbstractCodeWriter abstractCodeWriter = ((KotlinWriter)this.writer.write(descriptorName + ".index -> " + valueCollector + " = ", new Object[0])).indent();
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"indent(...)");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeList()};
        ((KotlinWriter)AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "deserializer.#T(" + descriptorName + ") {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(mutableCollectionName, this, targetShape, collectionReturnExpression, memberShape2, nestingLevel){
            final /* synthetic */ String $mutableCollectionName;
            final /* synthetic */ DeserializeStructGenerator this$0;
            final /* synthetic */ CollectionShape $targetShape;
            final /* synthetic */ String $collectionReturnExpression;
            final /* synthetic */ MemberShape $memberShape;
            final /* synthetic */ int $nestingLevel;
            {
                this.$mutableCollectionName = $mutableCollectionName;
                this.this$0 = $receiver;
                this.$targetShape = $targetShape;
                this.$collectionReturnExpression = $collectionReturnExpression;
                this.$memberShape = $memberShape;
                this.$nestingLevel = $nestingLevel;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Object[] objectArray = new Object[]{this.$mutableCollectionName, KotlinTypes.Collections.INSTANCE.getMutableListOf(), this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)this.$targetShape.getMember()), DeserializeStructGeneratorKt.access$nullabilitySuffix(ShapeExtKt.isSparse((Shape)this.$targetShape))};
                $this$withBlock.write("val #L = #T<#T#L>()", objectArray);
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextElement()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0, this.$memberShape, this.$targetShape, this.$nestingLevel, this.$mutableCollectionName){
                    final /* synthetic */ DeserializeStructGenerator this$0;
                    final /* synthetic */ MemberShape $memberShape;
                    final /* synthetic */ CollectionShape $targetShape;
                    final /* synthetic */ int $nestingLevel;
                    final /* synthetic */ String $mutableCollectionName;
                    {
                        this.this$0 = $receiver;
                        this.$memberShape = $memberShape;
                        this.$targetShape = $targetShape;
                        this.$nestingLevel = $nestingLevel;
                        this.$mutableCollectionName = $mutableCollectionName;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        DeserializeStructGenerator.access$delegateListDeserialization(this.this$0, this.$memberShape, this.$targetShape, this.$nestingLevel, this.$mutableCollectionName);
                    }
                });
                $this$withBlock.write(this.$collectionReturnExpression, new Object[0]);
            }
        })).dedent();
    }

    private final void delegateListDeserialization(MemberShape rootMemberShape, CollectionShape listShape, int nestingLevel, String parentMemberName) {
        Shape elementShape = this.ctx.getModel().expectShape(listShape.getMember().getTarget());
        Shape $this$hasTrait$iv = (Shape)listShape;
        boolean $i$f$hasTrait = false;
        boolean isSparse = $this$hasTrait$iv.hasTrait(SparseTrait.class);
        ShapeType shapeType = elementShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderElement(elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListElement(rootMemberShape, (CollectionShape)elementShape, nestingLevel, parentMemberName);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapElement(rootMemberShape, (MapShape)elementShape, nestingLevel, parentMemberName);
                break;
            }
            case 4: 
            case 5: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderNestedStructureElement(elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            default: {
                throw new IllegalStateException(("Unhandled type " + elementShape.getType()).toString());
            }
        }
    }

    private final void renderNestedStructureElement(Shape elementShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String populateNullValuePostfix;
        String deserializer = this.deserializerForShape(elementShape);
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String string = populateNullValuePostfix = isSparse ? "" : "; continue";
        if (elementShape.isStructureShape() || elementShape.isUnionShape()) {
            Symbol symbol2 = this.ctx.getSymbolProvider().toSymbol(elementShape);
            Intrinsics.checkNotNull((Object)symbol2);
            KotlinWriter.addImport$default(this.writer, symbol2, null, 2, null);
        }
        this.writer.write("val " + elementName + " = if (nextHasValue()) { " + deserializer + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(parentMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    private final void renderMapElement(MemberShape rootMemberShape, MapShape mapShape, int nestingLevel, String parentMapMemberName) {
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        int nextNestingLevel = nestingLevel + 1;
        String mapName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.MAP);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, mapName);
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeMap()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + elementName + " = deserializer.#T(" + descriptorName + ") {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(mapName, this, mapShape, collectionReturnExpression, rootMemberShape, nextNestingLevel){
            final /* synthetic */ String $mapName;
            final /* synthetic */ DeserializeStructGenerator this$0;
            final /* synthetic */ MapShape $mapShape;
            final /* synthetic */ String $collectionReturnExpression;
            final /* synthetic */ MemberShape $rootMemberShape;
            final /* synthetic */ int $nextNestingLevel;
            {
                this.$mapName = $mapName;
                this.this$0 = $receiver;
                this.$mapShape = $mapShape;
                this.$collectionReturnExpression = $collectionReturnExpression;
                this.$rootMemberShape = $rootMemberShape;
                this.$nextNestingLevel = $nextNestingLevel;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Object[] objectArray = new Object[]{this.$mapName, KotlinTypes.Collections.INSTANCE.getMutableMapOf(), this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)this.$mapShape.getValue()), DeserializeStructGeneratorKt.access$nullabilitySuffix(ShapeExtKt.isSparse((Shape)this.$mapShape))};
                $this$withBlock.write("val #L = #T<String, #T#L>()", objectArray);
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextEntry()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0, this.$rootMemberShape, this.$mapShape, this.$nextNestingLevel, this.$mapName){
                    final /* synthetic */ DeserializeStructGenerator this$0;
                    final /* synthetic */ MemberShape $rootMemberShape;
                    final /* synthetic */ MapShape $mapShape;
                    final /* synthetic */ int $nextNestingLevel;
                    final /* synthetic */ String $mapName;
                    {
                        this.this$0 = $receiver;
                        this.$rootMemberShape = $rootMemberShape;
                        this.$mapShape = $mapShape;
                        this.$nextNestingLevel = $nextNestingLevel;
                        this.$mapName = $mapName;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        DeserializeStructGenerator.access$delegateMapDeserialization(this.this$0, this.$rootMemberShape, this.$mapShape, this.$nextNestingLevel, this.$mapName);
                    }
                });
                $this$withBlock.write(this.$collectionReturnExpression, new Object[0]);
            }
        });
        this.writer.write(parentMapMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    private final void renderListElement(MemberShape rootMemberShape, CollectionShape elementShape, int nestingLevel, String parentListMemberName) {
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        int nextNestingLevel = nestingLevel + 1;
        String listName = SerdeExtKt.variableNameFor(nextNestingLevel, NestedIdentifierType.COLLECTION);
        String collectionReturnExpression = this.collectionReturnExpression(rootMemberShape, listName);
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializeList()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "val " + elementName + " = deserializer.#T(" + descriptorName + ") {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(listName, this, elementShape, collectionReturnExpression, rootMemberShape, nextNestingLevel){
            final /* synthetic */ String $listName;
            final /* synthetic */ DeserializeStructGenerator this$0;
            final /* synthetic */ CollectionShape $elementShape;
            final /* synthetic */ String $collectionReturnExpression;
            final /* synthetic */ MemberShape $rootMemberShape;
            final /* synthetic */ int $nextNestingLevel;
            {
                this.$listName = $listName;
                this.this$0 = $receiver;
                this.$elementShape = $elementShape;
                this.$collectionReturnExpression = $collectionReturnExpression;
                this.$rootMemberShape = $rootMemberShape;
                this.$nextNestingLevel = $nextNestingLevel;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Object[] objectArray = new Object[]{this.$listName, KotlinTypes.Collections.INSTANCE.getMutableListOf(), this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)this.$elementShape.getMember()), DeserializeStructGeneratorKt.access$nullabilitySuffix(ShapeExtKt.isSparse((Shape)this.$elementShape))};
                $this$withBlock.write("val #L = #T<#T#L>()", objectArray);
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextElement()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0, this.$rootMemberShape, this.$elementShape, this.$nextNestingLevel, this.$listName){
                    final /* synthetic */ DeserializeStructGenerator this$0;
                    final /* synthetic */ MemberShape $rootMemberShape;
                    final /* synthetic */ CollectionShape $elementShape;
                    final /* synthetic */ int $nextNestingLevel;
                    final /* synthetic */ String $listName;
                    {
                        this.this$0 = $receiver;
                        this.$rootMemberShape = $rootMemberShape;
                        this.$elementShape = $elementShape;
                        this.$nextNestingLevel = $nextNestingLevel;
                        this.$listName = $listName;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        DeserializeStructGenerator.access$delegateListDeserialization(this.this$0, this.$rootMemberShape, this.$elementShape, this.$nextNestingLevel, this.$listName);
                    }
                });
                $this$withBlock.write(this.$collectionReturnExpression, new Object[0]);
            }
        });
        this.writer.write(parentListMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    private final void renderElement(Shape elementShape, int nestingLevel, boolean isSparse, String listMemberName) {
        String deserializerFn = this.deserializerForShape(elementShape);
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String populateNullValuePostfix = isSparse ? "" : "; continue";
        this.writer.write("val " + elementName + " = if (nextHasValue()) { " + deserializerFn + " } else { deserializeNull()" + populateNullValuePostfix + " }", new Object[0]);
        this.writer.write(listMemberName + ".add(" + elementName + ')', new Object[0]);
    }

    @NotNull
    protected final String deserializerForShape(@NotNull Shape shape) {
        String string;
        block16: {
            Shape target;
            block27: {
                TimestampFormatTrait trait;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    block17: {
                                                        block15: {
                                                            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                                                            target = ShapeExtKt.targetOrSelf(shape, this.ctx.getModel());
                                                            if (target.getType() != ShapeType.BOOLEAN) break block15;
                                                            string = "deserializeBoolean()";
                                                            break block16;
                                                        }
                                                        if (target.getType() != ShapeType.BYTE) break block17;
                                                        string = "deserializeByte()";
                                                        break block16;
                                                    }
                                                    if (target.getType() != ShapeType.SHORT) break block18;
                                                    string = "deserializeShort()";
                                                    break block16;
                                                }
                                                if (target.getType() != ShapeType.INTEGER) break block19;
                                                string = "deserializeInt()";
                                                break block16;
                                            }
                                            if (target.getType() != ShapeType.LONG) break block20;
                                            string = "deserializeLong()";
                                            break block16;
                                        }
                                        if (target.getType() != ShapeType.FLOAT) break block21;
                                        string = "deserializeFloat()";
                                        break block16;
                                    }
                                    if (target.getType() != ShapeType.DOUBLE) break block22;
                                    string = "deserializeDouble()";
                                    break block16;
                                }
                                if (target.getType() != ShapeType.BIG_INTEGER) break block23;
                                string = "deserializeBigInteger()";
                                break block16;
                            }
                            if (target.getType() != ShapeType.BIG_DECIMAL) break block24;
                            string = "deserializeBigDecimal()";
                            break block16;
                        }
                        if (target.getType() != ShapeType.DOCUMENT) break block25;
                        string = "deserializeDocument()";
                        break block16;
                    }
                    if (target.getType() != ShapeType.BLOB) break block26;
                    KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.Text.Encoding.INSTANCE.getDecodeBase64Bytes(), null, 2, null);
                    string = "deserializeString().decodeBase64Bytes()";
                    break block16;
                }
                if (target.getType() != ShapeType.TIMESTAMP) break block27;
                KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.INSTANCE.getInstant(), null, 2, null);
                Shape $this$getTrait$iv = shape;
                boolean $i$f$getTrait = false;
                Optional optional = $this$getTrait$iv.getTrait(TimestampFormatTrait.class);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
                TimestampFormatTrait timestampFormatTrait = (TimestampFormatTrait)((Trait)OptionalExtKt.getOrNull(optional));
                if (timestampFormatTrait == null) {
                    $this$getTrait$iv = target;
                    $i$f$getTrait = false;
                    Optional optional2 = $this$getTrait$iv.getTrait(TimestampFormatTrait.class);
                    Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getTrait(...)");
                    timestampFormatTrait = (TimestampFormatTrait)((Trait)OptionalExtKt.getOrNull(optional2));
                }
                TimestampFormatTrait timestampFormatTrait2 = trait = timestampFormatTrait;
                Object object = timestampFormatTrait2 != null ? timestampFormatTrait2.getFormat() : null;
                if (object == null) {
                    object = this.defaultTimestampFormat;
                }
                TimestampFormatTrait.Format tsFormat2 = object;
                switch (WhenMappings.$EnumSwitchMapping$1[tsFormat2.ordinal()]) {
                    case 1: {
                        string = "deserializeString().let { Instant.fromEpochSeconds(it) }";
                        break block16;
                    }
                    case 2: {
                        string = "deserializeString().let { Instant.fromIso8601(it) }";
                        break block16;
                    }
                    case 3: {
                        string = "deserializeString().let { Instant.fromRfc5322(it) }";
                        break block16;
                    }
                    default: {
                        throw new CodegenException("unknown timestamp format: " + tsFormat2);
                    }
                }
            }
            if (ShapeExtKt.isStringEnumShape(target)) {
                Symbol enumSymbol = this.ctx.getSymbolProvider().toSymbol(target);
                Intrinsics.checkNotNull((Object)enumSymbol);
                KotlinWriter.addImport$default(this.writer, enumSymbol, null, 2, null);
                string = "deserializeString().let { " + enumSymbol.getName() + ".fromValue(it) }";
            } else if (target.isIntEnumShape()) {
                Symbol enumSymbol = this.ctx.getSymbolProvider().toSymbol(target);
                Intrinsics.checkNotNull((Object)enumSymbol);
                KotlinWriter.addImport$default(this.writer, enumSymbol, null, 2, null);
                string = "deserializeInt().let { " + enumSymbol.getName() + ".fromValue(it) }";
            } else if (target.getType() == ShapeType.STRING) {
                string = "deserializeString()";
            } else if (target.getType() == ShapeType.STRUCTURE || target.getType() == ShapeType.UNION) {
                Symbol symbol2 = this.ctx.getSymbolProvider().toSymbol(target);
                Intrinsics.checkNotNull((Object)symbol2);
                String deserializerName = SerdeExtKt.documentDeserializerName(symbol2);
                string = deserializerName + "(deserializer)";
            } else {
                throw new CodegenException("unknown deserializer for member: " + shape + "; target: " + target);
            }
        }
        return string;
    }

    public static final /* synthetic */ void access$delegateMapDeserialization(DeserializeStructGenerator $this, MemberShape rootMemberShape, MapShape mapShape, int nestingLevel, String parentMemberName) {
        $this.delegateMapDeserialization(rootMemberShape, mapShape, nestingLevel, parentMemberName);
    }

    public static final /* synthetic */ void access$delegateListDeserialization(DeserializeStructGenerator $this, MemberShape rootMemberShape, CollectionShape listShape, int nestingLevel, String parentMemberName) {
        $this.delegateListDeserialization(rootMemberShape, listShape, nestingLevel, parentMemberName);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.STRUCTURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.UNION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BLOB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BOOLEAN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.STRING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.TIMESTAMP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BYTE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SHORT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INTEGER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.LONG.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.FLOAT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOUBLE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOCUMENT.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BIG_DECIMAL.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BIG_INTEGER.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.ENUM.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INT_ENUM.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TimestampFormatTrait.Format.values().length];
            try {
                nArray[TimestampFormatTrait.Format.EPOCH_SECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormatTrait.Format.DATE_TIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TimestampFormatTrait.Format.HTTP_DATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

