/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.kotlin.codegen.ApiSettings;
import software.amazon.smithy.kotlin.codegen.BuildSettings;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.KotlinSettingsKt;
import software.amazon.smithy.kotlin.codegen.UnresolvableProtocolException;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypesKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0002+,B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0015\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020$H\u00d6\u0001J$\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)J\t\u0010*\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006-"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "", "service", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "pkg", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;", "sdkId", "", "build", "Lsoftware/amazon/smithy/kotlin/codegen/BuildSettings;", "api", "Lsoftware/amazon/smithy/kotlin/codegen/ApiSettings;", "(Lsoftware/amazon/smithy/model/shapes/ShapeId;Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;Ljava/lang/String;Lsoftware/amazon/smithy/kotlin/codegen/BuildSettings;Lsoftware/amazon/smithy/kotlin/codegen/ApiSettings;)V", "getApi", "()Lsoftware/amazon/smithy/kotlin/codegen/ApiSettings;", "getBuild", "()Lsoftware/amazon/smithy/kotlin/codegen/BuildSettings;", "getPkg", "()Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;", "getSdkId", "()Ljava/lang/String;", "getService", "()Lsoftware/amazon/smithy/model/shapes/ShapeId;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "model", "Lsoftware/amazon/smithy/model/Model;", "hashCode", "", "resolveServiceProtocol", "serviceIndex", "Lsoftware/amazon/smithy/model/knowledge/ServiceIndex;", "supportedProtocolTraits", "", "toString", "Companion", "PackageSettings", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nKotlinSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSettings.kt\nsoftware/amazon/smithy/kotlin/codegen/KotlinSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n288#2,2:303\n*S KotlinDebug\n*F\n+ 1 KotlinSettings.kt\nsoftware/amazon/smithy/kotlin/codegen/KotlinSettings\n*L\n133#1:303,2\n*E\n"})
public final class KotlinSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShapeId service;
    @NotNull
    private final PackageSettings pkg;
    @NotNull
    private final String sdkId;
    @NotNull
    private final BuildSettings build;
    @NotNull
    private final ApiSettings api;
    @NotNull
    private static final Logger LOGGER;

    public KotlinSettings(@NotNull ShapeId service2, @NotNull PackageSettings pkg, @NotNull String sdkId, @NotNull BuildSettings build, @NotNull ApiSettings api) {
        Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.service = service2;
        this.pkg = pkg;
        this.sdkId = sdkId;
        this.build = build;
        this.api = api;
    }

    public /* synthetic */ KotlinSettings(ShapeId shapeId, PackageSettings packageSettings, String string, BuildSettings buildSettings, ApiSettings apiSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            buildSettings = BuildSettings.Companion.getDefault();
        }
        if ((n & 0x10) != 0) {
            apiSettings = ApiSettings.Companion.getDefault();
        }
        this(shapeId, packageSettings, string, buildSettings, apiSettings);
    }

    @NotNull
    public final ShapeId getService() {
        return this.service;
    }

    @NotNull
    public final PackageSettings getPkg() {
        return this.pkg;
    }

    @NotNull
    public final String getSdkId() {
        return this.sdkId;
    }

    @NotNull
    public final BuildSettings getBuild() {
        return this.build;
    }

    @NotNull
    public final ApiSettings getApi() {
        return this.api;
    }

    @NotNull
    public final ServiceShape getService(@NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Object t = ((Shape)model.getShape(this.service).orElseThrow(() -> KotlinSettings.getService$lambda$0(this))).asServiceShape().orElseThrow(() -> KotlinSettings.getService$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (ServiceShape)t;
    }

    @NotNull
    public final ShapeId resolveServiceProtocol(@NotNull ServiceIndex serviceIndex, @NotNull ServiceShape service2, @NotNull Set<ShapeId> supportedProtocolTraits) {
        ShapeId protocol;
        Object v0;
        Set resolvedProtocols;
        block2: {
            Intrinsics.checkNotNullParameter((Object)serviceIndex, (String)"serviceIndex");
            Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
            Intrinsics.checkNotNullParameter(supportedProtocolTraits, (String)"supportedProtocolTraits");
            resolvedProtocols = serviceIndex.getProtocols((ToShapeId)service2).keySet();
            Iterable $this$firstOrNull$iv = resolvedProtocols;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ShapeId p0 = (ShapeId)element$iv;
                boolean bl = false;
                if (!supportedProtocolTraits.contains(p0)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ShapeId shapeId = protocol = (ShapeId)v0;
        if (shapeId == null) {
            throw new UnresolvableProtocolException("The " + service2.getId() + " service supports the following unsupported protocols " + resolvedProtocols + ". The following protocol generators were found on the class path: " + supportedProtocolTraits);
        }
        return shapeId;
    }

    @NotNull
    public final ShapeId component1() {
        return this.service;
    }

    @NotNull
    public final PackageSettings component2() {
        return this.pkg;
    }

    @NotNull
    public final String component3() {
        return this.sdkId;
    }

    @NotNull
    public final BuildSettings component4() {
        return this.build;
    }

    @NotNull
    public final ApiSettings component5() {
        return this.api;
    }

    @NotNull
    public final KotlinSettings copy(@NotNull ShapeId service2, @NotNull PackageSettings pkg, @NotNull String sdkId, @NotNull BuildSettings build, @NotNull ApiSettings api) {
        Intrinsics.checkNotNullParameter((Object)service2, (String)"service");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)sdkId, (String)"sdkId");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        return new KotlinSettings(service2, pkg, sdkId, build, api);
    }

    public static /* synthetic */ KotlinSettings copy$default(KotlinSettings kotlinSettings, ShapeId shapeId, PackageSettings packageSettings, String string, BuildSettings buildSettings, ApiSettings apiSettings, int n, Object object) {
        if ((n & 1) != 0) {
            shapeId = kotlinSettings.service;
        }
        if ((n & 2) != 0) {
            packageSettings = kotlinSettings.pkg;
        }
        if ((n & 4) != 0) {
            string = kotlinSettings.sdkId;
        }
        if ((n & 8) != 0) {
            buildSettings = kotlinSettings.build;
        }
        if ((n & 0x10) != 0) {
            apiSettings = kotlinSettings.api;
        }
        return kotlinSettings.copy(shapeId, packageSettings, string, buildSettings, apiSettings);
    }

    @NotNull
    public String toString() {
        return "KotlinSettings(service=" + this.service + ", pkg=" + this.pkg + ", sdkId=" + this.sdkId + ", build=" + this.build + ", api=" + this.api + ')';
    }

    public int hashCode() {
        int result = this.service.hashCode();
        result = result * 31 + this.pkg.hashCode();
        result = result * 31 + this.sdkId.hashCode();
        result = result * 31 + this.build.hashCode();
        result = result * 31 + this.api.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinSettings)) {
            return false;
        }
        KotlinSettings kotlinSettings = (KotlinSettings)other;
        if (!Intrinsics.areEqual((Object)this.service, (Object)kotlinSettings.service)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pkg, (Object)kotlinSettings.pkg)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sdkId, (Object)kotlinSettings.sdkId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.build, (Object)kotlinSettings.build)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.api, (Object)kotlinSettings.api);
    }

    private static final CodegenException getService$lambda$0(KotlinSettings this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new CodegenException("Service shape not found: " + this$0.service);
    }

    private static final CodegenException getService$lambda$1(KotlinSettings this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new CodegenException("Shape is not a service: " + this$0.service);
    }

    static {
        Logger logger = Logger.getLogger(KotlinSettings.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$Companion;", "", "()V", "LOGGER", "Ljava/util/logging/Logger;", "from", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "model", "Lsoftware/amazon/smithy/model/Model;", "config", "Lsoftware/amazon/smithy/model/node/ObjectNode;", "smithy-kotlin-codegen"})
    @SourceDebugExtension(value={"SMAP\nKotlinSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSettings.kt\nsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinSettings from(@NotNull Model model, @NotNull ObjectNode config) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Object[] objectArray = new String[]{"service", "package", "build", "sdkId", "api"};
            config.warnIfAdditionalProperties((Collection)CollectionsKt.listOf((Object[])objectArray));
            ShapeId serviceId2 = config.getStringMember("service").map(arg_0 -> Companion.from$lambda$0(from.serviceId.1.INSTANCE, arg_0)).orElseGet(() -> Companion.from$lambda$2(model));
            ObjectNode packageNode = config.expectObjectMember("package");
            String packageName = packageNode.expectStringMember("name").getValue();
            Intrinsics.checkNotNull((Object)packageName);
            if (!KotlinTypesKt.isValidPackageName(packageName)) {
                throw new CodegenException("Invalid package name, is empty or has invalid characters: '" + packageName + '\'');
            }
            String version2 = packageNode.expectStringMember("version").getValue();
            String desc = packageNode.getStringMemberOrDefault("description", packageName + " client");
            String sdkId = config.getStringMemberOrDefault("sdkId", serviceId2.getName());
            Optional build = config.getObjectMember("build");
            Optional api = config.getObjectMember("api");
            Intrinsics.checkNotNull((Object)serviceId2);
            Intrinsics.checkNotNull((Object)version2);
            PackageSettings packageSettings = new PackageSettings(packageName, version2, desc);
            Intrinsics.checkNotNull((Object)sdkId);
            Intrinsics.checkNotNull((Object)build);
            BuildSettings buildSettings = BuildSettings.Companion.fromNode(build);
            Intrinsics.checkNotNull((Object)api);
            return new KotlinSettings(serviceId2, packageSettings, sdkId, buildSettings, ApiSettings.Companion.fromNode(api));
        }

        private static final ShapeId from$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (ShapeId)$tmp0.invoke(p0);
        }

        private static final ShapeId from$lambda$2(Model $model) {
            ShapeId shapeId;
            Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
            ShapeId it = shapeId = KotlinSettingsKt.inferService($model);
            boolean bl = false;
            LOGGER.info("Inferring service to generate as " + it);
            return shapeId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0019"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings$PackageSettings;", "", "name", "", "version", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getName", "serde", "getSerde", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "subpackage", "subpackageName", "toString", "smithy-kotlin-codegen"})
    public static final class PackageSettings {
        @NotNull
        private final String name;
        @NotNull
        private final String version;
        @Nullable
        private final String description;

        public PackageSettings(@NotNull String name, @NotNull String version2, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            this.name = name;
            this.version = version2;
            this.description = description;
        }

        public /* synthetic */ PackageSettings(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String subpackage(@NotNull String subpackageName) {
            Intrinsics.checkNotNullParameter((Object)subpackageName, (String)"subpackageName");
            return this.name + '.' + subpackageName;
        }

        @NotNull
        public final String getSerde() {
            return this.subpackage("serde");
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final PackageSettings copy(@NotNull String name, @NotNull String version2, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            return new PackageSettings(name, version2, description);
        }

        public static /* synthetic */ PackageSettings copy$default(PackageSettings packageSettings, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = packageSettings.name;
            }
            if ((n & 2) != 0) {
                string2 = packageSettings.version;
            }
            if ((n & 4) != 0) {
                string3 = packageSettings.description;
            }
            return packageSettings.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PackageSettings(name=" + this.name + ", version=" + this.version + ", description=" + this.description + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.version.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageSettings)) {
                return false;
            }
            PackageSettings packageSettings = (PackageSettings)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)packageSettings.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)packageSettings.version)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)packageSettings.description);
        }
    }
}

