/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.HttpChecksumTrait;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.integration.SectionKey;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolClientGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.EndpointTrait;
import software.amazon.smithy.model.traits.HttpChecksumRequiredTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010%\u001a\u00020\u0011*\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "middleware", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolMiddleware;", "httpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;)V", "getCtx", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getHttpBindingResolver", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "getMiddleware", "()Ljava/util/List;", "importSymbols", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "ioSymbolNames", "Lkotlin/Pair;", "", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "render", "renderAdditionalMethods", "renderClose", "renderFinalizeBeforeExecute", "opIndex", "Lsoftware/amazon/smithy/model/knowledge/OperationIndex;", "renderInit", "renderOperationBody", "renderOperationExecute", "renderOperationMiddleware", "renderOperationSetup", "renderProperties", "renderIsMd5ChecksumRequired", "OperationDeserializerBinding", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nHttpProtocolClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpProtocolClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,303:1\n1045#2:304\n766#2:305\n857#2,2:306\n1045#2:308\n1855#2,2:309\n288#2,2:313\n1855#2:316\n857#2,2:317\n1856#2:319\n1855#2,2:320\n1855#2,2:322\n83#3:311\n73#3:312\n73#3:315\n83#3:324\n*S KotlinDebug\n*F\n+ 1 HttpProtocolClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator\n*L\n42#1:304\n252#1:305\n252#1:306,2\n253#1:308\n254#1:309,2\n289#1:313,2\n55#1:316\n56#1:317,2\n55#1:319\n60#1:320,2\n63#1:322,2\n280#1:311\n283#1:312\n291#1:315\n175#1:324\n*E\n"})
public abstract class HttpProtocolClientGenerator {
    @NotNull
    private final ProtocolGenerator.GenerationContext ctx;
    @NotNull
    private final List<ProtocolMiddleware> middleware;
    @NotNull
    private final HttpBindingResolver httpBindingResolver;

    public HttpProtocolClientGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> middleware, @NotNull HttpBindingResolver httpBindingResolver) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(middleware, (String)"middleware");
        Intrinsics.checkNotNullParameter((Object)httpBindingResolver, (String)"httpBindingResolver");
        this.ctx = ctx;
        this.middleware = middleware;
        this.httpBindingResolver = httpBindingResolver;
    }

    @NotNull
    protected final ProtocolGenerator.GenerationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    protected final List<ProtocolMiddleware> getMiddleware() {
        return this.middleware;
    }

    @NotNull
    protected final HttpBindingResolver getHttpBindingResolver() {
        return this.httpBindingResolver;
    }

    public void render(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Symbol symbol2 = this.ctx.getSymbolProvider().toSymbol((Shape)this.ctx.getService());
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.ctx.getModel());
        Set set = topDownIndex.getContainedOperations((ToShapeId)this.ctx.getService());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"topDownIndex.getContainedOperations(ctx.service)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        List operations = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OperationShape it = (OperationShape)a;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Comparable comparable = (Comparable)((Object)NamingKt.defaultName(it));
                it = (OperationShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)NamingKt.defaultName(it))));
            }
        });
        OperationIndex operationsIndex = OperationIndex.of((Model)this.ctx.getModel());
        this.importSymbols(writer);
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)writer.openBlock("internal class Default" + symbol2.getName() + "(override val config: " + symbol2.getName() + ".Config) : " + symbol2.getName() + " {", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$1(this, writer))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$2(this, writer))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$6(operations, this, writer))).call(() -> HttpProtocolClientGenerator.render$lambda$8(operations, this, writer, operationsIndex))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$9(this, writer))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$10(this, writer))).closeBlock("}", new Object[0])).write("", new Object[0]);
    }

    protected void renderProperties(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.IO.INSTANCE.getSdkManagedGroup()};
        writer.write("private val managedResources = #T()", objectArray);
        objectArray = new Object[]{RuntimeTypes.HttpClient.INSTANCE.getSdkHttpClient()};
        writer.write("private val client = #T(config.httpClientEngine)", objectArray);
    }

    protected void importSymbols(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        KotlinWriter.addImport$default(writer, this.ctx.getSettings().getPkg().getName() + ".model", "*", null, 4, null);
        KotlinWriter.addImport$default(writer, this.ctx.getSettings().getPkg().getName() + ".transform", "*", null, 4, null);
        Object[] objectArray = new Symbol[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getSdkHttpOperation(), RuntimeTypes.HttpClient.Operation.INSTANCE.getContext()};
        Set defaultClientSymbols = SetsKt.setOf((Object[])objectArray);
        KotlinWriterKt.addImport(writer, (Iterable<Symbol>)defaultClientSymbols);
        writer.getDependencies().addAll((Collection<SymbolDependency>)KotlinDependency.Companion.getHTTP().getDependencies());
    }

    protected void renderInit(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "init {", "}", new Object[0], renderInit.1.INSTANCE);
    }

    protected void renderOperationBody(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        writer.write("", new Object[0]);
        writer.renderDocumentation((Shape)op);
        writer.renderAnnotations((Shape)op);
        String signature = ShapeExtKt.operationSignature$default(opIndex, this.ctx.getModel(), this.ctx.getSymbolProvider(), op, false, 8, null);
        Object[] objectArray = new Object[]{signature};
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)writer.openBlock("override #L {", objectArray)).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$11(this, writer, opIndex, op))).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$12(this, op, writer))).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$13(this, writer, opIndex, op))).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$14(this, writer, opIndex, op))).closeBlock("}", new Object[0]);
    }

    protected void renderOperationSetup(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Optional inputShape = opIndex.getInput((ToShapeId)op);
        Optional outputShape2 = opIndex.getOutput((ToShapeId)op);
        HttpTrait httpTrait = this.httpBindingResolver.httpTrait(op);
        Pair<String, String> pair = this.ioSymbolNames(op);
        String inputSymbolName2 = (String)pair.component1();
        String outputSymbolName2 = (String)pair.component2();
        writer.openBlock("val op = SdkHttpOperation.build<#L, #L> {", "}", inputSymbolName2, outputSymbolName2, () -> HttpProtocolClientGenerator.renderOperationSetup$lambda$19(inputShape, writer, op, httpTrait, outputShape2));
        writer.write("op.execution.retryStrategy = config.retryStrategy", new Object[0]);
    }

    protected void renderFinalizeBeforeExecute(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        writer.write("op.interceptors.addAll(config.interceptors)", new Object[0]);
    }

    protected void renderOperationExecute(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Optional inputShape = opIndex.getInput((ToShapeId)op);
        Optional outputShape2 = opIndex.getOutput((ToShapeId)op);
        Boolean hasOutputStream2 = outputShape2.map(arg_0 -> HttpProtocolClientGenerator.renderOperationExecute$lambda$20((Function1)new Function1<StructureShape, Boolean>(this){
            final /* synthetic */ HttpProtocolClientGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(StructureShape it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ShapeExtKt.hasStreamingMember(it, this.this$0.getCtx().getModel());
            }
        }, arg_0)).orElse(false);
        String inputVariableName = inputShape.isPresent() ? "input" : KotlinTypes.INSTANCE.getUnit().getFullName();
        Object[] objectArray = new Object[]{op.getId().getName(), RuntimeTypes.HttpClient.Operation.INSTANCE.getSdkRequestId()};
        AbstractCodeWriter abstractCodeWriter = writer.write("val rootSpan = config.tracer.createRootSpan(\"#L-${op.context.#T}\")", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"writer\n            .writ\u2026kRequestId,\n            )");
        Object[] objectArray2 = new Object[]{RuntimeTypes.KotlinCoroutines.INSTANCE.getCoroutineContext(), RuntimeTypes.Tracing.Core.INSTANCE.getWithRootTraceSpan()};
        AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "return #T.#T(rootSpan) {", "}", objectArray2, (Function1)new Function1<KotlinWriter, Unit>(hasOutputStream2, inputVariableName){
            final /* synthetic */ Boolean $hasOutputStream;
            final /* synthetic */ String $inputVariableName;
            {
                this.$hasOutputStream = $hasOutputStream;
                this.$inputVariableName = $inputVariableName;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Boolean bl = this.$hasOutputStream;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasOutputStream");
                if (bl.booleanValue()) {
                    Object[] objectArray = new Object[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getExecute(), this.$inputVariableName};
                    $this$withBlock.write("op.#T(client, #L, block)", objectArray);
                } else {
                    Object[] objectArray = new Object[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getRoundTrip(), this.$inputVariableName};
                    $this$withBlock.write("op.#T(client, #L)", objectArray);
                }
            }
        });
    }

    private final Pair<String, String> ioSymbolNames(OperationShape op) {
        OperationIndex opIndex = OperationIndex.of((Model)this.ctx.getModel());
        Optional inputShape = opIndex.getInput((ToShapeId)op);
        Optional outputShape2 = opIndex.getOutput((ToShapeId)op);
        Optional<String> optional = inputShape.map(arg_0 -> HttpProtocolClientGenerator.ioSymbolNames$lambda$21((Function1)new Function1<StructureShape, String>(this){
            final /* synthetic */ HttpProtocolClientGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(StructureShape it) {
                return this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)it).getName();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"private fun ioSymbolName\u2026, outputSymbolName)\n    }");
        String string = OptionalExtKt.getOrNull(optional);
        if (string == null) {
            string = KotlinTypes.INSTANCE.getUnit().getFullName();
        }
        String inputSymbolName2 = string;
        Optional<String> optional2 = outputShape2.map(arg_0 -> HttpProtocolClientGenerator.ioSymbolNames$lambda$22((Function1)new Function1<StructureShape, String>(this){
            final /* synthetic */ HttpProtocolClientGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(StructureShape it) {
                return this.this$0.getCtx().getSymbolProvider().toSymbol((Shape)it).getName();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"private fun ioSymbolName\u2026, outputSymbolName)\n    }");
        String string2 = OptionalExtKt.getOrNull(optional2);
        if (string2 == null) {
            string2 = KotlinTypes.INSTANCE.getUnit().getFullName();
        }
        String outputSymbolName2 = string2;
        return new Pair((Object)inputSymbolName2, (Object)outputSymbolName2);
    }

    /*
     * WARNING - void declaration
     */
    protected void renderOperationMiddleware(@NotNull OperationShape op, @NotNull KotlinWriter writer) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Iterable $this$filter$iv = this.middleware;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProtocolMiddleware it = (ProtocolMiddleware)element$iv$iv;
            boolean bl = false;
            if (!it.isEnabledFor(this.ctx, op)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProtocolMiddleware p0 = (ProtocolMiddleware)a;
                boolean bl = false;
                Comparable comparable = Byte.valueOf(p0.getOrder());
                p0 = (ProtocolMiddleware)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(p0.getOrder()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolMiddleware middleware = (ProtocolMiddleware)element$iv;
            boolean bl = false;
            middleware.render(this.ctx, op, writer);
        }
        this.renderIsMd5ChecksumRequired(op, writer);
    }

    protected void renderClose(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "override fun close() {", "}", new Object[0], renderClose.1.INSTANCE);
    }

    protected void renderAdditionalMethods(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderIsMd5ChecksumRequired(OperationShape $this$renderIsMd5ChecksumRequired, KotlinWriter writer) {
        block10: {
            Object object;
            Symbol inputSymbol;
            Symbol interceptorSymbol;
            block11: {
                MemberShape requestAlgorithmMember;
                block9: {
                    MemberShape memberShape2;
                    Collection collection;
                    Shape $this$getTrait$iv = (Shape)$this$renderIsMd5ChecksumRequired;
                    boolean $i$f$getTrait = false;
                    Optional optional = $this$getTrait$iv.getTrait(HttpChecksumTrait.class);
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(T::class.java)");
                    HttpChecksumTrait httpChecksumTrait = (HttpChecksumTrait)((Trait)OptionalExtKt.getOrNull(optional));
                    Shape $this$hasTrait$iv = (Shape)$this$renderIsMd5ChecksumRequired;
                    boolean $i$f$hasTrait22 = false;
                    if (!$this$hasTrait$iv.hasTrait(HttpChecksumRequiredTrait.class) && httpChecksumTrait == null) {
                        return;
                    }
                    Optional optional2 = this.ctx.getModel().getShape((ShapeId)$this$renderIsMd5ChecksumRequired.getInput().get());
                    Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"ctx.model.getShape(input.get())");
                    Shape $i$f$hasTrait22 = (Shape)OptionalExtKt.getOrNull(optional2);
                    if ($i$f$hasTrait22 != null && (collection = $i$f$hasTrait22.members()) != null) {
                        Object v3;
                        block8: {
                            void $this$firstOrNull$iv;
                            Iterable iterable = collection;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                Object object2;
                                MemberShape it = (MemberShape)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getMemberName(), (object2 = httpChecksumTrait) != null && (object2 = object2.getRequestAlgorithmMember()) != null ? (String)OptionalExtKt.getOrNull(object2) : null)) continue;
                                v3 = element$iv;
                                break block8;
                            }
                            v3 = null;
                        }
                        memberShape2 = v3;
                    } else {
                        memberShape2 = null;
                    }
                    requestAlgorithmMember = memberShape2;
                    Shape $this$hasTrait$iv2 = (Shape)$this$renderIsMd5ChecksumRequired;
                    boolean $i$f$hasTrait = false;
                    if ($this$hasTrait$iv2.hasTrait(HttpChecksumRequiredTrait.class)) break block9;
                    HttpChecksumTrait httpChecksumTrait2 = httpChecksumTrait;
                    boolean bl = httpChecksumTrait2 != null ? httpChecksumTrait2.isRequestChecksumRequired() : false;
                    if (!bl) break block10;
                }
                interceptorSymbol = RuntimeTypes.HttpClient.Interceptors.INSTANCE.getMd5ChecksumInterceptor();
                inputSymbol = this.ctx.getSymbolProvider().toSymbol(this.ctx.getModel().expectShape($this$renderIsMd5ChecksumRequired.getInputShape()));
                object = requestAlgorithmMember;
                if (object == null) break block11;
                MemberShape it = object;
                boolean bl = false;
                AbstractCodeWriter abstractCodeWriter = writer;
                Object[] objectArray = new Object[2];
                objectArray[0] = interceptorSymbol;
                Intrinsics.checkNotNullExpressionValue((Object)inputSymbol, (String)"inputSymbol");
                objectArray[1] = inputSymbol;
                KotlinWriter kotlinWriter = (KotlinWriter)AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "op.interceptors.add(#T<#T> { ", "})", objectArray, (Function1)new Function1<KotlinWriter, Unit>(writer, requestAlgorithmMember){
                    final /* synthetic */ KotlinWriter $writer;
                    final /* synthetic */ MemberShape $requestAlgorithmMember;
                    {
                        this.$writer = $writer;
                        this.$requestAlgorithmMember = $requestAlgorithmMember;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{NamingKt.defaultName(this.$requestAlgorithmMember)};
                        this.$writer.write("it.#L?.value == null", objectArray);
                    }
                });
                object = kotlinWriter;
                if (kotlinWriter != null) break block10;
            }
            Object[] objectArray = new Object[]{interceptorSymbol, inputSymbol};
            object = (KotlinWriter)writer.write("op.interceptors.add(#T<#T>())", objectArray);
        }
    }

    private static final void render$lambda$1(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        this$0.renderProperties($writer);
    }

    private static final void render$lambda$2(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        this$0.renderInit($writer);
    }

    private static final void render$lambda$6(List $operations, HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        Intrinsics.checkNotNullParameter((Object)$operations, (String)"$operations");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Set appliedMiddleware = new LinkedHashSet();
        Iterable $this$forEach$iv = $operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape op = (OperationShape)element$iv;
            boolean bl = false;
            Iterable $this$filterTo$iv = this$0.middleware;
            boolean $i$f$filterTo = false;
            for (Object element$iv2 : $this$filterTo$iv) {
                ProtocolMiddleware it = (ProtocolMiddleware)element$iv2;
                boolean bl2 = false;
                ProtocolGenerator.GenerationContext generationContext = this$0.ctx;
                Intrinsics.checkNotNullExpressionValue((Object)op, (String)"op");
                if (!it.isEnabledFor(generationContext, op)) continue;
                ((Collection)appliedMiddleware).add(element$iv2);
            }
        }
        $this$forEach$iv = appliedMiddleware;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolMiddleware it = (ProtocolMiddleware)element$iv;
            boolean bl = false;
            it.renderProperties($writer);
        }
    }

    private static final void render$lambda$8(List $operations, HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $operationsIndex) {
        Intrinsics.checkNotNullParameter((Object)$operations, (String)"$operations");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Iterable $this$forEach$iv = $operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape op = (OperationShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$operationsIndex, (String)"operationsIndex");
            Intrinsics.checkNotNullExpressionValue((Object)op, (String)"op");
            this$0.renderOperationBody($writer, $operationsIndex, op);
        }
    }

    private static final void render$lambda$9(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        this$0.renderClose($writer);
    }

    private static final void render$lambda$10(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        this$0.renderAdditionalMethods($writer);
    }

    private static final void renderOperationBody$lambda$11(HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $opIndex, OperationShape $op) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$opIndex, (String)"$opIndex");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        this$0.renderOperationSetup($writer, $opIndex, $op);
    }

    private static final void renderOperationBody$lambda$12(HttpProtocolClientGenerator this$0, OperationShape $op, KotlinWriter $writer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        this$0.renderOperationMiddleware($op, $writer);
    }

    private static final void renderOperationBody$lambda$13(HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $opIndex, OperationShape $op) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$opIndex, (String)"$opIndex");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        this$0.renderFinalizeBeforeExecute($writer, $opIndex, $op);
    }

    private static final void renderOperationBody$lambda$14(HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $opIndex, OperationShape $op) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$opIndex, (String)"$opIndex");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        this$0.renderOperationExecute($writer, $opIndex, $op);
    }

    private static final void renderOperationSetup$lambda$19$lambda$16$lambda$15(KotlinWriter $writer, HttpTrait $httpTrait) {
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$httpTrait, (String)"$httpTrait");
        $writer.write("val builder = HttpRequestBuilder()", new Object[0]);
        Object[] objectArray = new Object[1];
        String string = $httpTrait.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpTrait.method");
        Intrinsics.checkNotNullExpressionValue((Object)string.toUpperCase(Locale.ROOT), (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        $writer.write("builder.method = HttpMethod.#L", objectArray);
        objectArray = new Object[]{$httpTrait.getUri().toString()};
        $writer.write("builder.url.path = #S", objectArray);
        $writer.write("return builder", new Object[0]);
    }

    private static final void renderOperationSetup$lambda$19$lambda$16(KotlinWriter $writer, HttpTrait $httpTrait) {
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$httpTrait, (String)"$httpTrait");
        $writer.openBlock("override suspend fun serialize(context: ExecutionContext, input: #Q): HttpRequestBuilder {", "}", KotlinTypes.INSTANCE.getUnit(), () -> HttpProtocolClientGenerator.renderOperationSetup$lambda$19$lambda$16$lambda$15($writer, $httpTrait));
    }

    private static final void renderOperationSetup$lambda$19$lambda$18(KotlinWriter $writer, HttpTrait $httpTrait, OperationShape $op, Optional $inputShape) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
            Intrinsics.checkNotNullParameter((Object)$httpTrait, (String)"$httpTrait");
            Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
            $writer.write("expectedHttpStatus = " + $httpTrait.getCode(), new Object[0]);
            Object[] objectArray = new Object[]{$op.getId().getName()};
            $writer.write("operationName = #S", objectArray);
            Shape $this$getTrait$iv = (Shape)$op;
            boolean $i$f$getTrait = false;
            Optional optional = $this$getTrait$iv.getTrait(EndpointTrait.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(T::class.java)");
            EndpointTrait endpointTrait = (EndpointTrait)((Trait)OptionalExtKt.getOrNull(optional));
            if (endpointTrait == null) break block0;
            EndpointTrait endpointTrait2 = endpointTrait;
            boolean bl = false;
            List list = endpointTrait2.getHostPrefix().getSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"endpointTrait.hostPrefix.segments");
            String hostPrefix2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<SmithyPattern.Segment, CharSequence>((Optional<StructureShape>)$inputShape){
                final /* synthetic */ Optional<StructureShape> $inputShape;
                {
                    this.$inputShape = $inputShape;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(SmithyPattern.Segment segment) {
                    CharSequence charSequence;
                    if (segment.isLabel()) {
                        T element$iv2;
                        block3: {
                            Collection collection = this.$inputShape.get().members();
                            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"inputShape.get().members()");
                            Iterable $this$first$iv = collection;
                            boolean $i$f$first = false;
                            for (T element$iv2 : $this$first$iv) {
                                MemberShape member = (MemberShape)element$iv2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)member.getMemberName(), (Object)segment.getContent())) continue;
                                break block3;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        MemberShape member = (MemberShape)element$iv2;
                        StringBuilder stringBuilder = new StringBuilder().append("${input.");
                        Intrinsics.checkNotNullExpressionValue((Object)member, (String)"member");
                        charSequence = stringBuilder.append(NamingKt.defaultName(member)).append('}').toString();
                    } else {
                        String string = segment.getContent();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n                      \u2026                        }");
                        charSequence = string;
                    }
                    return charSequence;
                }
            }), (int)30, null);
            Object[] objectArray2 = new Object[]{hostPrefix2};
            $writer.write("hostPrefix = #S", objectArray2);
        }
    }

    private static final void renderOperationSetup$lambda$19(Optional $inputShape, KotlinWriter $writer, OperationShape $op, HttpTrait $httpTrait, Optional $outputShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)$httpTrait, (String)"$httpTrait");
        if ($inputShape.isPresent()) {
            $writer.write("serializer = " + SerdeExtKt.serializerName($op) + "()", new Object[0]);
        } else {
            KotlinWriter.addImport$default($writer, RuntimeTypes.Http.Request.INSTANCE.getHttpRequestBuilder(), null, 2, null);
            KotlinWriter.addImport$default($writer, RuntimeTypes.Core.INSTANCE.getExecutionContext(), null, 2, null);
            $writer.openBlock("serializer = object : HttpSerialize<#Q> {", "}", KotlinTypes.INSTANCE.getUnit(), () -> HttpProtocolClientGenerator.renderOperationSetup$lambda$19$lambda$16($writer, $httpTrait));
        }
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)$writer, OperationDeserializerBinding.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(OperationDeserializerBinding.INSTANCE.getOperation(), (Object)$op)), (Function1)new Function1<KotlinWriter, Unit>((Optional<StructureShape>)$outputShape, $op){
            final /* synthetic */ Optional<StructureShape> $outputShape;
            final /* synthetic */ OperationShape $op;
            {
                this.$outputShape = $outputShape;
                this.$op = $op;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
                if (this.$outputShape.isPresent()) {
                    $this$declareSection.write("deserializer = " + SerdeExtKt.deserializerName(this.$op) + "()", new Object[0]);
                } else {
                    $this$declareSection.write("deserializer = UnitDeserializer", new Object[0]);
                }
            }
        });
        $writer.openBlock("context {", "}", () -> HttpProtocolClientGenerator.renderOperationSetup$lambda$19$lambda$18($writer, $httpTrait, $op, $inputShape));
    }

    private static final Boolean renderOperationExecute$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String ioSymbolNames$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String ioSymbolNames$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator$OperationDeserializerBinding;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "Operation", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "getOperation", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
    public static final class OperationDeserializerBinding
    implements SectionId {
        @NotNull
        public static final OperationDeserializerBinding INSTANCE = new OperationDeserializerBinding();
        @NotNull
        private static final SectionKey<OperationShape> Operation = new SectionKey("Operation");

        private OperationDeserializerBinding() {
        }

        @NotNull
        public final SectionKey<OperationShape> getOperation() {
            return Operation;
        }
    }
}

