/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolContentTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.Trait;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00132\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u00132\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpTraitResolver;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "defaultContentType", "", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/lang/String;)V", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "contentTypes", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolContentTypes;", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/model/shapes/ServiceShape;Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolContentTypes;)V", "bindingIndex", "Lsoftware/amazon/smithy/model/knowledge/HttpBindingIndex;", "topDownIndex", "Lsoftware/amazon/smithy/model/knowledge/TopDownIndex;", "bindingOperations", "", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "determineRequestContentType", "operationShape", "determineTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "member", "Lsoftware/amazon/smithy/model/shapes/ToShapeId;", "location", "Lsoftware/amazon/smithy/model/knowledge/HttpBinding$Location;", "defaultFormat", "httpTrait", "Lsoftware/amazon/smithy/model/traits/HttpTrait;", "requestBindings", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingDescriptor;", "responseBindings", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "smithy-kotlin-codegen"})
public final class HttpTraitResolver
implements HttpBindingResolver {
    @NotNull
    private final Model model;
    @NotNull
    private final ServiceShape serviceShape;
    @NotNull
    private final ProtocolContentTypes contentTypes;
    @NotNull
    private final HttpBindingIndex bindingIndex;
    @NotNull
    private final TopDownIndex topDownIndex;

    public HttpTraitResolver(@NotNull Model model, @NotNull ServiceShape serviceShape2, @NotNull ProtocolContentTypes contentTypes) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape2, (String)"serviceShape");
        Intrinsics.checkNotNullParameter((Object)contentTypes, (String)"contentTypes");
        this.model = model;
        this.serviceShape = serviceShape2;
        this.contentTypes = contentTypes;
        HttpBindingIndex httpBindingIndex = HttpBindingIndex.of((Model)this.model);
        Intrinsics.checkNotNullExpressionValue((Object)httpBindingIndex, (String)"of(model)");
        this.bindingIndex = httpBindingIndex;
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        Intrinsics.checkNotNullExpressionValue((Object)topDownIndex, (String)"of(model)");
        this.topDownIndex = topDownIndex;
    }

    public HttpTraitResolver(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull String defaultContentType) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)defaultContentType, (String)"defaultContentType");
        this(ctx.getModel(), ctx.getService(), ProtocolContentTypes.Companion.consistent(defaultContentType));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<OperationShape> bindingOperations() {
        void $this$filterTo$iv$iv;
        Set set = this.topDownIndex.getContainedOperations((ToShapeId)this.serviceShape);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"topDownIndex\n        .ge\u2026dOperations(serviceShape)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OperationShape op = (OperationShape)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)op, (String)"op");
            Shape $this$hasTrait$iv = (Shape)op;
            boolean $i$f$hasTrait = false;
            if (!$this$hasTrait$iv.hasTrait(HttpTrait.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public HttpTrait httpTrait(@NotNull OperationShape operationShape2) {
        Intrinsics.checkNotNullParameter((Object)operationShape2, (String)"operationShape");
        Shape $this$expectTrait$iv = (Shape)operationShape2;
        boolean $i$f$expectTrait = false;
        Trait trait = $this$expectTrait$iv.expectTrait(HttpTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(T::class.java)");
        return (HttpTrait)trait;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpBindingDescriptor> requestBindings(@NotNull OperationShape operationShape2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)operationShape2, (String)"operationShape");
        Iterable $this$map$iv = this.bindingIndex.getRequestBindings((ToShapeId)operationShape2).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HttpBinding httpBinding = (HttpBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(new HttpBindingDescriptor((HttpBinding)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<HttpBindingDescriptor> responseBindings(@NotNull Shape shape) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape shape2 = shape;
        if (shape2 instanceof OperationShape ? true : shape2 instanceof StructureShape) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.bindingIndex.getResponseBindings((ToShapeId)shape.toShapeId()).values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HttpBinding httpBinding = (HttpBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(new HttpBindingDescriptor((HttpBinding)it));
            }
        } else {
            throw new IllegalStateException(new Function0<String>(shape){
                final /* synthetic */ Shape $shape;
                {
                    this.$shape = $shape;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unimplemented resolving bindings for " + this.$shape.getClass().getCanonicalName();
                }
            }.toString());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String determineRequestContentType(@NotNull OperationShape operationShape2) {
        Intrinsics.checkNotNullParameter((Object)operationShape2, (String)"operationShape");
        Optional optional = this.bindingIndex.determineRequestContentType((ToShapeId)operationShape2, this.contentTypes.getRequestContentType(), this.contentTypes.getEventStreamContentType());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"bindingIndex\n        .de\u2026s.eventStreamContentType)");
        return (String)OptionalExtKt.getOrNull(optional);
    }

    @Override
    @NotNull
    public TimestampFormatTrait.Format determineTimestampFormat(@NotNull ToShapeId member, @NotNull HttpBinding.Location location, @NotNull TimestampFormatTrait.Format defaultFormat) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)defaultFormat, (String)"defaultFormat");
        TimestampFormatTrait.Format format = this.bindingIndex.determineTimestampFormat(member, location, defaultFormat);
        Intrinsics.checkNotNullExpressionValue((Object)format, (String)"bindingIndex.determineTi\u2026 location, defaultFormat)");
        return format;
    }
}

