/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.aws.protocols;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.protocols.RestXmlTrait;
import software.amazon.smithy.kotlin.codegen.aws.protocols.RestXmlParserGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.RestXmlSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.core.AwsHttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpTraitResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolContentTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataParserGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataSerializerGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TimestampFormatTrait;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/RestXml;", "Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator;", "<init>", "()V", "protocol", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "getProtocol", "()Lsoftware/amazon/smithy/model/shapes/ShapeId;", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getProtocolHttpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "renderContentTypeHeader", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "resolver", "structuredDataParser", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataParserGenerator;", "structuredDataSerializer", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataSerializerGenerator;", "renderDeserializeErrorDetails", "smithy-aws-kotlin-codegen"})
public class RestXml
extends AwsHttpBindingProtocolGenerator {
    @NotNull
    private final ShapeId protocol;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public RestXml() {
        ShapeId shapeId = RestXmlTrait.ID;
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"ID");
        this.protocol = shapeId;
        this.defaultTimestampFormat = TimestampFormatTrait.Format.DATE_TIME;
    }

    @NotNull
    public ShapeId getProtocol() {
        return this.protocol;
    }

    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @NotNull
    public HttpBindingResolver getProtocolHttpBindingResolver(@NotNull Model model, @NotNull ServiceShape serviceShape) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
        return (HttpBindingResolver)new HttpTraitResolver(model, serviceShape, ProtocolContentTypes.Companion.consistent("application/xml"));
    }

    protected void renderContentTypeHeader(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer, @NotNull HttpBindingResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        if (ShapeExtKt.payloadIsUnionShape((OperationShape)op, (Model)ctx.getModel())) {
            Object[] objectArray = new Object[]{resolver.determineRequestContentType(op)};
            writer.write((Object)"builder.headers.setMissing(\"Content-Type\", #S)", objectArray);
        } else {
            super.renderContentTypeHeader(ctx, op, writer, resolver);
        }
    }

    @NotNull
    public StructuredDataParserGenerator structuredDataParser(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (StructuredDataParserGenerator)new RestXmlParserGenerator(this);
    }

    @NotNull
    public StructuredDataSerializerGenerator structuredDataSerializer(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return (StructuredDataSerializerGenerator)new RestXmlSerializerGenerator(this, this.getDefaultTimestampFormat());
    }

    @Override
    public void renderDeserializeErrorDetails(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write((Object)"checkNotNull(payload){ \"unable to parse error from empty response\" }", new Object[0]);
        Object[] objectArray = new Object[]{RuntimeTypes.AwsXmlProtocols.INSTANCE.getParseRestXmlErrorResponse()};
        writer.write((Object)"#T(payload)", objectArray);
    }
}

