/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.plugin;

import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsCachedCredentialsProvider;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsCachedCredentialsProviderImpl;
import software.amazon.awssdk.s3accessgrants.plugin.Builder;
import software.amazon.awssdk.s3accessgrants.plugin.S3AccessGrantsAuthSchemeProvider;
import software.amazon.awssdk.s3accessgrants.plugin.S3AccessGrantsIdentityProvider;
import software.amazon.awssdk.s3accessgrants.plugin.internal.S3AccessGrantsUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3ServiceClientConfiguration;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsAsyncClientBuilder;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3AccessGrantsPlugin
implements SdkPlugin,
ToCopyableBuilder<Builder, S3AccessGrantsPlugin> {
    private boolean enableFallback;

    S3AccessGrantsPlugin(BuilderImpl builder) {
        this.enableFallback = builder.enableFallback;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Builder builder(S3AccessGrantsPlugin plugin) {
        return new BuilderImpl(plugin);
    }

    boolean enableFallback() {
        return this.enableFallback;
    }

    public void configureClient(SdkServiceClientConfiguration.Builder config) {
        S3AccessGrantsUtils.logger.info(() -> "Configuring S3 Clients to use S3 Access Grants as a permission layer!");
        S3AccessGrantsUtils.logger.info(() -> "Running the S3 Access grants plugin with fallback setting enabled : " + this.enableFallback());
        if (!this.enableFallback()) {
            S3AccessGrantsUtils.logger.warn(() -> "Fallback not opted in! S3 Client will not fall back to evaluate policies if permissions are not provided through S3 Access Grants!");
        }
        S3ServiceClientConfiguration.Builder serviceClientConfiguration = (S3ServiceClientConfiguration.Builder)Validate.isInstanceOf(S3ServiceClientConfiguration.Builder.class, (Object)config, (String)"Expecting the plugin to be only configured on s3 clients", (Object[])new Object[0]);
        Boolean enableCrossRegionAccess = this.fetchFallbackConfiguration(serviceClientConfiguration);
        S3AccessGrantsUtils.logger.info(() -> "Running the S3 Access grants plugin with cross-region setting enabled : " + enableCrossRegionAccess);
        if (!enableCrossRegionAccess.booleanValue()) {
            S3AccessGrantsUtils.logger.warn(() -> "cross-region access not opted in! S3 Client will not be able to communicate with buckets outside the configured region!");
        }
        S3ControlAsyncClientBuilder s3ControlAsyncClientBuilder = (S3ControlAsyncClientBuilder)S3ControlAsyncClient.builder().credentialsProvider(serviceClientConfiguration.credentialsProvider());
        S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().crossRegionAccessEnabled(Boolean.valueOf(true))).credentialsProvider(serviceClientConfiguration.credentialsProvider())).region(serviceClientConfiguration.region())).build();
        serviceClientConfiguration.authSchemeProvider((S3AuthSchemeProvider)new S3AccessGrantsAuthSchemeProvider(serviceClientConfiguration.authSchemeProvider(), s3Client, enableCrossRegionAccess));
        S3AccessGrantsCachedCredentialsProvider cache = this.createAccessGrantsCache();
        ConcurrentHashMap<Region, S3ControlAsyncClient> clientsCache = new ConcurrentHashMap<Region, S3ControlAsyncClient>();
        StsAsyncClient stsClient = (StsAsyncClient)((StsAsyncClientBuilder)((StsAsyncClientBuilder)StsAsyncClient.builder().credentialsProvider(serviceClientConfiguration.credentialsProvider())).region(serviceClientConfiguration.region())).build();
        MetricPublisher metricPublisher = config.overrideConfiguration() != null ? (config.overrideConfiguration().metricPublishers() != null ? (config.overrideConfiguration().metricPublishers().size() > 0 ? (MetricPublisher)config.overrideConfiguration().metricPublishers().get(0) : null) : null) : null;
        serviceClientConfiguration.credentialsProvider((IdentityProvider)new S3AccessGrantsIdentityProvider((IdentityProvider<? extends AwsCredentialsIdentity>)serviceClientConfiguration.credentialsProvider(), stsClient, S3AccessGrantsUtils.DEFAULT_PRIVILEGE_FOR_PLUGIN, S3AccessGrantsUtils.DEFAULT_CACHE_SETTING, s3ControlAsyncClientBuilder, cache, this.enableFallback, metricPublisher, clientsCache));
        S3AccessGrantsUtils.logger.debug(() -> "Completed configuring S3 Clients to use S3 Access Grants as a permission layer!");
    }

    private S3AccessGrantsCachedCredentialsProvider createAccessGrantsCache() {
        return S3AccessGrantsCachedCredentialsProviderImpl.builder().build();
    }

    private Boolean fetchFallbackConfiguration(S3ServiceClientConfiguration.Builder serviceClientConfiguration) {
        return serviceClientConfiguration.crossRegionAccessEnabled() != null ? serviceClientConfiguration.crossRegionAccessEnabled() : S3AccessGrantsUtils.DEFAULT_CROSS_REGION_ACCESS_SETTING;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static final class BuilderImpl
    implements Builder {
        private boolean enableFallback;

        BuilderImpl() {
            this.enableFallback = S3AccessGrantsUtils.DEFAULT_FALLBACK_SETTING;
        }

        BuilderImpl(S3AccessGrantsPlugin plugin) {
            this.enableFallback = plugin.enableFallback;
        }

        public S3AccessGrantsPlugin build() {
            return new S3AccessGrantsPlugin(this);
        }

        @Override
        public Builder enableFallback(@NotNull Boolean choice) {
            this.enableFallback = choice == null ? S3AccessGrantsUtils.DEFAULT_FALLBACK_SETTING : choice;
            return this;
        }
    }
}

