/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ExecutionResult;
import com.amazon.rdsdata.client.FieldPropertyWriter;
import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.MappingOptions;
import com.amazon.rdsdata.client.ObjectWriter;
import com.amazon.rdsdata.client.PropertyWriter;
import com.amazon.rdsdata.client.SetterPropertyWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;

class PropertyObjectWriter<T>
extends ObjectWriter<T> {
    private final Class<T> mapperClass;
    private final List<String> fieldNames;
    private final MappingOptions mappingOptions;

    public static <T> ObjectWriter<T> create(Class<T> mapperClass, List<String> fieldNames, MappingOptions mappingOptions) {
        return new PropertyObjectWriter<T>(mapperClass, fieldNames, mappingOptions);
    }

    @Override
    public T write(ExecutionResult.Row row) {
        Constructor<T> constructor = this.findNoArgsConstructor().orElseThrow(() -> MappingException.cannotCreateInstanceViaNoArgsConstructor(this.mapperClass));
        T instance = this.createInstance(constructor);
        this.setAllProperties(instance, row);
        return instance;
    }

    private Optional<Constructor<T>> findNoArgsConstructor() {
        try {
            return Optional.of(this.mapperClass.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private T createInstance(Constructor<T> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw MappingException.cannotCreateInstance(constructor.getDeclaringClass(), e);
        }
    }

    private void setAllProperties(T instance, ExecutionResult.Row row) {
        int i = 0;
        while (i < this.fieldNames.size()) {
            String name = this.fieldNames.get(i);
            int index = i++;
            this.findPropertyWriter(instance, name).ifPresent(field -> this.setProperty((PropertyWriter)field, row, index));
        }
    }

    private void setProperty(PropertyWriter propertyWriter, ExecutionResult.Row row, int index) {
        Object value = row.getValue(index, propertyWriter.getType());
        propertyWriter.write(value);
    }

    private Optional<PropertyWriter> findPropertyWriter(Object instance, String fieldName) {
        Optional result = SetterPropertyWriter.setterPropertyWriterFor(instance, fieldName).map(Optional::of).orElseGet(() -> FieldPropertyWriter.fieldPropertyWriterFor(instance, fieldName));
        if (!result.isPresent() && !this.mappingOptions.ignoreMissingSetters) {
            throw MappingException.noFieldOrSetter(instance.getClass(), fieldName);
        }
        return result;
    }

    public PropertyObjectWriter(Class<T> mapperClass, List<String> fieldNames, MappingOptions mappingOptions) {
        this.mapperClass = mapperClass;
        this.fieldNames = fieldNames;
        this.mappingOptions = mappingOptions;
    }
}

