/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ConstructorObjectWriter;
import com.amazon.rdsdata.client.EmptyResultSetException;
import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.MappingOptions;
import com.amazon.rdsdata.client.ObjectWriter;
import com.amazon.rdsdata.client.PropertyObjectWriter;
import com.amazon.rdsdata.client.TypeConverter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rdsdata.model.ColumnMetadata;
import software.amazon.awssdk.services.rdsdata.model.Field;

public class ExecutionResult {
    private final List<String> fieldNames;
    private final List<Row> rows;
    private final Long numberOfRecordsUpdated;
    private final MappingOptions mappingOptions;

    ExecutionResult(List<ColumnMetadata> metadata, List<List<Field>> fields, Long numberOfRecordsUpdated, MappingOptions mappingOptions) {
        this.rows = this.convertToRows(fields);
        this.numberOfRecordsUpdated = numberOfRecordsUpdated;
        this.mappingOptions = mappingOptions;
        this.fieldNames = this.extractFieldNames(metadata);
    }

    private List<String> extractFieldNames(List<ColumnMetadata> metadata) {
        if (metadata == null) {
            return Collections.emptyList();
        }
        return metadata.stream().map(this::getFieldName).collect(Collectors.toList());
    }

    private String getFieldName(ColumnMetadata columnMetadata) {
        if (this.mappingOptions.useLabelForMapping) {
            return columnMetadata.label();
        }
        return columnMetadata.name();
    }

    private List<Row> convertToRows(List<List<Field>> records) {
        if (records == null) {
            return Collections.emptyList();
        }
        return records.stream().map(Row::new).collect(Collectors.toList());
    }

    public Long getNumberOfRecordsUpdated() {
        return this.numberOfRecordsUpdated;
    }

    public <T> T mapToSingle(Class<T> mapperClass) {
        if (this.rows.isEmpty()) {
            throw MappingException.emptyResultSet();
        }
        return this.mapToSingle(mapperClass, this.fieldNames, this.rows.get(0));
    }

    private <T> T mapToSingle(Class<T> mapperClass, List<String> fieldNames, Row row) {
        ObjectWriter writer = ConstructorObjectWriter.create(mapperClass, fieldNames).orElseGet(() -> PropertyObjectWriter.create(mapperClass, fieldNames, this.mappingOptions));
        return writer.write(row);
    }

    public <T> List<T> mapToList(Class<T> mapperClass) {
        return this.rows.stream().map(row -> this.mapToSingle(mapperClass, this.fieldNames, (Row)row)).collect(Collectors.toList());
    }

    public <T> T singleValue(Class<T> convertToType) {
        if (this.rows.size() == 0 || this.rows.get(0).columnCount() == 0) {
            throw new EmptyResultSetException();
        }
        return this.rows.get(0).getValue(0, convertToType);
    }

    static class Row {
        private List<Field> fields;

        public <T> T getValue(int index, Class<T> type) {
            return (T)TypeConverter.fromField(this.fields.get(index), type);
        }

        public int columnCount() {
            return this.fields.size();
        }

        public Row(List<Field> fields) {
            this.fields = fields;
        }
    }
}

