/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ExecutionResult;
import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.ObjectWriter;
import com.amazon.rdsdata.client.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;

class FieldObjectWriter<T>
extends ObjectWriter<T> {
    private final Class<T> mapperClass;
    private final List<String> fieldNames;

    public static <T> ObjectWriter<T> create(Class<T> mapperClass, List<String> fieldNames) {
        return new FieldObjectWriter<T>(mapperClass, fieldNames);
    }

    @Override
    public T write(ExecutionResult.Row row) {
        Constructor<T> constructor = this.findNoArgsConstructor().orElseThrow(() -> MappingException.cannotCreateInstanceViaNoArgsConstructor(this.mapperClass));
        T instance = this.createInstance(constructor);
        this.populate(instance, row);
        return instance;
    }

    private Optional<Constructor<T>> findNoArgsConstructor() {
        try {
            return Optional.of(this.mapperClass.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    private T createInstance(Constructor<T> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw MappingException.cannotCreateInstance(constructor.getDeclaringClass(), e);
        }
    }

    private void populate(T instance, ExecutionResult.Row row) {
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String name = this.fieldNames.get(i);
            Writer field = Writer.forName(instance, name);
            Object value = row.getValue(i, field.getType());
            field.setValue(value);
        }
    }

    public FieldObjectWriter(Class<T> mapperClass, List<String> fieldNames) {
        this.mapperClass = mapperClass;
        this.fieldNames = fieldNames;
    }
}

