/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.services.qldbsession.model.ExecuteStatementResult;
import software.amazon.awssdk.utils.Validate;
import software.amazon.qldb.QldbHash;
import software.amazon.qldb.Result;
import software.amazon.qldb.Session;
import software.amazon.qldb.StreamResult;
import software.amazon.qldb.exceptions.Errors;

@NotThreadSafe
class Transaction {
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    private final Session session;
    private final String txnId;
    private final IonSystem ionSystem;
    private QldbHash txnHash;
    private final int readAheadBufferCount;
    private final ExecutorService executorService;
    private final Deque<StreamResult> results;

    Transaction(Session session, String txnId, int readAheadBufferCount, IonSystem ionSystem, ExecutorService executorService) {
        Validate.notNull((Object)session, (String)"session", (Object[])new Object[0]);
        Validate.notNull((Object)txnId, (String)"txnId", (Object[])new Object[0]);
        Validate.isNotNegative((int)readAheadBufferCount, (String)"readAheadBufferCount");
        this.session = session;
        this.txnId = txnId;
        this.txnHash = QldbHash.toQldbHash(this.txnId, ionSystem);
        this.ionSystem = ionSystem;
        this.readAheadBufferCount = readAheadBufferCount;
        this.executorService = executorService;
        this.results = new ArrayDeque<StreamResult>();
    }

    void abort() {
        this.internalClose();
        this.session.sendAbort();
    }

    void commit() {
        ByteBuffer hashByteBuffer = ByteBuffer.wrap(this.getTransactionHash().getQldbHash());
        ByteBuffer commitDigest = this.session.sendCommit(this.txnId, hashByteBuffer).commitDigest().asByteBuffer();
        if (!commitDigest.equals(hashByteBuffer)) {
            logger.error(Errors.TXN_DIGEST_MISMATCH.get());
            throw new IllegalStateException(Errors.TXN_DIGEST_MISMATCH.get());
        }
    }

    Result execute(String statement) {
        return this.execute(statement, Collections.emptyList());
    }

    Result execute(String statement, List<IonValue> parameters) {
        Validate.paramNotBlank((CharSequence)statement, (String)"statement");
        Validate.notNull(parameters, (String)"parameters", (Object[])new Object[0]);
        this.setTransactionHash(Transaction.dot(this.getTransactionHash(), statement, parameters, this.ionSystem));
        ExecuteStatementResult executeStatementResult = this.session.sendExecute(statement, parameters, this.txnId);
        StreamResult result = new StreamResult(this.session, executeStatementResult, this.txnId, this.readAheadBufferCount, this.ionSystem, this.executorService);
        this.results.add(result);
        return result;
    }

    Result execute(String statement, IonValue ... parameters) {
        Validate.notNull((Object)parameters, (String)"parameters", (Object[])new Object[0]);
        return this.execute(statement, Arrays.asList(parameters));
    }

    void internalClose() {
        while (!this.results.isEmpty()) {
            this.results.pop().close();
        }
    }

    String getTransactionId() {
        return this.txnId;
    }

    static QldbHash dot(QldbHash seed, String statement, List<IonValue> parameters, IonSystem ionSystem) {
        QldbHash statementHash = QldbHash.toQldbHash(statement, ionSystem);
        for (IonValue param : parameters) {
            statementHash = statementHash.dot(QldbHash.toQldbHash(param, ionSystem));
        }
        return seed.dot(statementHash);
    }

    QldbHash getTransactionHash() {
        return this.txnHash;
    }

    private void setTransactionHash(QldbHash hash) {
        this.txnHash = hash;
    }
}

