/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.qldbsession.QldbSessionClient;
import software.amazon.awssdk.services.qldbsession.model.AbortTransactionRequest;
import software.amazon.awssdk.services.qldbsession.model.AbortTransactionResult;
import software.amazon.awssdk.services.qldbsession.model.CommitTransactionRequest;
import software.amazon.awssdk.services.qldbsession.model.CommitTransactionResult;
import software.amazon.awssdk.services.qldbsession.model.EndSessionRequest;
import software.amazon.awssdk.services.qldbsession.model.EndSessionResult;
import software.amazon.awssdk.services.qldbsession.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.qldbsession.model.ExecuteStatementResult;
import software.amazon.awssdk.services.qldbsession.model.FetchPageRequest;
import software.amazon.awssdk.services.qldbsession.model.FetchPageResult;
import software.amazon.awssdk.services.qldbsession.model.SendCommandRequest;
import software.amazon.awssdk.services.qldbsession.model.SendCommandResponse;
import software.amazon.awssdk.services.qldbsession.model.StartSessionRequest;
import software.amazon.awssdk.services.qldbsession.model.StartTransactionRequest;
import software.amazon.awssdk.services.qldbsession.model.StartTransactionResult;
import software.amazon.awssdk.services.qldbsession.model.ValueHolder;
import software.amazon.qldb.exceptions.Errors;
import software.amazon.qldb.exceptions.QldbDriverException;

@ThreadSafe
class Session
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private final String ledgerName;
    private final String sessionToken;
    private final String sessionId;
    private final QldbSessionClient client;

    private Session(String ledgerName, String sessionToken, String sessionId, QldbSessionClient client) {
        this.ledgerName = ledgerName;
        this.client = client;
        this.sessionToken = sessionToken;
        this.sessionId = sessionId;
    }

    static Session startSession(String ledgerName, QldbSessionClient client) {
        StartSessionRequest request = (StartSessionRequest)StartSessionRequest.builder().ledgerName(ledgerName).build();
        SendCommandRequest command = (SendCommandRequest)SendCommandRequest.builder().startSession(request).build();
        logger.debug("Sending start session request: {}", (Object)command);
        SendCommandResponse result = client.sendCommand(command);
        String sessionToken = result.startSession().sessionToken();
        String sessionId = result.responseMetadata().requestId();
        return new Session(ledgerName, sessionToken, sessionId, client);
    }

    @Override
    public void close() {
        try {
            this.sendEndSession();
        }
        catch (SdkServiceException e) {
            logger.warn("Errors closing session: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    String getId() {
        return this.sessionId;
    }

    String getToken() {
        return this.sessionToken;
    }

    AbortTransactionResult sendAbort() {
        AbortTransactionRequest request = (AbortTransactionRequest)AbortTransactionRequest.builder().build();
        SendCommandResponse result = this.send(SendCommandRequest.builder().abortTransaction(request));
        return result.abortTransaction();
    }

    CommitTransactionResult sendCommit(String txnId, ByteBuffer transactionDigest) {
        CommitTransactionRequest request = (CommitTransactionRequest)CommitTransactionRequest.builder().transactionId(txnId).commitDigest(SdkBytes.fromByteBuffer((ByteBuffer)transactionDigest)).build();
        SendCommandResponse result = this.send(SendCommandRequest.builder().commitTransaction(request));
        return result.commitTransaction();
    }

    EndSessionResult sendEndSession() {
        EndSessionRequest request = (EndSessionRequest)EndSessionRequest.builder().build();
        SendCommandResponse result = this.send(SendCommandRequest.builder().endSession(request));
        return result.endSession();
    }

    ExecuteStatementResult sendExecute(String statement, List<IonValue> parameters, String txnId) {
        ArrayList<ValueHolder> byteParameters = new ArrayList<ValueHolder>(parameters.size());
        if (!parameters.isEmpty()) {
            try {
                IonBinaryWriterBuilder builder = IonBinaryWriterBuilder.standard();
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                IonWriter writer = builder.build((OutputStream)stream);
                for (IonValue parameter : parameters) {
                    parameter.writeTo(writer);
                    writer.finish();
                    SdkBytes sdkBytes = SdkBytes.fromByteArray((byte[])stream.toByteArray());
                    ValueHolder value = (ValueHolder)ValueHolder.builder().ionBinary(sdkBytes).build();
                    byteParameters.add(value);
                    stream.reset();
                }
            }
            catch (IOException e) {
                throw QldbDriverException.create(String.format(Errors.SERIALIZING_PARAMS.get(), e.getMessage()), e);
            }
        }
        ExecuteStatementRequest request = (ExecuteStatementRequest)ExecuteStatementRequest.builder().statement(statement).parameters(byteParameters).transactionId(txnId).build();
        SendCommandResponse result = this.send(SendCommandRequest.builder().executeStatement(request));
        return result.executeStatement();
    }

    FetchPageResult sendFetchPage(String txnId, String nextPageToken) {
        FetchPageRequest request = (FetchPageRequest)FetchPageRequest.builder().transactionId(txnId).nextPageToken(nextPageToken).build();
        SendCommandResponse result = this.send(SendCommandRequest.builder().fetchPage(request));
        return result.fetchPage();
    }

    StartTransactionResult sendStartTransaction() {
        StartTransactionRequest request = (StartTransactionRequest)StartTransactionRequest.builder().build();
        SendCommandRequest.Builder command = SendCommandRequest.builder().startTransaction(request);
        SendCommandResponse result = this.send(command);
        return result.startTransaction();
    }

    private SendCommandResponse send(SendCommandRequest.Builder request) {
        SendCommandRequest command = (SendCommandRequest)request.sessionToken(this.sessionToken).build();
        logger.debug("Sending request: {}", (Object)command);
        return this.client.sendCommand(command);
    }
}

