/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.qldbsession.model.InvalidSessionException;
import software.amazon.awssdk.services.qldbsession.model.OccConflictException;
import software.amazon.awssdk.services.qldbsession.model.QldbSessionException;
import software.amazon.awssdk.services.qldbsession.model.StartTransactionResult;
import software.amazon.qldb.BufferedResult;
import software.amazon.qldb.Executor;
import software.amazon.qldb.Result;
import software.amazon.qldb.Session;
import software.amazon.qldb.StreamResult;
import software.amazon.qldb.Transaction;
import software.amazon.qldb.TransactionExecutor;
import software.amazon.qldb.exceptions.ExecuteException;

@NotThreadSafe
class QldbSession {
    private static final Logger logger = LoggerFactory.getLogger(QldbSession.class);
    private final int readAhead;
    private final ExecutorService executorService;
    private Session session;
    private final IonSystem ionSystem;

    QldbSession(Session session, int readAhead, IonSystem ionSystem, ExecutorService executorService) {
        this.ionSystem = ionSystem;
        this.session = session;
        this.readAhead = readAhead;
        this.executorService = executorService;
    }

    void close() {
        this.session.close();
    }

    <T> T execute(Executor<T> executor) {
        Transaction txn = null;
        String txnId = "None";
        try {
            txn = this.startTransaction();
            txnId = txn.getTransactionId();
            Object returnedValue = executor.execute(new TransactionExecutor(txn));
            if (returnedValue instanceof StreamResult) {
                returnedValue = new BufferedResult((Result)returnedValue);
            }
            txn.commit();
            T t = returnedValue;
            return t;
        }
        catch (InvalidSessionException ise) {
            boolean isAborted = false;
            boolean transactionExpired = ise.getMessage().matches("Transaction.*has expired.*");
            if (transactionExpired) {
                isAborted = this.tryAbort(txn);
            }
            throw new ExecuteException((RuntimeException)((Object)ise), !transactionExpired, isAborted, true, txnId);
        }
        catch (OccConflictException oce) {
            throw new ExecuteException((RuntimeException)((Object)oce), true, true, false, txnId);
        }
        catch (QldbSessionException qse) {
            boolean retryable = qse.statusCode() == 500 || qse.statusCode() == 503;
            throw new ExecuteException((RuntimeException)((Object)qse), retryable, this.tryAbort(txn), false, txnId);
        }
        catch (SdkClientException sce) {
            throw new ExecuteException((RuntimeException)((Object)sce), true, this.tryAbort(txn), false, txnId);
        }
        catch (RuntimeException re) {
            throw new ExecuteException(re, false, this.tryAbort(txn), false, txnId);
        }
        finally {
            if (txn != null) {
                txn.internalClose();
            }
        }
    }

    String getSessionId() {
        return this.session.getId();
    }

    private Transaction startTransaction() {
        StartTransactionResult startTransaction = this.session.sendStartTransaction();
        return new Transaction(this.session, startTransaction.transactionId(), this.readAhead, this.ionSystem, this.executorService);
    }

    private boolean tryAbort(Transaction txn) {
        try {
            if (txn == null) {
                this.session.sendAbort();
            } else {
                txn.abort();
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("Ignored error aborting transaction during execution.", (Throwable)e);
            return false;
        }
    }
}

