/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.services.qldbsession.model.ExecuteStatementResult;
import software.amazon.awssdk.utils.Validate;
import software.amazon.qldb.IOUsage;
import software.amazon.qldb.Result;
import software.amazon.qldb.ResultRetriever;
import software.amazon.qldb.Session;
import software.amazon.qldb.TimingInformation;
import software.amazon.qldb.exceptions.Errors;

@NotThreadSafe
class StreamResult
implements Result {
    private static final Logger logger = LoggerFactory.getLogger(StreamResult.class);
    private final AtomicBoolean isRetrieved;
    private final IonIterator childItr;
    private final boolean isEmpty;
    private final Session session;
    private final String txnId;
    private final IonSystem ionSystem;

    StreamResult(Session session, ExecuteStatementResult statementResult, String txnId, int readAheadBufferCount, IonSystem ionSystem, ExecutorService executorService) {
        this.session = session;
        this.txnId = txnId;
        this.ionSystem = ionSystem;
        this.isRetrieved = new AtomicBoolean(false);
        this.childItr = new IonIterator(session, statementResult, txnId, readAheadBufferCount, ionSystem, executorService);
        this.isEmpty = !this.childItr.hasNext();
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public IOUsage getConsumedIOs() {
        return this.childItr.retriever.getIOUsage();
    }

    @Override
    public TimingInformation getTimingInformation() {
        return this.childItr.retriever.getTimingInformation();
    }

    @Override
    public Iterator<IonValue> iterator() {
        if (this.isRetrieved.getAndSet(true)) {
            logger.error(Errors.STREAM_RESULT_ITERATED.get());
            throw new IllegalStateException(Errors.STREAM_RESULT_ITERATED.get());
        }
        return this.childItr;
    }

    void close() {
        this.childItr.close();
    }

    private static class IonIterator
    implements Iterator<IonValue> {
        private final ResultRetriever retriever;

        IonIterator(Session session, ExecuteStatementResult statementResult, String txnId, int readAhead, IonSystem ionSystem, ExecutorService executorService) {
            Validate.isNotNegative((int)readAhead, (String)"readAhead");
            software.amazon.awssdk.services.qldbsession.model.IOUsage consumedIOs = statementResult.consumedIOs();
            IOUsage ioUsage = consumedIOs != null ? new IOUsage(consumedIOs) : null;
            software.amazon.awssdk.services.qldbsession.model.TimingInformation timingInformation = statementResult.timingInformation();
            TimingInformation timingInfo = timingInformation != null ? new TimingInformation(timingInformation) : null;
            this.retriever = new ResultRetriever(session, statementResult.firstPage(), txnId, readAhead, ionSystem, executorService, ioUsage, timingInfo);
        }

        @Override
        public boolean hasNext() {
            return this.retriever.hasNext();
        }

        @Override
        public IonValue next() {
            return this.retriever.next();
        }

        void close() {
            this.retriever.close();
        }
    }
}

